/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSForwardException;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.jdbc.ERXJDBCConnectionBroker;
import er.extensions.jdbc.ERXSQLHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ERXSequence {
    protected Logger log;
    private final String _name;
    protected long _lastValue;
    protected long _maxValue;
    private static final Map cache = Collections.synchronizedMap(new HashMap());

    public ERXSequence(String name) {
        this._name = name;
        this.log = Logger.getLogger((String)name);
    }

    public ERXSequence(String name, long initialValue) {
        this(name);
        this._lastValue = initialValue;
    }

    public String name() {
        return this._name;
    }

    public long nextValue() {
        return this.nextValue(1L);
    }

    protected long maxValue() {
        return this._maxValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextValue(long increment) {
        ERXSequence eRXSequence = this;
        synchronized (eRXSequence) {
            long diff = this.lastValue() + increment - this.maxValue();
            if (diff > 0L) {
                long nextIncrement = this.increment();
                this._maxValue = this.increasedMaxValue(diff > nextIncrement ? diff : nextIncrement);
            }
            this._lastValue += increment;
            return this.lastValue();
        }
    }

    protected long lastValue() {
        return this._lastValue;
    }

    protected long increasedMaxValue(long increment) {
        return this.maxValue() + increment;
    }

    protected long increment() {
        return ERXProperties.longForKeyWithDefault(this.name() + ".Increment", ERXProperties.longForKeyWithDefault("er.extensions.ERXSequence.Increment", 10L));
    }

    public static ERXSequence sequenceWithName(String name) {
        return (ERXSequence)cache.get(name);
    }

    public static ERXSequence createSequenceWithName(String name, long initialValue) {
        ERXSequence sequence = new ERXSequence(name, initialValue);
        cache.put(name, sequence);
        return sequence;
    }

    public static ERXSequence createDatabaseSequenceWithName(EOEditingContext ec, String modelName, String name) {
        DatabaseSequence sequence = new DatabaseSequence(ec, modelName, name);
        cache.put(name, sequence);
        return sequence;
    }

    public static void registerSequenceWithName(ERXSequence sequence, String name) {
        cache.put(name, sequence);
    }

    public static class PrimaryKeySequence
    extends DatabaseSequence {
        private String _entityName;

        public PrimaryKeySequence(EOEditingContext ec, String modelName, String entityName) {
            super(ec, modelName, entityName + "_pk_seq");
            this._entityName = entityName;
        }

        protected long createRow(Connection con, long increment) throws SQLException {
            EOEntity entity = ERXEOAccessUtilities.rootEntityForEntityNamed(this._entityName);
            String tableName = entity.externalName();
            String colName = ((EOAttribute)entity.primaryKeyAttributes().lastObject()).columnName();
            String sql = "select max(" + colName + ") from " + tableName;
            ResultSet resultSet = con.createStatement().executeQuery(sql);
            con.commit();
            boolean hasNext = resultSet.next();
            long v = 0L;
            if (hasNext) {
                v = resultSet.getLong(1);
                v = this.fixMaxIdValue(v);
            }
            super.createRow(con, v + increment);
            return v;
        }

        protected long fixMaxIdValue(long v) {
            return v;
        }
    }

    public static class DatabaseSequence
    extends ERXSequence {
        private ERXJDBCConnectionBroker _broker;

        public DatabaseSequence(EOEditingContext ec, String modelName, String name, long initialValue) {
            super(name, initialValue);
            EOModel model = ERXEOAccessUtilities.modelGroup(ec).modelNamed(modelName);
            this._broker = ERXJDBCConnectionBroker.connectionBrokerForModel(model);
            this._maxValue = this._lastValue = this.increasedMaxValue(0L);
        }

        public DatabaseSequence(EOEditingContext ec, String modelName, String name) {
            this(ec, modelName, name, ERXProperties.longForKeyWithDefault(name + ".InitalValue", 100000L));
        }

        protected ERXJDBCConnectionBroker broker() {
            return this._broker;
        }

        protected long selectAndUpdateValue(Connection con, long increment) throws SQLException {
            long pk;
            String where = "where name_ = '" + this.name() + "'";
            ResultSet resultSet = con.createStatement().executeQuery("select value_ from erx_sequence_table " + where + " for update");
            boolean hasNext = resultSet.next();
            if (hasNext) {
                pk = resultSet.getLong("value_");
                con.createStatement().executeUpdate("update erx_sequence_table set value_ = value_ +" + increment + " " + where);
            } else {
                pk = this.createRow(con, increment);
            }
            return pk;
        }

        protected long createRow(Connection con, long increment) throws SQLException {
            con.createStatement().executeUpdate("insert into erx_sequence_table (name_, value_) values ('" + this.name() + "', " + increment + ")");
            return 0L;
        }

        protected void createTable(Connection con) throws SQLException {
            con.createStatement().executeUpdate("create table erx_sequence_table (name_ varchar(100) not null, value_ int)");
            con.createStatement().executeUpdate("alter table erx_sequence_table add primary key (name_)");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected long increasedMaxValue(long increment) {
            Connection con = this.broker().getConnection();
            try {
                try {
                    con.setAutoCommit(false);
                    con.setReadOnly(false);
                }
                catch (SQLException e) {
                    this.log.error((Object)e, (Throwable)e);
                }
                for (int tries = 0; tries < 5; ++tries) {
                    long l;
                    try {
                        long lastValue = this.selectAndUpdateValue(con, increment);
                        if (this._lastValue == 0L) {
                            this._lastValue = lastValue;
                        }
                        con.commit();
                        l = lastValue += increment;
                    }
                    catch (SQLException ex) {
                        if (!this.isCreationError(ex)) throw new NSForwardException((Throwable)ex, "Error fetching sequence: " + this.name());
                        try {
                            con.rollback();
                            this.createTable(con);
                            continue;
                        }
                        catch (SQLException ee) {
                            throw new NSForwardException((Throwable)ee, "could not create erx_sequence_table");
                        }
                    }
                    Object var10_8 = null;
                    this.broker().freeConnection(con);
                    return l;
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.broker().freeConnection(con);
                throw throwable;
            }
            Object var10_9 = null;
            this.broker().freeConnection(con);
            throw new IllegalStateException("Couldn't get sequence: " + this.name());
        }

        protected boolean isCreationError(SQLException ex) {
            String s = ex.getMessage().toLowerCase();
            boolean creationError = false;
            creationError |= s.indexOf("error code 116") != -1;
            creationError |= s.indexOf("erx_sequence_table") != -1 && s.indexOf("does not exist") != -1;
            creationError |= s.indexOf("ora-00942") != -1;
            creationError |= s.indexOf("doesn't exist") != -1;
            return creationError |= s.indexOf("erx_sequence_table") != -1 && s.indexOf("not found.") != -1;
        }
    }

    public static class NativeDatabaseSequence
    extends ERXSequence {
        private EOEditingContext _editingContext;
        private String _modelName;

        public NativeDatabaseSequence(EOEditingContext editingContext, String modelName, String name) {
            super(name);
            this._editingContext = editingContext;
            this._modelName = modelName;
        }

        public long nextValue(long increment) {
            if (increment != 1L) {
                throw new IllegalArgumentException("NativeDatabaseSequence only supports incrementing 1 at a time.");
            }
            return ERXSQLHelper.newSQLHelper(this._editingContext, this._modelName).getNextValFromSequenceNamed(this._editingContext, this._modelName, this.name()).longValue();
        }

        protected long increment() {
            return 1L;
        }
    }
}

