/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOSharedEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXRetainer;
import er.extensions.foundation.ERXUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXSharedEOLoader {
    public static final Logger log = Logger.getLogger((String)"er.extensions.fixes.ERSharedEOLoader");
    public static final String PatchSharedEOLoadingPropertyKey = "er.extensions.ERXSharedEOLoader.PatchSharedEOLoading";
    public static ERXSharedEOLoader _defaultLoader;
    protected static boolean _loadingComplete;
    protected NSMutableArray _modelList = new NSMutableArray();
    protected int _transCount = 0;
    protected boolean _didChangeDebugSetting = false;
    protected EOAdaptorContext _currentAdaptor;

    public static void patchSharedEOLoading() {
        if (_defaultLoader == null) {
            EODatabaseContext.setSharedObjectLoadingEnabled((boolean)false);
            _defaultLoader = new ERXSharedEOLoader();
            ERXRetainer.retain(_defaultLoader);
            log.debug((Object)"Shared EO loading patch installed.");
        }
    }

    public static void removeSharedEOLoadingPatch() {
        if (_defaultLoader != null) {
            ERXRetainer.release(_defaultLoader);
            _defaultLoader = null;
        }
        if (_loadingComplete) {
            log.debug((Object)"the patch has been removed, but after shared EO loading completed; this call had no effect");
        } else {
            log.debug((Object)"shared EO loading patch UNINSTALLED.");
        }
    }

    public ERXSharedEOLoader() {
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("modelWasAddedNotification", ERXConstant.NotificationClassArray), "EOModelAddedNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("objectStoreWasAdded", ERXConstant.NotificationClassArray), "EOCooperatingObjectStoreWasAddedNotification", null);
    }

    public void finalize() throws Throwable {
        NSNotificationCenter.defaultCenter().removeObserver((Object)this);
        super.finalize();
    }

    public void loadSharedObjectsForModel(EOModel aModel) {
        EOSharedEditingContext dsec;
        NSArray entities = aModel.entitiesWithSharedObjects();
        if (entities != null && entities.count() > 0 && (dsec = EOSharedEditingContext.defaultSharedEditingContext()) != null) {
            Enumeration e = entities.objectEnumerator();
            while (e.hasMoreElements()) {
                EOEntity entity = (EOEntity)e.nextElement();
                if (entity.sharedObjectFetchSpecificationNames().count() == 1 && entity.sharedObjectFetchSpecificationNames().lastObject().equals("FetchAll")) {
                    try {
                        EOFetchSpecification fs = entity.fetchSpecificationNamed("FetchAll");
                        dsec.bindObjectsWithFetchSpecification(fs, "FetchAll");
                        continue;
                    }
                    catch (Exception e1) {
                        log.error((Object)("Exception occurred for entity named: " + entity.name() + " in Model: " + aModel.name() + e1));
                        throw new RuntimeException(e.toString());
                    }
                }
                Enumeration ee = entity.sharedObjectFetchSpecificationNames().objectEnumerator();
                while (ee.hasMoreElements()) {
                    String fsn = (String)ee.nextElement();
                    EOFetchSpecification fs = entity.fetchSpecificationNamed(fsn);
                    if (fs == null) continue;
                    log.debug((Object)("Loading " + entity.name() + " - " + fsn));
                    dsec.bindObjectsWithFetchSpecification(fs, fsn);
                }
            }
        }
    }

    public void modelWasAddedNotification(NSNotification aNotification) {
        if (!this._modelList.containsObject(aNotification.object())) {
            log.debug((Object)("Adding model: " + ((EOModel)aNotification.object()).name()));
            this._modelList.addObject(aNotification.object());
        }
    }

    public void objectStoreWasAdded(NSNotification aNotification) {
        block9: {
            if (!_loadingComplete) {
                if (this._modelList.count() == 0) {
                    EOModelGroup group = EOModelGroup.modelGroupForObjectStoreCoordinator((EOObjectStoreCoordinator)((EOObjectStoreCoordinator)aNotification.object()));
                    if (group != null && group.models().count() == 0) {
                        throw new RuntimeException("No models found in default group");
                    }
                    this._modelList = new NSMutableArray(group.models());
                }
                _loadingComplete = true;
                EOModel currentModel = null;
                try {
                    NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("transactionBeginning", ERXConstant.NotificationClassArray), "EOAdaptorContextBeginTransactionNotification", null);
                    log.debug((Object)"Beginning loading of shared EOs");
                    NSMutableArray<String> loadedModels = new NSMutableArray<String>();
                    Enumeration e = this._modelList.objectEnumerator();
                    while (e.hasMoreElements()) {
                        currentModel = (EOModel)e.nextElement();
                        if (loadedModels.containsObject(currentModel.name())) continue;
                        this.loadSharedObjectsForModel(currentModel);
                        loadedModels.addObject(currentModel.name());
                    }
                    NSNotificationCenter.defaultCenter().removeObserver((Object)this, "EOAdaptorContextBeginTransactionNotification", null);
                    if (this._didChangeDebugSetting) {
                        this._didChangeDebugSetting = false;
                    }
                    if (this._transCount != 0) {
                        log.debug((Object)("Shared EO loading complete: " + this._transCount + " transactions/ " + EOSharedEditingContext.defaultSharedEditingContext().registeredObjects().count() + " objects."));
                    } else {
                        log.debug((Object)"Shared EO loading complete: no objects loaded.");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Exception occurred with model: " + currentModel.name() + "\n" + e + ERXUtilities.stackTrace()));
                    NSNotificationCenter.defaultCenter().removeObserver((Object)this, "EOAdaptorContextBeginTransactionNotification", null);
                    if (!this._didChangeDebugSetting) break block9;
                    this._didChangeDebugSetting = false;
                }
            }
        }
    }

    public void transactionBeginning(NSNotification aNotification) {
        this._currentAdaptor = (EOAdaptorContext)aNotification.object();
        ++this._transCount;
    }

    static {
        _loadingComplete = false;
    }
}

