/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableSet;
import er.extensions.foundation.ERXProperties;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXSimpleTemplateParser {
    public static final String DEFAULT_UNDEFINED_KEY_LABEL = "?";
    public static final String DEFAULT_DELIMITER = "@@";
    private static final String DEPRECATED_DELIMITER = "@";
    public static final Logger log = Logger.getLogger((String)ERXSimpleTemplateParser.class.getName());
    private static ERXSimpleTemplateParser _sharedInstance;
    public boolean isLoggingDisabled = false;
    private final String _undefinedKeyLabel;
    private Boolean _useOldDelimiter;

    public static ERXSimpleTemplateParser sharedInstance() {
        if (_sharedInstance == null) {
            ERXSimpleTemplateParser.setSharedInstance(new ERXSimpleTemplateParser());
        }
        return _sharedInstance;
    }

    public static synchronized void setSharedInstance(ERXSimpleTemplateParser newSharedInstance) {
        _sharedInstance = newSharedInstance;
    }

    public ERXSimpleTemplateParser() {
        this(DEFAULT_UNDEFINED_KEY_LABEL);
    }

    public ERXSimpleTemplateParser(String undefinedKeyLabel) {
        this._undefinedKeyLabel = undefinedKeyLabel == null ? DEFAULT_UNDEFINED_KEY_LABEL : undefinedKeyLabel;
    }

    public ERXSimpleTemplateParser(String undefinedKeyLabel, boolean useOldDelimiter) {
        this(undefinedKeyLabel);
        this._useOldDelimiter = useOldDelimiter;
    }

    protected boolean useOldDelimiter() {
        if (this._useOldDelimiter == null) {
            this._useOldDelimiter = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXSimpleTemplateParser.useOldDelimiter", true);
        }
        return this._useOldDelimiter;
    }

    public NSArray keysInTemplate(String template, String delimiter) {
        NSMutableSet<String> keys = new NSMutableSet<String>();
        if (delimiter == null) {
            delimiter = DEFAULT_DELIMITER;
        }
        NSArray<String> components = NSArray.componentsSeparatedByString(template, delimiter);
        if (!this.isLoggingDisabled && log.isDebugEnabled()) {
            log.debug((Object)("Components: " + components));
        }
        boolean deriveElement = false;
        Enumeration<String> e = components.objectEnumerator();
        while (e.hasMoreElements()) {
            String element = e.nextElement();
            if (deriveElement) {
                if (element.length() == 0) {
                    throw new IllegalArgumentException("\"\" is not a valid keypath");
                }
                keys.addObject(element);
                deriveElement = false;
                continue;
            }
            deriveElement = true;
        }
        return keys.allObjects();
    }

    public String parseTemplateWithObject(String template, String delimiter, Object object) {
        return this.parseTemplateWithObject(template, delimiter, object, null);
    }

    public String parseTemplateWithObject(String template, String delimiter, Object object, Object otherObject) {
        if (template == null) {
            throw new IllegalArgumentException("Attempting to parse null template!");
        }
        if (object == null) {
            throw new IllegalArgumentException("Attempting to parse template with null object!");
        }
        if (delimiter == null) {
            delimiter = DEFAULT_DELIMITER;
        }
        if (!this.isLoggingDisabled && log.isDebugEnabled()) {
            log.debug((Object)("Parsing template: " + template + " with delimiter: " + delimiter + " object: " + object));
            log.debug((Object)("Template: " + template));
            log.debug((Object)("Delim: " + delimiter));
            log.debug((Object)("otherObject: " + otherObject));
        }
        if (this.useOldDelimiter() && delimiter.equals(DEFAULT_DELIMITER) && template.indexOf(delimiter) < 0 && template.indexOf(DEPRECATED_DELIMITER) >= 0) {
            if (!this.isLoggingDisabled) {
                log.warn((Object)("It seems that the template string '" + template + "' is using the old delimiter '@' instead of '@@'. I will use '@' for now but you should fix this by updating the template."));
            }
            delimiter = DEPRECATED_DELIMITER;
        }
        NSArray<String> components = NSArray.componentsSeparatedByString(template, delimiter);
        if (!this.isLoggingDisabled && log.isDebugEnabled()) {
            log.debug((Object)("Components: " + components));
        }
        boolean deriveElement = false;
        StringBuffer buffer = new StringBuffer();
        Enumeration<String> e = components.objectEnumerator();
        while (e.hasMoreElements()) {
            String element = e.nextElement();
            if (!this.isLoggingDisabled) {
                log.debug((Object)("Processing Element: " + element));
            }
            if (deriveElement) {
                if (!this.isLoggingDisabled) {
                    log.debug((Object)"Deriving value ...");
                }
                if (element.length() == 0) {
                    throw new IllegalArgumentException("\"\" is not a valid keypath in template: " + template);
                }
                Object result = this._undefinedKeyLabel;
                Object[] objects = otherObject != null ? new Object[]{object, otherObject} : new Object[]{object};
                for (int i = 0; i < objects.length; ++i) {
                    Object o = objects[i];
                    if (o == null || result != this._undefinedKeyLabel) continue;
                    try {
                        if (!this.isLoggingDisabled && log.isDebugEnabled()) {
                            log.debug((Object)("calling valueForKeyPath(" + o + ", " + element + ")"));
                        }
                        if ((result = this.doGetValue(element, o)) != null) continue;
                        result = this._undefinedKeyLabel;
                        continue;
                    }
                    catch (NSKeyValueCoding.UnknownKeyException t) {
                        result = this._undefinedKeyLabel;
                        continue;
                    }
                    catch (Throwable t) {
                        throw new NSForwardException(t, "An exception occured while parsing element, " + element + ", of template, \"" + template + "\": " + t.getMessage());
                    }
                }
                if (result == this._undefinedKeyLabel && !this.isLoggingDisabled && log.isDebugEnabled()) {
                    log.debug((Object)("Could not find a value for \"" + element + "\" of template, \"" + template + "\" in either the object or extra data."));
                }
                buffer.append(result.toString());
                deriveElement = false;
            } else {
                if (element.length() > 0) {
                    buffer.append(element);
                }
                deriveElement = true;
            }
            if (this.isLoggingDisabled || !log.isDebugEnabled()) continue;
            log.debug((Object)("Buffer: " + buffer));
        }
        return buffer.toString();
    }

    protected Object doGetValue(String aKeyPath, Object anObject) {
        Object result = anObject instanceof NSKeyValueCodingAdditions ? ((NSKeyValueCodingAdditions)anObject).valueForKeyPath(aKeyPath) : NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)anObject, (String)aKeyPath);
        return result;
    }

    public static String parseTemplatedStringWithObject(String templateString, Object templateObject) {
        String convertedValue = templateString;
        if (templateString == null || templateString.indexOf(DEFAULT_DELIMITER) == -1) {
            return templateString;
        }
        String lastConvertedValue = null;
        while (convertedValue != lastConvertedValue && convertedValue.indexOf(DEFAULT_DELIMITER) > -1) {
            lastConvertedValue = convertedValue;
            convertedValue = new ERXSimpleTemplateParser("ERXSystem:KEY_NOT_FOUND").parseTemplateWithObject(convertedValue, DEFAULT_DELIMITER, templateObject, WOApplication.application());
        }
        if (convertedValue.indexOf("ERXSystem:KEY_NOT_FOUND") > -1) {
            return templateString;
        }
        return convertedValue;
    }
}

