/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.migration;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation._NSUtilities;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.jdbc.ERXJDBCConnectionAnalyzer;
import er.extensions.jdbc.ERXJDBCUtilities;
import er.extensions.jdbc.ERXSQLHelper;
import er.extensions.migration.ERXMigrationFailedException;
import er.extensions.migration.ERXModelVersion;
import er.extensions.migration.IERXMigration;
import er.extensions.migration.IERXMigrationLock;
import er.extensions.migration.IERXPostMigration;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXMigrator {
    public static final Logger log = Logger.getLogger(ERXMigrator.class);
    public static final int LATEST_VERSION = Integer.MAX_VALUE;
    private String _lockOwnerName;

    public ERXMigrator(String lockOwnerName) {
        this._lockOwnerName = lockOwnerName;
    }

    public static boolean shouldMigrateAtStartup() {
        return ERXProperties.booleanForKeyWithDefault("er.migration.migrateAtStartup", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateToLatest() {
        NSArray modelNames;
        EOModelGroup modelGroup = EOModelGroup.defaultGroup();
        String modelNamesStr = ERXProperties.stringForKey("er.migration.modelNames");
        if (modelNamesStr == null) {
            log.warn((Object)"er.migration.modelNames is not set, defaulting to modelGroup.models() order instead.");
            modelNames = modelGroup.modelNames();
        } else {
            modelNames = NSArray.componentsSeparatedByString(modelNamesStr, ",");
        }
        String skipModelNamesStr = ERXProperties.stringForKey("er.migration.skipModelNames");
        NSArray<String> skipModelNames = NSArray.EmptyArray;
        if (skipModelNamesStr != null) {
            skipModelNames = NSArray.componentsSeparatedByString(skipModelNamesStr, ",");
        }
        Map<IERXMigration, ERXModelVersion> migrations = this._buildDependenciesForModelsNamed(modelNames, skipModelNames);
        LinkedHashMap<IERXPostMigration, ERXModelVersion> postMigrations = new LinkedHashMap<IERXPostMigration, ERXModelVersion>();
        for (IERXMigration migration : migrations.keySet()) {
            Object var19_21;
            ERXModelVersion modelVersion = migrations.get(migration);
            EOModel model = modelVersion.model();
            IERXMigrationLock migrationLock = this.databaseLockForModel(model);
            EOEditingContext editingContext = this.newEditingContext();
            editingContext.lock();
            try {
                ERXMigrationAction migrationAction = new ERXMigrationAction(editingContext, migration, modelVersion, migrationLock, this._lockOwnerName, postMigrations);
                try {
                    Object var17_20;
                    ERXSQLHelper helper = ERXSQLHelper.newSQLHelper(model);
                    try {
                        helper.prepareConnectionForSchemaChange(editingContext, model);
                        migrationAction.perform(editingContext, model.name());
                        var17_20 = null;
                        helper.restoreConnectionSettingsAfterSchemaChange(editingContext, model);
                    }
                    catch (Throwable throwable) {
                        var17_20 = null;
                        helper.restoreConnectionSettingsAfterSchemaChange(editingContext, model);
                        throw throwable;
                    }
                }
                catch (ERXMigrationFailedException e) {
                    throw e;
                }
                catch (EOGeneralAdaptorException t) {
                    new ERXJDBCConnectionAnalyzer(model.connectionDictionary());
                    throw new ERXMigrationFailedException("Failed to migrate model '" + model.name() + "'.", t);
                }
                catch (Throwable t) {
                    throw new ERXMigrationFailedException("Failed to migrate model '" + model.name() + "'.", t);
                }
                var19_21 = null;
            }
            catch (Throwable throwable) {
                var19_21 = null;
                editingContext.unlock();
                throw throwable;
            }
            editingContext.unlock();
            {
            }
        }
        for (IERXPostMigration postMigration : postMigrations.keySet()) {
            Object var21_24;
            ERXModelVersion modelVersion = (ERXModelVersion)postMigrations.get(postMigration);
            EOEditingContext editingContext = this.newEditingContext();
            editingContext.lock();
            try {
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Running post migration for " + modelVersion.model().name() + " version " + modelVersion.version() + " ..."));
                    }
                    postMigration.postUpgrade(editingContext, modelVersion.model());
                    editingContext.saveChanges();
                }
                catch (Throwable t) {
                    throw new ERXMigrationFailedException("Failed on post migrations for model '" + modelVersion.model().name() + "'.", t);
                }
                var21_24 = null;
            }
            catch (Throwable throwable) {
                var21_24 = null;
                editingContext.unlock();
                throw throwable;
            }
            editingContext.unlock();
            {
            }
        }
    }

    protected IERXMigrationLock databaseLockForModel(EOModel model) {
        IERXMigrationLock databaseLock;
        String adaptorName = model.adaptorName();
        String migrationLockClassName = ERXProperties.stringForKeyWithDefault("er.migration." + adaptorName + ".lockClassName", "er.extensions.migration.ERX" + adaptorName + "MigrationLock");
        try {
            Class<?> migrationLockClass = Class.forName(migrationLockClassName);
            databaseLock = (IERXMigrationLock)migrationLockClass.newInstance();
        }
        catch (Throwable t) {
            throw new ERXMigrationFailedException("Failed to create migration lock class '" + migrationLockClassName + "'.", t);
        }
        return databaseLock;
    }

    protected Map<IERXMigration, ERXModelVersion> _buildDependenciesForModelsNamed(NSArray<String> modelNames, NSArray<String> skipModelNames) {
        LinkedHashMap<IERXMigration, ERXModelVersion> migrations = new LinkedHashMap<IERXMigration, ERXModelVersion>();
        try {
            HashMap<String, Integer> versions = new HashMap<String, Integer>();
            EOModelGroup modelGroup = EOModelGroup.defaultGroup();
            Enumeration<String> modelNamesEnum = modelNames.objectEnumerator();
            while (modelNamesEnum.hasMoreElements()) {
                String modelName = modelNamesEnum.nextElement();
                if (skipModelNames.containsObject(modelName)) continue;
                EOModel model = modelGroup.modelNamed(modelName);
                if (model == null) {
                    throw new IllegalArgumentException("There is no model named '" + modelName + "' in this model group.");
                }
                this._buildDependenciesForModel(model, Integer.MAX_VALUE, versions, migrations);
            }
            HashSet<String> processedModelNames = new HashSet<String>();
            HashSet pendingModelNames = new HashSet(versions.keySet());
            while (!pendingModelNames.isEmpty()) {
                for (String modelName : pendingModelNames) {
                    EOModel model = modelGroup.modelNamed(modelName);
                    Enumeration entitiesEnum = model.entities().objectEnumerator();
                    while (entitiesEnum.hasMoreElements()) {
                        EOEntity entity = (EOEntity)entitiesEnum.nextElement();
                        EOEntity parentEntity = entity.parentEntity();
                        if (parentEntity != null && !parentEntity.model().equals(model)) {
                            EOModel parentModel = parentEntity.model();
                            this._buildDependenciesForModel(parentModel, Integer.MAX_VALUE, versions, migrations);
                        }
                        Enumeration relationshipsEnum = entity.relationships().objectEnumerator();
                        while (relationshipsEnum.hasMoreElements()) {
                            EORelationship relationship = (EORelationship)relationshipsEnum.nextElement();
                            EOEntity destinationEntity = relationship.destinationEntity();
                            if (destinationEntity == null || destinationEntity.model().equals(model)) continue;
                            EOModel destinationModel = destinationEntity.model();
                            this._buildDependenciesForModel(destinationModel, Integer.MAX_VALUE, versions, migrations);
                        }
                    }
                    this._buildDependenciesForModel(model, Integer.MAX_VALUE, versions, migrations);
                    processedModelNames.add(modelName);
                }
                pendingModelNames.addAll(versions.keySet());
                pendingModelNames.removeAll(processedModelNames);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Migration failed.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Migration failed.", e);
        }
        return migrations;
    }

    protected boolean canMigrateModel(EOModel model) {
        String url;
        boolean canMigrateModel = false;
        String adaptorName = model.adaptorName();
        if ("Memory".equals(adaptorName)) {
            canMigrateModel = true;
        } else if ("JDBC".equals(adaptorName) && (url = (String)model.connectionDictionary().objectForKey("URL")) != null && url.toLowerCase().startsWith("jdbc:")) {
            canMigrateModel = true;
        }
        return canMigrateModel;
    }

    protected void _buildDependenciesForModel(EOModel model, int migrateToVersion, Map<String, Integer> versions, Map<IERXMigration, ERXModelVersion> migrations) throws InstantiationException, IllegalAccessException {
        if (!this.canMigrateModel(model)) {
            return;
        }
        String modelName = model.name();
        Integer migratorVersion = versions.get(modelName);
        if (migratorVersion == null) {
            migratorVersion = ERXProperties.intForKeyWithDefault(modelName + ".InitialMigrationVersion", -1);
        }
        if (migratorVersion != Integer.MAX_VALUE) {
            boolean done = false;
            for (int versionNum = migratorVersion + 1; !done && versionNum <= migrateToVersion; ++versionNum) {
                Class erMigrationClass;
                String migrationClassPrefix = ERXProperties.stringForKeyWithDefault(modelName + ".MigrationClassPrefix", modelName).trim();
                String erMigrationClassName = migrationClassPrefix + versionNum;
                String vendorMigrationClassName = migrationClassPrefix + ERXJDBCUtilities.databaseProductName(model) + versionNum;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Looking for migration '" + erMigrationClassName + "' ..."));
                }
                if ((erMigrationClass = _NSUtilities.classWithName((String)erMigrationClassName)) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Looking for vendor-specific migration '" + vendorMigrationClassName + "' ..."));
                    }
                    erMigrationClass = _NSUtilities.classWithName((String)vendorMigrationClassName);
                }
                if (erMigrationClass != null) {
                    IERXMigration migration = (IERXMigration)erMigrationClass.newInstance();
                    versions.put(modelName, new Integer(versionNum));
                    NSArray<ERXModelVersion> migrationDependencies = migration.modelDependencies();
                    if (migrationDependencies != null) {
                        Enumeration<ERXModelVersion> migrationDependenciesEnum = migrationDependencies.objectEnumerator();
                        while (migrationDependenciesEnum.hasMoreElements()) {
                            ERXModelVersion modelVersion = migrationDependenciesEnum.nextElement();
                            EOModel dependsOnModel = modelVersion.model();
                            int dependsOnVersion = modelVersion.version();
                            this._buildDependenciesForModel(dependsOnModel, dependsOnVersion, versions, migrations);
                        }
                    }
                    migrations.put(migration, new ERXModelVersion(model, versionNum));
                    continue;
                }
                done = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Migration " + erMigrationClassName + " and/or " + vendorMigrationClassName + " do not exist."));
                }
                versions.put(modelName, new Integer(Integer.MAX_VALUE));
            }
        }
    }

    protected EOEditingContext newEditingContext() {
        return ERXEC.newEditingContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ERXMigrationAction
    extends ERXEOAccessUtilities.ChannelAction {
        private EOEditingContext _editingContext;
        private IERXMigrationLock _migrationLock;
        private IERXMigration _migration;
        private ERXModelVersion _modelVersion;
        private String _lockOwnerName;
        private Map<IERXPostMigration, ERXModelVersion> _postMigrations;

        public ERXMigrationAction(EOEditingContext editingContext, IERXMigration migration, ERXModelVersion modelVersion, IERXMigrationLock migrationLock, String lockOwnerName, Map<IERXPostMigration, ERXModelVersion> postMigrations) {
            this._editingContext = editingContext;
            this._modelVersion = modelVersion;
            this._migration = migration;
            this._migrationLock = migrationLock;
            this._lockOwnerName = lockOwnerName;
            this._postMigrations = postMigrations;
        }

        @Override
        protected int doPerform(EOAdaptorChannel channel) {
            boolean locked;
            EOModel model = this._modelVersion.model();
            do {
                if (locked = this._migrationLock.tryLock(channel, model, this._lockOwnerName)) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (!locked);
            if (locked) {
                try {
                    block12: {
                        try {
                            int currentVersion = this._migrationLock.versionNumber(channel, model);
                            int nextVersion = this._modelVersion.version();
                            if (currentVersion < nextVersion) {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("Upgrading " + model.name() + " to version " + nextVersion + " with migration '" + this._migration + "'"));
                                }
                                this._migration.upgrade(this._editingContext, channel, model);
                                this._migrationLock.setVersionNumber(channel, model, nextVersion);
                                this._editingContext.saveChanges();
                                channel.adaptorContext().commitTransaction();
                                channel.adaptorContext().beginTransaction();
                                if (log.isInfoEnabled()) {
                                    log.info((Object)(model.name() + " is now version " + nextVersion));
                                }
                                if (this._migration instanceof IERXPostMigration) {
                                    this._postMigrations.put((IERXPostMigration)this._migration, this._modelVersion);
                                }
                                break block12;
                            }
                            log.debug((Object)("Already upgraded " + model.name() + " to " + nextVersion + ", skipping"));
                        }
                        catch (Throwable t) {
                            throw new ERXMigrationFailedException("Migration failed.", t);
                        }
                    }
                    Object var7_8 = null;
                    this._migrationLock.unlock(channel, model);
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    this._migrationLock.unlock(channel, model);
                    throw throwable;
                }
            }
            return 0;
        }
    }

    @Deprecated
    public static class ModelVersion
    extends ERXModelVersion {
        public ModelVersion(EOModel model, int version) {
            super(model, version);
        }

        public ModelVersion(String modelName, int version) {
            super(modelName, version);
        }
    }
}

