/*
 * Decompiled with CFR 0.152.
 */
package er.indexing;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSUtilities;
import er.extensions.ERXExtensions;
import er.extensions.ERXFrameworkPrincipal;
import er.extensions.appserver.ERXApplication;
import er.extensions.foundation.ERXFileNotificationCenter;
import er.extensions.foundation.ERXMutableDictionary;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSelectorUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.indexing.ERAutoIndex;
import er.indexing.ERIndex;
import er.indexing.ERIndexer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERIndexing
extends ERXFrameworkPrincipal {
    private final Logger log = Logger.getLogger(ERIndexing.class);
    NSMutableDictionary indices = ERXMutableDictionary.synchronizedDictionary();
    public static final Class[] REQUIRES = new Class[]{ERXExtensions.class};
    private File _indexRoot;

    private File indexRoot() {
        if (this._indexRoot == null) {
            String name = ERXProperties.stringForKeyWithDefault((String)"er.indexing.ERIndexModel.rootDirectory", (String)"/tmp");
            this._indexRoot = new File(name);
        }
        return this._indexRoot;
    }

    public void loadIndexDefinitions() {
        Enumeration bundles = NSBundle._allBundlesReally().objectEnumerator();
        while (bundles.hasMoreElements()) {
            NSBundle bundle = (NSBundle)bundles.nextElement();
            NSArray files = bundle.resourcePathsForResources("indexModel", null);
            for (String file : files) {
                URL url = bundle.pathURLForResourcePath(file);
                String name = url.toString().replaceAll(".*?/(\\w+)\\.indexModel$", "$1");
                if (url == null) continue;
                if (ERXApplication.isDevelopmentModeSafe()) {
                    NSSelector selector = ERXSelectorUtilities.notificationSelector((String)"fileDidChange");
                    ERXFileNotificationCenter.defaultCenter().addObserver((Object)this, selector, url.getFile());
                }
                String string = ERXStringUtilities.stringFromResource((String)name, (String)"indexModel", (NSBundle)bundle);
                NSDictionary dict = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)string);
                this.addIndex(name, dict);
                this.log.info((Object)("Added index: " + name));
            }
        }
    }

    public void fileDidChange(NSNotification n) throws MalformedURLException {
        File file = (File)n.object();
        this.loadModel(file.toURL());
    }

    private void loadModel(URL url) {
        NSDictionary def = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)url);
        Enumeration keys = def.allKeys().objectEnumerator();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            NSDictionary indexDef = (NSDictionary)def.objectForKey((Object)key);
            this.addIndex(key, indexDef);
        }
    }

    protected void addIndex(String key, ERIndex index) {
        this.indices.setObjectForKey((Object)index, (Object)key);
    }

    private void addIndex(String key, NSDictionary indexDef) {
        ERIndex index;
        String className = (String)indexDef.objectForKey((Object)"index");
        NSMutableDictionary dict = indexDef.mutableClone();
        if (!dict.containsKey((Object)"store")) {
            try {
                dict.setObjectForKey((Object)new File(this.indexRoot(), key).toURL().toString(), (Object)"store");
            }
            catch (MalformedURLException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
        if (className != null) {
            Class c = ERXPatcher.classForName((String)className);
            index = (ERIndex)_NSUtilities.instantiateObject((Class)c, (Class[])new Class[]{String.class, NSDictionary.class}, (Object[])new Object[]{key, dict}, (boolean)true, (boolean)false);
        } else {
            index = new ERAutoIndex(key, (NSDictionary)dict);
        }
        this.addIndex(key, index);
    }

    public void finishInitialization() {
        this.loadIndexDefinitions();
    }

    public static ERIndexing indexing() {
        return (ERIndexing)ERIndexing.sharedInstance(ERIndexing.class);
    }

    public void clear() {
        new ERIndexer((NSArray<ERAutoIndex>)ERIndexing.indexing().indices.allValues()).clear();
    }

    static {
        ERIndexing.setUpFrameworkPrincipalClass(ERIndexing.class);
    }
}

