/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.mipc;

import java.io.Serializable;
import java.util.Vector;
import javax.jms.JMSException;
import org.exolab.core.ipc.IpcIfc;
import org.exolab.jms.client.JmsConnectionStubIfc;
import org.exolab.jms.client.JmsSessionStubIfc;
import org.exolab.jms.client.mipc.IpcJmsMessageListener;
import org.exolab.jms.client.mipc.IpcJmsServerStub;
import org.exolab.jms.client.mipc.IpcJmsSessionStub;

public class IpcJmsConnectionStub
implements JmsConnectionStubIfc {
    private IpcJmsServerStub _server;
    private IpcIfc _connection = null;
    private String _clientId;
    private String _connectionId;
    private IpcJmsMessageListener _listener = null;

    public IpcJmsConnectionStub(IpcJmsServerStub server, IpcIfc connection, String clientId, String connectionId, IpcJmsMessageListener listener) {
        this._server = server;
        this._connection = connection;
        this._clientId = clientId;
        this._connectionId = connectionId;
        this._listener = listener;
    }

    public JmsSessionStubIfc createSession(int ackMode, boolean transacted) throws JMSException {
        IpcJmsSessionStub stub = null;
        try {
            Vector v = this.pack("createSession", 2);
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                v.add(new Integer(ackMode));
                v.add(new Boolean(transacted));
                this._connection.send((Serializable)v);
                v = (Vector)this._connection.receive();
            }
            if (v != null) {
                Boolean b = (Boolean)v.get(0);
                if (!b.booleanValue()) {
                    throw new JMSException("Failed to create session: " + (String)v.get(1));
                }
            } else {
                throw new JMSException("Unknown connection error for createSession");
            }
            Vector state = (Vector)v.get(1);
            String sessionId = (String)state.get(0);
            stub = new IpcJmsSessionStub(this._connection, this._clientId, this._connectionId, sessionId, this._listener);
        }
        catch (JMSException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new JMSException("Failed to create session: " + exception);
        }
        return stub;
    }

    public void close() throws JMSException {
        try {
            try {
                Vector v = this.pack("close", 0);
                IpcIfc ipcIfc = this._connection;
                synchronized (ipcIfc) {
                    this._connection.send((Serializable)v);
                    v = (Vector)this._connection.receive();
                }
                if (v != null) {
                    Boolean b = (Boolean)v.get(0);
                    if (!b.booleanValue()) {
                        throw new JMSException("Failed to close connection: " + (String)v.get(1));
                    }
                } else {
                    throw new JMSException("Unknown connection error for close Connection");
                }
                Object var5_7 = null;
                this._server.closed(this);
            }
            catch (JMSException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new JMSException("Failed to close connection: " + exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this._server.closed(this);
            throw throwable;
        }
    }

    public String getConnectionId() throws JMSException {
        return this._connectionId;
    }

    public void destroy() {
        this._connection = null;
    }

    private Vector pack(String method, int numParams) {
        Vector<String> v = new Vector<String>(4 + numParams);
        v.add("org.exolab.jms.server.mipc.IpcJmsServerConnection");
        v.add(method);
        v.add(this._clientId);
        v.add(this._connectionId);
        return v;
    }
}

