/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.util;

import java.util.LinkedList;
import org.exolab.jms.util.QueueWorker;

public class BlockingWorkerQueue
extends Thread {
    private QueueWorker _worker = null;
    private LinkedList _queue = new LinkedList();
    private boolean _closed = false;

    public BlockingWorkerQueue(String name, QueueWorker worker) {
        super("BWQ:" + name);
        this._worker = worker;
        this.setDaemon(true);
    }

    public void add(Object object) {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.addLast(object);
            this._queue.notifyAll();
        }
    }

    public void run() {
        while (!this._closed) {
            Object work = null;
            LinkedList linkedList = this._queue;
            synchronized (linkedList) {
                if (this._queue.size() == 0) {
                    try {
                        this._queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                work = this._queue.removeFirst();
            }
            if (work == null) continue;
            this._worker.execute(work);
        }
    }

    public int size() {
        return this._queue.size();
    }

    public void close() {
        this._closed = true;
        this.interrupt();
    }
}

