/*
 * Decompiled with CFR 0.152.
 */
package er.profiling;

import com.webobjects.eoaccess.EOSQLExpression;
import er.profiling.PFStatsNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PFStatsChecker {
    public static Set<PFStatsNode> checkForErrors(PFStatsNode node) {
        node.clearErrors();
        HashSet<PFStatsNode> errorNodes = new HashSet<PFStatsNode>();
        HashMap<String, List<PFStatsNode>> duplicates = new HashMap<String, List<PFStatsNode>>();
        PFStatsChecker.checkForDupeSQL(node, duplicates);
        for (Map.Entry statement : duplicates.entrySet()) {
            if (((List)statement.getValue()).size() <= 10) continue;
            String errorMessage = "repeated " + ((List)statement.getValue()).size() + " times in this request";
            for (PFStatsNode errorNode : (List)statement.getValue()) {
                errorNode.addError(errorMessage);
                errorNodes.add(errorNode);
            }
        }
        return errorNodes;
    }

    protected static void checkForDupeSQL(PFStatsNode node, Map<String, List<PFStatsNode>> duplicates) {
        List<PFStatsNode> children;
        if ("SQL".equals(node.name()) && "evaluate".equals(node.type())) {
            String statement = ((EOSQLExpression)node.target()).statement();
            List<PFStatsNode> dupes = duplicates.get(statement);
            if (dupes == null) {
                dupes = new LinkedList<PFStatsNode>();
                duplicates.put(statement, dupes);
            }
            dupes.add(node);
        }
        if ((children = node.children()) != null) {
            for (PFStatsNode child : children) {
                PFStatsChecker.checkForDupeSQL(child, duplicates);
            }
        }
    }
}

