/*
 * Decompiled with CFR 0.152.
 */
package er.profiling;

import er.profiling.PFProfiler;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PFStatsNode {
    private long _id;
    private PFStatsNode _parent;
    private String _name;
    private String _type;
    private long _startTime;
    private long _endTime;
    private List<PFStatsNode> _children;
    private Object _target;
    private Object _context;
    private Map<String, Long> _counters;
    private List<String> _errors;

    public PFStatsNode(String name, String type, Object target, Object context) {
        this._name = name;
        this._type = type;
        this._target = target;
        this._context = context;
        this._id = PFProfiler.nextStatsID();
    }

    public void clearErrors() {
        this._errors = null;
        if (this._children != null) {
            for (PFStatsNode child : this._children) {
                child.clearErrors();
            }
        }
    }

    public void addError(String error) {
        if (this._errors == null) {
            this._errors = new LinkedList<String>();
        }
        this._errors.add(error);
    }

    public boolean hasErrors() {
        return this._errors != null && this._errors.size() > 0;
    }

    public List<String> errors() {
        return this._errors;
    }

    public String type() {
        return this._type;
    }

    public PFStatsNode parentStats() {
        return this._parent;
    }

    public long id() {
        return this._id;
    }

    public String name() {
        return this._name;
    }

    public Object target() {
        return this._target;
    }

    public Object context() {
        return this._context;
    }

    public int depth() {
        return this._parent == null ? 0 : this._parent.depth() + 1;
    }

    public PFStatsNode rootStats() {
        return this._parent == null ? this : this._parent.rootStats();
    }

    public boolean isLeaf() {
        return this._children == null || this._children.size() == 0;
    }

    public boolean isRoot() {
        return this.rootStats() == this;
    }

    public void start() {
        this._startTime = System.nanoTime();
    }

    public void end() {
        this._endTime = System.nanoTime();
        if (this._parent != null) {
            this._parent.end();
        }
    }

    public long overhead() {
        long overhead = this.duration();
        if (this._children != null) {
            long childrenDuration = 0L;
            for (PFStatsNode child : this._children) {
                childrenDuration += child.duration();
            }
            overhead -= childrenDuration;
        }
        return overhead;
    }

    public long duration() {
        return this._endTime - this._startTime;
    }

    public double durationMillis() {
        return (double)this.duration() / 1000000.0;
    }

    public long durationOf(String name, boolean recursiveSum) {
        long duration = 0L;
        if (name.equals(this._name)) {
            duration += this.duration();
        }
        if (this._children != null && (recursiveSum || duration == 0L)) {
            for (PFStatsNode child : this._children) {
                duration += child.durationOf(name, recursiveSum);
            }
        }
        return duration;
    }

    public double durationOfMillis(String name, boolean recursiveSum) {
        return (double)this.durationOf(name, recursiveSum) / 1000000.0;
    }

    public int countOf(String name, boolean recursiveCount) {
        int count = 0;
        if (name.equals(this._name)) {
            ++count;
        }
        if (this._children != null && (recursiveCount || count == 0)) {
            for (PFStatsNode child : this._children) {
                count += child.countOf(name, recursiveCount);
            }
        }
        return count;
    }

    public DurationCount countBetweenDurations(long minNanos, long maxNanos) {
        DurationCount durationCount = new DurationCount();
        this.countBetweenDurations(minNanos, maxNanos, durationCount);
        return durationCount;
    }

    protected void countBetweenDurations(long minNanos, long maxNanos, DurationCount durationCount) {
        long duration = this.overhead();
        if (duration >= minNanos && duration < maxNanos) {
            ++durationCount.count;
            durationCount.duration += duration;
        }
        if (this._children != null) {
            for (PFStatsNode child : this._children) {
                child.countBetweenDurations(minNanos, maxNanos, durationCount);
            }
        }
    }

    public List<PFStatsNode> children() {
        return this._children;
    }

    public PFStatsNode push(String name, String type, Object target, Object context) {
        if (this._children == null) {
            this._children = new LinkedList<PFStatsNode>();
        }
        PFStatsNode stats = new PFStatsNode(name, type, target, context);
        stats._parent = this;
        this._children.add(stats);
        PFProfiler.setCurrentStats(stats);
        stats.start();
        return stats;
    }

    public void pop() {
        this.end();
        if (this._parent != null) {
            PFProfiler.setCurrentStats(this._parent);
        }
    }

    public double percentage() {
        return (double)this.duration() / (double)this.rootStats().duration();
    }

    public boolean isAtLeastPercentage(double minimumPercentage) {
        return minimumPercentage == 0.0 || this.percentage() >= minimumPercentage;
    }

    public boolean isImportant() {
        return this.children() == null || this.parentStats() == null || !this.isAtLeastPercentage(this.parentStats().percentage() * 0.9);
    }

    public String cssID() {
        return "wo_p_" + this.id();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCounter(String counterName) {
        PFStatsNode pFStatsNode = this;
        synchronized (pFStatsNode) {
            Long counter;
            if (this._counters == null) {
                this._counters = new TreeMap<String, Long>();
            }
            if ((counter = this._counters.get(counterName)) == null) {
                this._counters.put(counterName, 1L);
            } else {
                this._counters.put(counterName, counter + 1L);
            }
        }
    }

    public Map<String, Long> counters() {
        return this._counters;
    }

    public static class DurationCount {
        long duration;
        int count;

        public long nanos() {
            return this.duration;
        }

        public int count() {
            return this.count;
        }

        public double millis() {
            return (double)this.duration / 1000000.0;
        }
    }
}

