/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class NSProperties {
    private static final String _def = "-D";
    private static final char _dqc = '\"';
    private static final String _dqs = "\"";
    private static final String _eqs = "=";
    private static final String _false = "false";
    private static final String _hyphen = "-";
    private static final String _no = "NO";
    private static final char _sqc = '\'';
    private static final String _sqs = "'";
    private static final String _true = "true";
    private static final String _yes = "YES";
    private static InitialContext _ctx;
    private static Properties _properties;
    private static String _mainBundleName;

    private static void initialize() {
        Properties props;
        InitialContext ctx;
        try {
            ctx = new InitialContext();
            NamingEnumeration<NameClassPair> list = ctx.list("java:comp/env/wo");
            props = new Properties();
            while (list.hasMore()) {
                NameClassPair pair = list.next();
                String name = pair.isRelative() ? "java:comp/env/wo/" + pair.getName() : pair.getName();
                Object obj = ctx.lookup(name);
                props.setProperty(pair.getName(), obj.toString());
            }
        }
        catch (NamingException e) {
            ctx = null;
            props = null;
        }
        _properties = props;
        _ctx = ctx;
    }

    private NSProperties() {
        throw new IllegalStateException("Can't instantiate an instance of class " + this.getClass().getName());
    }

    public static Object _setProperty(String name, String value) {
        if (_ctx == null) {
            return System.setProperty(name, value);
        }
        return _properties.setProperty(name, value);
    }

    public static void _setProperties(Properties props) {
        if (_ctx == null) {
            System.setProperties(props);
        } else {
            _properties = props;
        }
    }

    public static Properties _getProperties() {
        Properties ret = _ctx == null ? System.getProperties() : _properties;
        return ret;
    }

    public static String getProperty(String name) {
        return NSProperties.getProperty(name, null);
    }

    public static String getProperty(String name, String defaultValue) {
        String value = null;
        if (_ctx != null) {
            value = _properties.getProperty(name);
        }
        if (value == null && (value = System.getProperty(name)) == null) {
            value = defaultValue;
        }
        return value;
    }

    public static NSArray arrayForKey(String aKey) {
        String s = NSProperties.getProperty(aKey);
        NSArray a = s == null ? NSArray.EmptyArray : NSPropertyListSerialization.arrayForString(s);
        return a;
    }

    public static boolean booleanForKey(String aKey) {
        String s = NSProperties.getProperty(aKey);
        return NSPropertyListSerialization.booleanForString(s);
    }

    public static NSData dataForKey(String aKey) {
        String s = NSProperties.getProperty(aKey);
        NSData d = s == null ? NSData.EmptyData : NSPropertyListSerialization.dataFromPropertyList(NSPropertyListSerialization.propertyListFromString(s));
        return d;
    }

    public static NSDictionary dictionaryForKey(String aKey) {
        String s = NSProperties.getProperty(aKey);
        NSDictionary d = s == null ? NSDictionary.EmptyDictionary : NSPropertyListSerialization.dictionaryForString(s);
        return d;
    }

    public static double doubleForKey(String aKey) {
        double d;
        String s = NSProperties.getProperty(aKey);
        if (s == null) {
            d = 0.0;
        } else {
            try {
                Double D = Double.valueOf(s);
                d = D;
            }
            catch (NumberFormatException e) {
                NSLog._conditionallyLogPrivateException(e);
                d = Double.NaN;
            }
        }
        return d;
    }

    public static float floatForKey(String aKey) {
        float f;
        String s = NSProperties.getProperty(aKey);
        if (s == null) {
            f = 0.0f;
        } else {
            try {
                Float F = Float.valueOf(s);
                f = F.floatValue();
            }
            catch (NumberFormatException e) {
                NSLog._conditionallyLogPrivateException(e);
                f = Float.NaN;
            }
        }
        return f;
    }

    public static int integerForKey(String aKey) {
        int i;
        String s = NSProperties.getProperty(aKey);
        if (s == null) {
            i = 0;
        } else {
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                NSLog._conditionallyLogPrivateException(e);
                i = 0;
            }
        }
        return i;
    }

    public static long longForKey(String aKey) {
        long l;
        String s = NSProperties.getProperty(aKey);
        if (s == null) {
            l = 0L;
        } else {
            try {
                l = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                NSLog._conditionallyLogPrivateException(e);
                l = 0L;
            }
        }
        return l;
    }

    public static void setPropertiesFromArgv(String[] argv) {
        try {
            Class.forName("com.webobjects.foundation.NSBundle");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (argv != null) {
            NSProperties.insertCommandLineArguments(argv);
        }
    }

    public static String stringForKey(String aKey) {
        return NSProperties.getProperty(aKey);
    }

    public static NSDictionary valuesFromArgv(String[] argv) {
        int argCount = argv.length;
        NSMutableDictionary values = new NSMutableDictionary(argCount);
        for (int i = 0; i < argCount; ++i) {
            String argumentValue;
            String argumentName;
            int indexOfEqualSign;
            String argument = argv[i];
            int argumentLength = argument.length();
            boolean argIsQuoted = argument.startsWith(_dqs) && argument.endsWith(_dqs) || argument.startsWith(_sqs) && argument.endsWith(_sqs);
            boolean hasBeenParsed = false;
            if ((argIsQuoted ? argument.indexOf(_def) == 1 : argument.startsWith(_def)) && (indexOfEqualSign = argument.indexOf(_eqs)) != -1 && (argIsQuoted ? indexOfEqualSign < argumentLength - 2 && indexOfEqualSign > 3 : indexOfEqualSign < argumentLength && indexOfEqualSign > 2)) {
                if (argIsQuoted) {
                    argumentName = argument.substring(3, indexOfEqualSign);
                    argumentValue = argument.substring(indexOfEqualSign + 1, argumentLength - 1);
                } else {
                    boolean valIsQuoted = indexOfEqualSign < argumentLength - 2 && (argument.charAt(indexOfEqualSign + 1) == '\"' && argument.endsWith(_dqs) || argument.charAt(indexOfEqualSign + 1) == '\'' && argument.endsWith(_sqs));
                    argumentName = argument.substring(2, indexOfEqualSign);
                    argumentValue = valIsQuoted ? argument.substring(indexOfEqualSign + 2, argumentLength - 1) : argument.substring(indexOfEqualSign + 1, argumentLength);
                }
                values.setObjectForKey(argumentValue, argumentName);
                hasBeenParsed = true;
            }
            if (hasBeenParsed || !argument.startsWith(_hyphen) || argument.length() <= 1) continue;
            argumentName = argument.substring(1);
            if (i + 1 >= argCount) continue;
            argumentValue = argv[i + 1];
            ++i;
            if (argumentValue.equalsIgnoreCase(_yes) || argumentValue.equalsIgnoreCase(_true)) {
                argumentValue = _true;
            } else if (argumentValue.equalsIgnoreCase(_no) || argumentValue.equalsIgnoreCase(_false)) {
                argumentValue = _false;
            }
            values.setObjectForKey(argumentValue, argumentName);
        }
        return values;
    }

    private static void insertCommandLineArguments(String[] argv) {
        NSDictionary values = NSProperties.valuesFromArgv(argv);
        NSArray keys = values.allKeys();
        int count = keys.count();
        for (int i = 0; i < count; ++i) {
            Object key = keys.objectAtIndex(i);
            NSProperties._setProperty((String)key, (String)values.objectForKey(key));
        }
    }

    public static void _setMainBundleName(String name) {
        _mainBundleName = name;
    }

    public static String _mainBundleName() {
        return _mainBundleName;
    }

    static {
        NSProperties.initialize();
        _mainBundleName = null;
    }
}

