/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import sun.misc.BASE64Encoder;

public class Utils {
    static final String METADATA_PREFIX = "x-amz-meta-";
    static final String AMAZON_HEADER_PREFIX = "x-amz-";
    static final String ALTERNATIVE_DATE_HEADER = "x-amz-date";
    static final String DEFAULT_HOST = "s3.amazonaws.com";
    static final int SECURE_PORT = 443;
    static final int INSECURE_PORT = 80;
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    static String makeCanonicalString(String method, String resource, Map headers) {
        return Utils.makeCanonicalString(method, resource, headers, null);
    }

    static String makeCanonicalString(String method, String resource, Map headers, String expires) {
        StringBuffer buf = new StringBuffer();
        buf.append(method + "\n");
        TreeMap<String, String> interestingHeaders = new TreeMap<String, String>();
        if (headers != null) {
            for (String key : headers.keySet()) {
                String lk;
                if (key == null || !(lk = key.toLowerCase()).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith(AMAZON_HEADER_PREFIX)) continue;
                List s = (List)headers.get(key);
                interestingHeaders.put(lk, Utils.concatenateList(s));
            }
        }
        if (interestingHeaders.containsKey(ALTERNATIVE_DATE_HEADER)) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (String key : interestingHeaders.keySet()) {
            if (key.startsWith(AMAZON_HEADER_PREFIX)) {
                buf.append(key).append(':').append(interestingHeaders.get(key));
            } else {
                buf.append(interestingHeaders.get(key));
            }
            buf.append("\n");
        }
        int queryIndex = resource.indexOf(63);
        if (queryIndex == -1) {
            buf.append("/" + resource);
        } else {
            buf.append("/" + resource.substring(0, queryIndex));
        }
        if (resource.matches(".*[&?]acl($|=|&).*")) {
            buf.append("?acl");
        } else if (resource.matches(".*[&?]torrent($|=|&).*")) {
            buf.append("?torrent");
        }
        return buf.toString();
    }

    static String encode(String awsSecretAccessKey, String canonicalString, boolean urlencode) {
        SecretKeySpec signingKey = new SecretKeySpec(awsSecretAccessKey.getBytes(), HMAC_SHA1_ALGORITHM);
        Mac mac = null;
        try {
            mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find sha1 algorithm", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not initialize the MAC algorithm", e);
        }
        String b64 = new BASE64Encoder().encode(mac.doFinal(canonicalString.getBytes()));
        if (urlencode) {
            return Utils.urlencode(b64);
        }
        return b64;
    }

    static String pathForListOptions(String bucket, String prefix, String marker, Integer maxKeys) {
        StringBuffer path = new StringBuffer(bucket);
        path.append("?");
        if (prefix != null) {
            path.append("prefix=" + Utils.urlencode(prefix) + "&");
        }
        if (marker != null) {
            path.append("marker=" + Utils.urlencode(marker) + "&");
        }
        if (maxKeys != null) {
            path.append("max-keys=" + maxKeys + "&");
        }
        path.deleteCharAt(path.length() - 1);
        return path.toString();
    }

    static String urlencode(String unencoded) {
        try {
            return URLEncoder.encode(unencoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not url encode to UTF-8", e);
        }
    }

    static XMLReader createXMLReader() {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            try {
                return XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e2) {
                throw new RuntimeException("Couldn't initialize a sax driver for the XMLReader");
            }
        }
    }

    private static String concatenateList(List values) {
        StringBuffer buf = new StringBuffer();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            buf.append(((String)values.get(i)).replaceAll("\n", "").trim());
            if (i == size - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }
}

