/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.exif.CanonMakernoteDirectory;
import com.drew.metadata.exif.CasioMakernoteDirectory;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifInteropDirectory;
import com.drew.metadata.exif.FujiFilmMakernoteDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.exif.NikonType1MakernoteDirectory;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import com.drew.metadata.exif.NikonType3MakernoteDirectory;
import com.drew.metadata.exif.OlympusMakernoteDirectory;
import java.io.File;

public class ExifReader
implements MetadataReader {
    private final byte[] _data;
    private boolean _isMotorollaByteOrder;
    private Metadata _metadata;
    static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int MAX_FORMAT_CODE = 12;
    private static final int FMT_BYTE = 1;
    private static final int FMT_STRING = 2;
    private static final int FMT_USHORT = 3;
    private static final int FMT_ULONG = 4;
    private static final int FMT_URATIONAL = 5;
    private static final int FMT_SBYTE = 6;
    private static final int FMT_UNDEFINED = 7;
    private static final int FMT_SSHORT = 8;
    private static final int FMT_SLONG = 9;
    private static final int FMT_SRATIONAL = 10;
    private static final int FMT_SINGLE = 11;
    private static final int FMT_DOUBLE = 12;
    public static final int TAG_EXIF_OFFSET = 34665;
    public static final int TAG_INTEROP_OFFSET = 40965;
    public static final int TAG_GPS_INFO_OFFSET = 34853;
    public static final int TAG_MAKER_NOTE = 37500;
    public static int TIFF_HEADER_START_OFFSET = 6;

    public ExifReader(File file) throws JpegProcessingException {
        this(new JpegSegmentReader(file).readSegment((byte)-31));
    }

    public ExifReader(byte[] data) {
        this._data = data;
    }

    public Metadata extract() {
        return this.extract(new Metadata());
    }

    public Metadata extract(Metadata metadata) {
        this._metadata = metadata;
        if (this._data == null) {
            return this._metadata;
        }
        Directory directory = this._metadata.getDirectory(ExifDirectory.class);
        if (this._data.length <= 14) {
            directory.addError("Exif data segment must contain at least 14 bytes");
            return this._metadata;
        }
        if (!"Exif\u0000\u0000".equals(new String(this._data, 0, 6))) {
            directory.addError("Exif data segment doesn't begin with 'Exif'");
            return this._metadata;
        }
        String byteOrderIdentifier = new String(this._data, 6, 2);
        if (!this.setByteOrder(byteOrderIdentifier)) {
            directory.addError("Unclear distinction between Motorola/Intel byte ordering");
            return this._metadata;
        }
        if (this.get16Bits(8) != 42) {
            directory.addError("Invalid Exif start - should have 0x2A at offset 8 in Exif header");
            return this._metadata;
        }
        int firstDirectoryOffset = this.get32Bits(10) + TIFF_HEADER_START_OFFSET;
        if (firstDirectoryOffset >= this._data.length - 1) {
            directory.addError("First exif directory offset is beyond end of Exif data segment");
            firstDirectoryOffset = 14;
        }
        this.processDirectory(directory, firstDirectoryOffset);
        this.extractThumbnail(directory);
        return this._metadata;
    }

    private void extractThumbnail(Directory exifDirectory) {
        if (!(exifDirectory instanceof ExifDirectory)) {
            return;
        }
        if (!exifDirectory.containsTag(514) || !exifDirectory.containsTag(513)) {
            return;
        }
        try {
            int offset = exifDirectory.getInt(513);
            int length = exifDirectory.getInt(514);
            byte[] result = new byte[length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this._data[TIFF_HEADER_START_OFFSET + offset + i];
            }
            exifDirectory.setByteArray(61441, result);
        }
        catch (Throwable e) {
            exifDirectory.addError("Unable to extract thumbnail: " + e.getMessage());
        }
    }

    private boolean setByteOrder(String byteOrderIdentifier) {
        if ("MM".equals(byteOrderIdentifier)) {
            this._isMotorollaByteOrder = true;
        } else if ("II".equals(byteOrderIdentifier)) {
            this._isMotorollaByteOrder = false;
        } else {
            return false;
        }
        return true;
    }

    private void processDirectory(Directory directory, int dirStartOffset) {
        if (dirStartOffset >= this._data.length || dirStartOffset < 0) {
            directory.addError("Ignored directory marked to start outside data segement");
            return;
        }
        int dirTagCount = this.get16Bits(dirStartOffset);
        if (!this.isDirectoryLengthValid(dirStartOffset)) {
            directory.addError("Illegally sized directory");
            return;
        }
        block6: for (int dirEntry = 0; dirEntry < dirTagCount; ++dirEntry) {
            int dirEntryOffset = this.calculateDirectoryEntryOffset(dirStartOffset, dirEntry);
            int tagType = this.get16Bits(dirEntryOffset);
            int formatCode = this.get16Bits(dirEntryOffset + 2);
            if (formatCode < 0 || formatCode > 12) {
                directory.addError("Invalid format code: " + formatCode);
                continue;
            }
            int componentCount = this.get32Bits(dirEntryOffset + 4);
            int byteCount = componentCount * BYTES_PER_FORMAT[formatCode];
            int tagValueOffset = this.calculateTagValueOffset(byteCount, dirEntryOffset);
            if (tagValueOffset < 0) {
                directory.addError("Illegal pointer offset value in EXIF");
                continue;
            }
            int subdirOffset = TIFF_HEADER_START_OFFSET + this.get32Bits(tagValueOffset);
            switch (tagType) {
                case 34665: {
                    this.processDirectory(this._metadata.getDirectory(ExifDirectory.class), subdirOffset);
                    continue block6;
                }
                case 40965: {
                    this.processDirectory(this._metadata.getDirectory(ExifInteropDirectory.class), subdirOffset);
                    continue block6;
                }
                case 34853: {
                    this.processDirectory(this._metadata.getDirectory(GpsDirectory.class), subdirOffset);
                    continue block6;
                }
                case 37500: {
                    this.processMakerNote(tagValueOffset);
                    continue block6;
                }
                default: {
                    this.processTag(directory, tagType, tagValueOffset, componentCount, formatCode);
                }
            }
        }
        int nextDirectoryOffset = this.get32Bits(dirStartOffset + 2 + 12 * dirTagCount);
        if (nextDirectoryOffset != 0) {
            if ((nextDirectoryOffset += TIFF_HEADER_START_OFFSET) >= this._data.length) {
                return;
            }
            this.processDirectory(directory, nextDirectoryOffset);
        }
    }

    private void processMakerNote(int subdirOffset) {
        Directory exifDirectory = this._metadata.getDirectory(ExifDirectory.class);
        if (exifDirectory == null) {
            return;
        }
        String cameraModel = exifDirectory.getString(271);
        if ("OLYMP".equals(new String(this._data, subdirOffset, 5))) {
            this.processDirectory(this._metadata.getDirectory(OlympusMakernoteDirectory.class), subdirOffset + 8);
        } else if (cameraModel != null && cameraModel.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(new String(this._data, subdirOffset, 5))) {
                if (this._data[subdirOffset + 6] == 1) {
                    this.processDirectory(this._metadata.getDirectory(NikonType1MakernoteDirectory.class), subdirOffset + 8);
                } else if (this._data[subdirOffset + 6] == 2) {
                    int oldHeaderStartOffset = TIFF_HEADER_START_OFFSET;
                    TIFF_HEADER_START_OFFSET = subdirOffset + 10;
                    this.processDirectory(this._metadata.getDirectory(NikonType3MakernoteDirectory.class), subdirOffset + 18);
                    TIFF_HEADER_START_OFFSET = oldHeaderStartOffset;
                } else {
                    exifDirectory.addError("Unsupported makernote data ignored.");
                }
            } else {
                this.processDirectory(this._metadata.getDirectory(NikonType2MakernoteDirectory.class), subdirOffset);
            }
        } else if ("Canon".equalsIgnoreCase(cameraModel)) {
            this.processDirectory(this._metadata.getDirectory(CanonMakernoteDirectory.class), subdirOffset);
        } else if ("Casio".equalsIgnoreCase(cameraModel)) {
            this.processDirectory(this._metadata.getDirectory(CasioMakernoteDirectory.class), subdirOffset);
        } else if ("FUJIFILM".equals(new String(this._data, subdirOffset, 8)) || "Fujifilm".equalsIgnoreCase(cameraModel)) {
            boolean byteOrderBefore = this._isMotorollaByteOrder;
            this._isMotorollaByteOrder = false;
            int ifdStart = subdirOffset + this.get32Bits(subdirOffset + 8);
            this.processDirectory(this._metadata.getDirectory(FujiFilmMakernoteDirectory.class), ifdStart);
            this._isMotorollaByteOrder = byteOrderBefore;
        } else {
            exifDirectory.addError("Unsupported makernote data ignored.");
        }
    }

    private boolean isDirectoryLengthValid(int dirStartOffset) {
        int dirTagCount = this.get16Bits(dirStartOffset);
        int dirLength = 2 + 12 * dirTagCount + 4;
        return dirLength + dirStartOffset + TIFF_HEADER_START_OFFSET < this._data.length;
    }

    private void processTag(Directory directory, int tagType, int tagValueOffset, int componentCount, int formatCode) {
        switch (formatCode) {
            case 2: 
            case 7: {
                String s = tagType == 37510 ? this.readCommentString(tagValueOffset, componentCount, formatCode) : this.readString(tagValueOffset, componentCount);
                directory.setString(tagType, s);
                break;
            }
            case 5: 
            case 10: {
                if (componentCount == 1) {
                    Rational rational = new Rational(this.get32Bits(tagValueOffset), this.get32Bits(tagValueOffset + 4));
                    directory.setRational(tagType, rational);
                    break;
                }
                Rational[] rationals = new Rational[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    rationals[i] = new Rational(this.get32Bits(tagValueOffset + 8 * i), this.get32Bits(tagValueOffset + 4 + 8 * i));
                }
                directory.setRationalArray(tagType, rationals);
                break;
            }
            case 1: 
            case 6: {
                if (componentCount == 1) {
                    byte b = this._data[tagValueOffset];
                    directory.setInt(tagType, b);
                    break;
                }
                int[] bytes = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    bytes[i] = this._data[tagValueOffset + i];
                }
                directory.setIntArray(tagType, bytes);
                break;
            }
            case 11: 
            case 12: {
                if (componentCount == 1) {
                    byte i = this._data[tagValueOffset];
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = this._data[tagValueOffset + i];
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            case 3: 
            case 8: {
                if (componentCount == 1) {
                    int i = this.get16Bits(tagValueOffset);
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = this.get16Bits(tagValueOffset + i * 2);
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            case 4: 
            case 9: {
                if (componentCount == 1) {
                    int i = this.get32Bits(tagValueOffset);
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = this.get32Bits(tagValueOffset + i * 4);
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            default: {
                directory.addError("unknown format code " + formatCode);
            }
        }
    }

    private int calculateTagValueOffset(int byteCount, int dirEntryOffset) {
        if (byteCount > 4) {
            int offsetVal = this.get32Bits(dirEntryOffset + 8);
            if (offsetVal + byteCount > this._data.length) {
                return -1;
            }
            return TIFF_HEADER_START_OFFSET + offsetVal;
        }
        return dirEntryOffset + 8;
    }

    private String readString(int offset, int maxLength) {
        int length;
        for (length = 0; offset + length < this._data.length && this._data[offset + length] != 0 && length < maxLength; ++length) {
        }
        return new String(this._data, offset, length);
    }

    private String readCommentString(int tagValueOffset, int componentCount, int formatCode) {
        int i;
        int byteCount = componentCount * BYTES_PER_FORMAT[formatCode];
        for (i = byteCount - 1; i >= 0 && this._data[tagValueOffset + i] == 32; --i) {
            this._data[tagValueOffset + i] = 0;
        }
        if ("ASCII".equals(new String(this._data, tagValueOffset, 5))) {
            for (i = 5; i < 10; ++i) {
                byte b = this._data[tagValueOffset + i];
                if (b == 0 || b == 32) continue;
                return this.readString(tagValueOffset + i, 1999);
            }
        }
        return this.readString(tagValueOffset, 1999);
    }

    private int calculateDirectoryEntryOffset(int ifdStartOffset, int entryNumber) {
        return ifdStartOffset + 2 + 12 * entryNumber;
    }

    private int get16Bits(int offset) {
        if (offset < 0 || offset >= this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + offset + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this._isMotorollaByteOrder) {
            return this._data[offset] << 8 & 0xFF00 | this._data[offset + 1] & 0xFF;
        }
        return this._data[offset + 1] << 8 & 0xFF00 | this._data[offset] & 0xFF;
    }

    private int get32Bits(int offset) {
        if (offset < 0 || offset >= this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + offset + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this._isMotorollaByteOrder) {
            return this._data[offset] << 24 & 0xFF000000 | this._data[offset + 1] << 16 & 0xFF0000 | this._data[offset + 2] << 8 & 0xFF00 | this._data[offset + 3] & 0xFF;
        }
        return this._data[offset + 3] << 24 & 0xFF000000 | this._data[offset + 2] << 16 & 0xFF0000 | this._data[offset + 1] << 8 & 0xFF00 | this._data[offset] & 0xFF;
    }
}

