/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class NikonType2MakernoteDescriptor
extends TagDescriptor {
    public NikonType2MakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 2: {
                return this.getIsoSettingDescription();
            }
            case 134: {
                return this.getDigitalZoomDescription();
            }
            case 136: {
                return this.getAutoFocusPositionDescription();
            }
        }
        return this._directory.getString(tagType);
    }

    private String getAutoFocusPositionDescription() throws MetadataException {
        if (!this._directory.containsTag(136)) {
            return null;
        }
        int[] values = this._directory.getIntArray(136);
        if (values.length != 4 || values[0] != 0 || values[2] != 0 || values[3] != 0) {
            return "Unknown (" + this._directory.getString(136) + ")";
        }
        switch (values[1]) {
            case 0: {
                return "Centre";
            }
            case 1: {
                return "Top";
            }
            case 2: {
                return "Bottom";
            }
            case 3: {
                return "Left";
            }
            case 4: {
                return "Right";
            }
        }
        return "Unknown (" + values[1] + ")";
    }

    private String getDigitalZoomDescription() throws MetadataException {
        if (!this._directory.containsTag(134)) {
            return null;
        }
        Rational rational = this._directory.getRational(134);
        if (rational.intValue() == 1) {
            return "No digital zoom";
        }
        return rational.toSimpleString(true) + "x digital zoom";
    }

    private String getIsoSettingDescription() throws MetadataException {
        if (!this._directory.containsTag(2)) {
            return null;
        }
        int[] values = this._directory.getIntArray(2);
        if (values[0] != 0 || values[1] == 0) {
            return "Unknown (" + this._directory.getString(2) + ")";
        }
        return "ISO " + values[1];
    }
}

