/*
 * Decompiled with CFR 0.152.
 */
package er.attachment;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.foundation.NSLog;
import er.attachment.model.ERAttachment;
import er.attachment.processors.ERAttachmentProcessor;
import er.extensions.components.ERXDynamicURL;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOGlobalIDUtilities;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ERAttachmentRequestHandler
extends WORequestHandler {
    public static final String REQUEST_HANDLER_KEY = "attachments";
    public static final Logger log = Logger.getLogger(ERAttachmentRequestHandler.class);
    private Delegate _delegate;

    public void setDelegate(Delegate delegate) {
        this._delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse handleRequest(WORequest request) {
        int bufferSize = 16384;
        WOApplication application = WOApplication.application();
        application.awake();
        try {
            WOResponse wOResponse;
            WOContext context = application.createContextForRequest(request);
            WOResponse response = application.createResponseInContext(context);
            String wosid = (String)request.formValueForKey("wosid");
            if (wosid == null) {
                wosid = request.cookieValueForKey("wosid");
            }
            context._setRequestSessionID(wosid);
            WOSession session = null;
            if (context._requestSessionID() != null) {
                session = WOApplication.application().restoreSessionWithID(wosid, context);
            }
            try {
                String webPath;
                String idStr;
                ERXDynamicURL url = new ERXDynamicURL((Object)request._uriDecomposed());
                String requestHandlerPath = url.requestHandlerPath();
                Matcher idMatcher = Pattern.compile("^id/(\\d+)/").matcher(requestHandlerPath);
                if (idMatcher.find()) {
                    idStr = idMatcher.group(1);
                    webPath = idMatcher.replaceFirst("/");
                } else {
                    webPath = "/" + requestHandlerPath;
                    idStr = null;
                }
                try {
                    BufferedInputStream attachmentInputStream;
                    String fileName;
                    long length;
                    String mimeType;
                    String queryString = url.queryString();
                    boolean proxyAsAttachment = queryString != null && queryString.contains("attachment=true");
                    EOEditingContext editingContext = ERXEC.newEditingContext();
                    editingContext.lock();
                    try {
                        ERAttachment attachment;
                        if (idStr != null) {
                            EOKeyGlobalID gid = EOKeyGlobalID.globalIDWithEntityName((String)"ERAttachment", (Object[])new Object[]{Integer.parseInt(idStr)});
                            attachment = (ERAttachment)ERXEOGlobalIDUtilities.fetchObjectWithGlobalID((EOEditingContext)editingContext, (EOGlobalID)gid);
                            String actualWebPath = attachment.webPath();
                            if (!actualWebPath.equals(webPath)) {
                                throw new SecurityException("You are not allowed to view the requested attachment.");
                            }
                        } else {
                            attachment = ERAttachment.fetchRequiredAttachmentWithWebPath(editingContext, webPath);
                        }
                        if (this._delegate != null && !this._delegate.attachmentVisible(attachment, request, context)) {
                            throw new SecurityException("You are not allowed to view the requested attachment.");
                        }
                        mimeType = attachment.mimeType();
                        length = attachment.size().longValue();
                        fileName = attachment.originalFileName();
                        ERAttachmentProcessor<ERAttachment> attachmentProcessor = ERAttachmentProcessor.processorForType(attachment);
                        if (!proxyAsAttachment) {
                            proxyAsAttachment = attachmentProcessor.proxyAsAttachment(attachment);
                        }
                        InputStream rawAttachmentInputStream = attachmentProcessor.attachmentInputStream(attachment);
                        attachmentInputStream = new BufferedInputStream(rawAttachmentInputStream, bufferSize);
                    }
                    finally {
                        editingContext.unlock();
                    }
                    response.setHeader(mimeType, "Content-Type");
                    response.setHeader(String.valueOf(length), "Content-Length");
                    if (proxyAsAttachment) {
                        response.setHeader("attachment; filename=\"" + fileName + "\"", "Content-Disposition");
                    }
                    response.setStatus(200);
                    response.setContentStream((InputStream)attachmentInputStream, bufferSize, (int)length);
                }
                catch (SecurityException e) {
                    NSLog.out.appendln((Throwable)e);
                    response.setContent(e.getMessage());
                    response.setStatus(403);
                }
                catch (NoSuchElementException e) {
                    NSLog.out.appendln((Throwable)e);
                    response.setContent(e.getMessage());
                    response.setStatus(404);
                }
                catch (FileNotFoundException e) {
                    NSLog.out.appendln((Throwable)e);
                    response.setContent(e.getMessage());
                    response.setStatus(404);
                }
                catch (IOException e) {
                    NSLog.out.appendln((Throwable)e);
                    response.setContent(e.getMessage());
                    response.setStatus(500);
                }
                wOResponse = response;
            }
            catch (Throwable throwable) {
                if (context._requestSessionID() != null) {
                    WOApplication.application().saveSessionForContext(context);
                }
                throw throwable;
            }
            if (context._requestSessionID() != null) {
                WOApplication.application().saveSessionForContext(context);
            }
            return wOResponse;
        }
        finally {
            application.sleep();
        }
    }

    public static interface Delegate {
        public boolean attachmentVisible(ERAttachment var1, WORequest var2, WOContext var3);
    }
}

