/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.metadata;

import er.attachment.metadata.DrewMetadataDirectoryParser;
import er.attachment.metadata.ERMetadataDirectorySet;
import er.attachment.metadata.ERMetadataParserException;
import er.attachment.metadata.IERMetadataDirectory;
import er.attachment.metadata.IERMetadataDirectoryParser;
import er.attachment.metadata.IERMetadataParser;
import er.attachment.metadata.ImageIOMetadataParser;
import er.attachment.metadata.ImageMagickCommandlineMetadataParser;
import er.attachment.metadata.JAIMetadataParser;
import er.extensions.foundation.ERXExceptionUtilities;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class ERMetadataParser {
    public static final Logger log = Logger.getLogger(ERMetadataParser.class);
    private static ERMetadataParser _metadataParser;
    private List<IERMetadataParser> _metadataParsers = new LinkedList<IERMetadataParser>();
    private List<IERMetadataDirectoryParser> _metadataDirectoryParsers = new LinkedList<IERMetadataDirectoryParser>();

    public static synchronized void setMetadataProcessor(ERMetadataParser metadataParser) {
        _metadataParser = metadataParser;
    }

    public static synchronized ERMetadataParser metadataParser() {
        if (_metadataParser == null) {
            _metadataParser = new ERMetadataParser();
            _metadataParser.addMetadataDirectoryParser(new DrewMetadataDirectoryParser());
            IERMetadataParser metadataParser = null;
            if (metadataParser == null) {
                try {
                    metadataParser = new ImageIOMetadataParser();
                }
                catch (Throwable t) {
                    log.warn((Object)("Cannot use ImageIOMetadataParser: " + ERXExceptionUtilities.toParagraph((Throwable)t)));
                }
                if (metadataParser == null) {
                    try {
                        metadataParser = ImageMagickCommandlineMetadataParser.imageMagickMetadataParser();
                    }
                    catch (Throwable t) {
                        log.warn((Object)("Cannot use ImageMagickCommandlineMetadataParser: " + ERXExceptionUtilities.toParagraph((Throwable)t)));
                    }
                }
                if (metadataParser == null) {
                    metadataParser = new JAIMetadataParser();
                }
                _metadataParser.addMetadataParser(metadataParser);
            }
        }
        return _metadataParser;
    }

    public void addMetadataParser(IERMetadataParser metadataParser) {
        this._metadataParsers.add(metadataParser);
    }

    public void addMetadataDirectoryParser(IERMetadataDirectoryParser metadataDirectoryParser) {
        this._metadataDirectoryParsers.add(metadataDirectoryParser);
    }

    public ERMetadataDirectorySet parseMetadata(File importFile) throws ERMetadataParserException {
        ERMetadataDirectorySet fullMetadataDirectorySet = new ERMetadataDirectorySet();
        for (IERMetadataParser metadataParser : this._metadataParsers) {
            ERMetadataDirectorySet tempMetadataDirectorySet = metadataParser.parseMetadata(importFile);
            if (tempMetadataDirectorySet == null) continue;
            fullMetadataDirectorySet.add(tempMetadataDirectorySet);
        }
        if (fullMetadataDirectorySet.isEmpty()) {
            log.info((Object)("No metadata handler for '" + importFile.getAbsolutePath() + "'."));
        } else {
            for (IERMetadataDirectoryParser metadataDirectoryParser : this._metadataDirectoryParsers) {
                fullMetadataDirectorySet.parseUnparsedDirectoriesWith(metadataDirectoryParser);
            }
            List<IERMetadataDirectory> unparsedMetadataDirectories = fullMetadataDirectorySet.removeUnparsedDirectories();
            if (!unparsedMetadataDirectories.isEmpty()) {
                for (IERMetadataDirectory unparsedMetadataDirectory : unparsedMetadataDirectories) {
                    log.info((Object)("No metadata handler for '" + unparsedMetadataDirectory.getDirectoryName() + " in '" + importFile.getAbsolutePath() + "'."));
                }
            }
        }
        return fullMetadataDirectorySet;
    }
}

