/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.model;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import er.attachment.model._ERAttachment;
import er.attachment.processors.ERAttachmentProcessor;
import er.attachment.utils.ERMimeType;
import er.attachment.utils.ERMimeTypeManager;
import er.extensions.foundation.ERXFileUtilities;
import java.io.File;
import org.apache.log4j.Logger;

public abstract class ERAttachment
extends _ERAttachment {
    private static Logger log = Logger.getLogger(ERAttachment.class);

    private boolean isInNestedEditingContext() {
        EOEditingContext attachmentEc = this.editingContext();
        return attachmentEc.parentObjectStore() instanceof EOEditingContext && ((EOEditingContext)attachmentEc.parentObjectStore()).objectForGlobalID(attachmentEc.globalIDForObject((EOEnterpriseObject)this)) != null;
    }

    public void didInsert() {
        super.didInsert();
        if (!this.isInNestedEditingContext()) {
            ERAttachmentProcessor.processorForType(this).attachmentInserted(this);
        }
    }

    public String fileName() {
        return new File(this.webPath()).getName();
    }

    public ERMimeType erMimeType() {
        return ERMimeTypeManager.mimeTypeManager().mimeTypeForMimeTypeString(this.mimeType(), false);
    }

    public String extension() {
        ERMimeType mimeType = this.erMimeType();
        String ext = mimeType == null ? ERXFileUtilities.fileExtension((String)this.originalFileName()).toLowerCase() : mimeType.primaryExtension();
        return ext;
    }

    public static ERAttachment fetchRequiredAttachmentWithWebPath(EOEditingContext editingContext, String webPath) {
        ERAttachment attachment = ERAttachment.fetchRequiredERAttachment(editingContext, WEB_PATH_KEY, webPath);
        return attachment;
    }

    public void didDelete(EOEditingContext ec) {
        super.didDelete(ec);
        if (!this.isInNestedEditingContext()) {
            try {
                ERAttachmentProcessor.processorForType(this).deleteAttachment(this);
            }
            catch (Throwable e) {
                log.error((Object)("Failed to delete attachment '" + this.primaryKey() + "'."), e);
            }
        }
    }
}

