/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.processors;

import com.amazon.s3.AWSAuthConnection;
import com.amazon.s3.Response;
import com.silvasoftinc.s3.S3StreamObject;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSTimestamp;
import er.attachment.model.ERS3Attachment;
import er.attachment.processors.ERAttachmentProcessor;
import er.extensions.concurrency.ERXAsyncQueue;
import er.extensions.eof.ERXEC;
import er.extensions.foundation.ERXExceptionUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERS3AttachmentProcessor
extends ERAttachmentProcessor<ERS3Attachment> {
    public static final String S3_URL = "http://s3.amazonaws.com";
    private ERS3UploadQueue _queue = new ERS3UploadQueue();

    public ERS3AttachmentProcessor() {
        this._queue.start();
    }

    @Override
    public ERS3Attachment _process(EOEditingContext editingContext, File uploadedFile, String recommendedFileName, String mimeType, String configurationName, String ownerID, boolean pendingDelete) {
        String bucket;
        boolean proxy = true;
        String proxyStr = ERXProperties.stringForKey((String)("er.attachment." + configurationName + ".s3.proxy"));
        if (proxyStr == null) {
            proxyStr = ERXProperties.stringForKey((String)"er.attachment.s3.proxy");
        }
        if (proxyStr != null) {
            proxy = Boolean.parseBoolean(proxyStr);
        }
        if ((bucket = ERXProperties.decryptedStringForKey((String)("er.attachment." + configurationName + ".s3.bucket"))) == null) {
            bucket = ERXProperties.decryptedStringForKey((String)"er.attachment.s3.bucket");
        }
        if (bucket == null) {
            throw new IllegalArgumentException("There is no 'er.attachment." + configurationName + ".s3.bucket' or 'er.attachment.s3.bucket' property set.");
        }
        String keyTemplate = ERXProperties.stringForKey((String)("er.attachment." + configurationName + ".s3.key"));
        if (keyTemplate == null) {
            keyTemplate = ERXProperties.stringForKey((String)"er.attachment.s3.key");
        }
        if (keyTemplate == null) {
            keyTemplate = "${pk}${ext}";
        }
        ERS3Attachment attachment = ERS3Attachment.createERS3Attachment(editingContext, Boolean.FALSE, new NSTimestamp(), mimeType, recommendedFileName, proxy, (int)uploadedFile.length(), null);
        if (this.delegate() != null) {
            this.delegate().attachmentCreated(this, attachment);
        }
        try {
            String key = ERAttachmentProcessor._parsePathTemplate(attachment, keyTemplate, recommendedFileName);
            attachment.setS3Location(bucket, ERXStringUtilities.urlEncode((String)key));
            String s3Path = attachment.queryStringAuthGenerator().makeBareURL(bucket, key);
            attachment.setS3Path(s3Path);
            attachment._setPendingUploadFile(uploadedFile, pendingDelete);
        }
        catch (RuntimeException e) {
            attachment.delete();
            if (pendingDelete) {
                uploadedFile.delete();
            }
            throw e;
        }
        return attachment;
    }

    @Override
    public InputStream attachmentInputStream(ERS3Attachment attachment) throws IOException {
        return new URL(attachment.s3Path()).openStream();
    }

    @Override
    public String attachmentUrl(ERS3Attachment attachment, WORequest request, WOContext context) {
        String attachmentUrl = attachment.s3Path();
        if (attachment.proxied().booleanValue()) {
            if (!attachment.acl().equals("private")) {
                log.warn((Object)"You are proxying an s3 attachment but do not have the attachment configured for private acl. This likely means the s3 attachment is publically readable via s3, and therefore I'm wondering why you are proxying it through your app. You should either change the acl configuraiton for this attachment to 'private', or why not just serve the attachment up directly from s3 ?");
            }
            try {
                attachmentUrl = new URL(attachmentUrl).getPath();
                attachmentUrl = "id/" + attachment.primaryKey() + attachmentUrl;
                attachmentUrl = context.urlWithRequestHandlerKey("attachments", attachmentUrl, null);
            }
            catch (MalformedURLException e) {
                log.fatal((Object)"attachment.s3Path() is returning something that isn't a valid URl. This is a bt strange. I'm going to reutrn it in it's raw format which will result in either a 'url cannot be found' error or may result in a 403 from s3.", (Throwable)e);
            }
        }
        return attachmentUrl;
    }

    @Override
    public void deleteAttachment(ERS3Attachment attachment) throws MalformedURLException, IOException {
        String key;
        String bucket;
        AWSAuthConnection conn = attachment.awsConnection();
        Response response = conn.delete(bucket = attachment.bucket(), key = attachment.key(), null);
        if (this.failed(response)) {
            throw new IOException("Failed to delete '" + bucket + "/" + key + "' to S3: Error " + response.connection.getResponseCode() + ": " + response.connection.getResponseMessage());
        }
    }

    @Override
    public void attachmentInserted(ERS3Attachment attachment) {
        super.attachmentInserted(attachment);
        this._queue.enqueue(attachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performUpload(File uploadedFile, String originalFileName, String bucket, String key, String mimeType, ERS3Attachment attachment) throws MalformedURLException, IOException {
        try {
            AWSAuthConnection conn = attachment.awsConnection();
            FileInputStream attachmentFileInputStream = new FileInputStream(uploadedFile);
            BufferedInputStream attachmentInputStream = new BufferedInputStream(attachmentFileInputStream);
            try {
                Response response;
                S3StreamObject attachmentStreamObject = new S3StreamObject(attachmentInputStream, null);
                TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
                headers.put("Content-Type", Arrays.asList(mimeType));
                headers.put("Content-Length", Arrays.asList(String.valueOf(uploadedFile.length())));
                headers.put("x-amz-acl", Arrays.asList(attachment.acl()));
                if (originalFileName != null) {
                    headers.put("Content-Disposition", Arrays.asList("attachment; filename=" + originalFileName));
                }
                if (this.failed(response = conn.putStream(bucket, key, attachmentStreamObject, headers))) {
                    throw new IOException("Failed to write '" + bucket + "/" + key + "' to S3: Error " + response.connection.getResponseCode() + ": " + response.connection.getResponseMessage());
                }
            }
            finally {
                attachmentInputStream.close();
            }
        }
        finally {
            if (attachment._isPendingDelete()) {
                uploadedFile.delete();
            }
        }
    }

    protected boolean failed(Response response) throws IOException {
        int responseCode = response.connection.getResponseCode();
        return responseCode < 200 || responseCode >= 300;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ERS3UploadQueue
    extends ERXAsyncQueue<ERS3QueueEntry> {
        private EOEditingContext _editingContext;

        public ERS3UploadQueue() {
            super("ERS3AsyncQueue");
            this._editingContext = ERXEC.newEditingContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueue(ERS3Attachment attachment) {
            this._editingContext.lock();
            try {
                ERS3Attachment localAttachment = attachment.localInstanceIn(this._editingContext);
                ERS3QueueEntry entry = new ERS3QueueEntry(attachment._pendingUploadFile(), localAttachment);
                this.enqueue(entry);
            }
            finally {
                this._editingContext.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void process(ERS3QueueEntry object) {
            ERS3Attachment attachment = object.attachment();
            File uploadedFile = object.uploadedFile();
            if (uploadedFile != null && uploadedFile.exists()) {
                String mimeType;
                String key;
                String bucket;
                String originalFileName = null;
                this._editingContext.lock();
                try {
                    bucket = attachment.bucket();
                    key = attachment.key();
                    mimeType = attachment.mimeType();
                    String configurationName = attachment.configurationName();
                    if (ERS3AttachmentProcessor.this.proxyAsAttachment(attachment)) {
                        originalFileName = attachment.originalFileName();
                    }
                }
                finally {
                    this._editingContext.unlock();
                }
                try {
                    ERS3AttachmentProcessor.this.performUpload(uploadedFile, originalFileName, bucket, key, mimeType, attachment);
                    this._editingContext.lock();
                    try {
                        attachment.setAvailable(Boolean.TRUE);
                        this._editingContext.saveChanges();
                    }
                    finally {
                        this._editingContext.unlock();
                    }
                    if (ERS3AttachmentProcessor.this.delegate() == null) return;
                    ERS3AttachmentProcessor.this.delegate().attachmentAvailable(ERS3AttachmentProcessor.this, attachment);
                    return;
                }
                catch (Throwable t) {
                    if (ERS3AttachmentProcessor.this.delegate() != null) {
                        ERS3AttachmentProcessor.this.delegate().attachmentNotAvailable(ERS3AttachmentProcessor.this, attachment, ERXExceptionUtilities.toParagraph((Throwable)t));
                    }
                    ERAttachmentProcessor.log.error((Object)("Failed to upload '" + uploadedFile + "' to S3."), t);
                    return;
                }
                finally {
                    if (attachment._isPendingDelete()) {
                        uploadedFile.delete();
                    }
                }
            }
            if (ERS3AttachmentProcessor.this.delegate() != null) {
                ERS3AttachmentProcessor.this.delegate().attachmentNotAvailable(ERS3AttachmentProcessor.this, attachment, "Missing attachment file '" + uploadedFile + "'.");
            }
            ERAttachmentProcessor.log.error((Object)("Missing attachment file '" + uploadedFile + "'."));
        }
    }

    public class ERS3QueueEntry {
        private File _uploadedFile;
        private ERS3Attachment _attachment;

        public ERS3QueueEntry(File uploadedFile, ERS3Attachment attachment) {
            this._uploadedFile = uploadedFile;
            this._attachment = attachment;
        }

        public File uploadedFile() {
            return this._uploadedFile;
        }

        public ERS3Attachment attachment() {
            return this._attachment;
        }
    }
}

