/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.thumbnail;

import er.attachment.thumbnail.IERImageProcessor;
import er.attachment.thumbnail.ImageIOImageProcessor;
import er.attachment.thumbnail.ImageMagickImageProcessor;
import er.attachment.thumbnail.Java2DImageProcessor;
import er.attachment.thumbnail.SipsImageProcessor;
import er.attachment.utils.ERMimeType;
import er.attachment.utils.ERMimeTypeManager;
import er.extensions.foundation.ERXExceptionUtilities;
import er.extensions.foundation.ERXProperties;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class ERImageProcessor
implements IERImageProcessor {
    public static final Logger log = Logger.getLogger(ERImageProcessor.class);
    public static volatile IERImageProcessor _imageProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IERImageProcessor imageProcessor() {
        IERImageProcessor imageProcessor = _imageProcessor;
        if (imageProcessor != null) return imageProcessor;
        Class<IERImageProcessor> clazz = IERImageProcessor.class;
        synchronized (IERImageProcessor.class) {
            if (imageProcessor != null) return imageProcessor;
            String imageProcessorKey = ERXProperties.stringForKey((String)"er.attachment.thumbnail.imageProcessor");
            if (imageProcessorKey != null) {
                if ("sips".equals(imageProcessorKey)) {
                    imageProcessor = new SipsImageProcessor();
                } else if ("imageio".equals(imageProcessorKey)) {
                    imageProcessor = ImageIOImageProcessor.imageIOImageProcessor();
                } else if ("imagemagick".equals(imageProcessorKey)) {
                    try {
                        imageProcessor = ImageMagickImageProcessor.imageMagickImageProcessor();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Failed to load ImageMagick image processor.", t);
                    }
                } else {
                    if (!"java".equals(imageProcessorKey)) throw new IllegalArgumentException("Unknown image processor '" + imageProcessorKey + "'.");
                    imageProcessor = new Java2DImageProcessor();
                }
            } else {
                try {
                    imageProcessor = ImageIOImageProcessor.imageIOImageProcessor();
                }
                catch (Throwable t) {
                    log.warn((Object)("Cannot use ImageIOProcessor: " + ERXExceptionUtilities.toParagraph((Throwable)t)));
                }
                if (imageProcessor == null) {
                    try {
                        imageProcessor = ImageMagickImageProcessor.imageMagickImageProcessor();
                    }
                    catch (Throwable t) {
                        log.warn((Object)("Cannot use ImageMagickImageProcessor: " + ERXExceptionUtilities.toParagraph((Throwable)t)));
                    }
                }
                if (imageProcessor == null) {
                    imageProcessor = new Java2DImageProcessor();
                }
            }
            _imageProcessor = imageProcessor;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return imageProcessor;
        }
    }

    public void thumbnail(int resizeWidth, int resizeHeight, File inputFile, File outputFile) throws IOException {
        ERMimeType outputMimeType = ERMimeTypeManager.mimeTypeManager().mimeTypeForFile(outputFile, true);
        this.thumbnail(resizeWidth, resizeHeight, inputFile, outputFile, outputMimeType);
    }

    public void thumbnail(int resizeWidth, int resizeHeight, File inputFile, File outputFile, ERMimeType outputMimeType) throws IOException {
        this.processImage(resizeWidth, resizeHeight, null, -1, 2.5f, 0.35f, 0.0f, -1, -1, -1, -1, null, false, 0.9f, null, inputFile, outputFile, outputMimeType);
    }
}

