/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.thumbnail;

import er.attachment.thumbnail.ERImageProcessor;
import er.attachment.thumbnail.IERImageProcessor;
import er.attachment.utils.ERMimeType;
import er.extensions.foundation.ERXRuntimeUtilities;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public class SipsImageProcessor
extends ERImageProcessor {
    public void processImage(int resizeWidth, int resizeHeight, IERImageProcessor.Quality resizeQuality, int dpi, float sharpenRadius, float sharpenIntensity, float gamma, int cropX, int cropY, int cropWidth, int cropHeight, File watermarkFile, boolean tileWatermark, float compressionQuality, File colorProfileFile, File inputFile, File outputFile, ERMimeType outputMimeType) throws IOException {
        try {
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                throw new IOException("Failed to create the folder '" + outputFile.getParentFile() + "'.");
            }
            LinkedList<String> commands = new LinkedList<String>();
            commands.add("/usr/bin/sips");
            commands.add("--resampleHeightWidthMax");
            commands.add(String.valueOf(Math.max(resizeWidth, resizeHeight)));
            if (resizeQuality != null) {
                if (resizeQuality == IERImageProcessor.Quality.High) {
                    commands.add("--setProperty");
                    commands.add("quality");
                    commands.add("best");
                } else if (resizeQuality == IERImageProcessor.Quality.Medium) {
                    commands.add("--setProperty");
                    commands.add("quality");
                    commands.add("normal");
                } else if (resizeQuality == IERImageProcessor.Quality.Low) {
                    commands.add("--setProperty");
                    commands.add("quality");
                    commands.add("draft");
                }
            }
            if (outputMimeType != null) {
                commands.add("--setProperty");
                commands.add("typeIdentifier");
                commands.add(outputMimeType.uti());
            }
            if (compressionQuality != -1.0f) {
                commands.add("--setProperty");
                commands.add("formatOptions");
                commands.add(String.format("%.0f", Float.valueOf(compressionQuality * 100.0f)));
            }
            if ((double)dpi > 0.0) {
                commands.add("--setProperty");
                commands.add("dpiWidth");
                commands.add(String.valueOf(dpi));
                commands.add("--setProperty");
                commands.add("dpiHeight");
                commands.add(String.valueOf(dpi));
            }
            if (sharpenRadius > 0.0f || sharpenIntensity > 0.0f) {
                log.info((Object)"SipsImageProcessor does not yet support sharpening.");
            }
            if (gamma > 0.0f) {
                log.info((Object)"SipsImageProcessor does not yet support changing the image gamma.");
            }
            if ((float)cropX > 0.0f || (float)cropY > 0.0f) {
                log.info((Object)"SipsImageProcessor does not yet support cropping offsets.");
            }
            if ((float)cropWidth > 0.0f && (float)cropHeight > 0.0f) {
                commands.add("--cropToHeightWidth");
                commands.add(String.valueOf(cropHeight));
                commands.add(String.valueOf(cropWidth));
            }
            if (watermarkFile != null) {
                log.info((Object)"SipsImageProcessor does not yet support watermarking.");
            }
            if (colorProfileFile != null) {
                commands.add("-m");
                commands.add(colorProfileFile.getCanonicalPath());
            }
            commands.add(inputFile.getCanonicalPath());
            commands.add("--out");
            commands.add(outputFile.getCanonicalPath());
            ERXRuntimeUtilities.Result result = ERXRuntimeUtilities.execute((String[])commands.toArray(new String[commands.size()]), null, null, (long)30000L);
            if (result.getExitValue() != 0) {
                throw new RuntimeException("Sips exited with the exit code #" + result.getExitValue());
            }
        }
        catch (Throwable t) {
            throw new IOException("Failed to thumbnail image: " + t.getMessage() + " (also, Java 1.5 is stupid!)");
        }
    }
}

