/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.String_Extensions;
import com.webobjects.monitor.application.AppConfigurePage;
import com.webobjects.monitor.application.AppDetailPage;
import com.webobjects.monitor.application.ConfirmationPage;
import com.webobjects.monitor.application.MonitorComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationsPage
extends MonitorComponent {
    private static final long serialVersionUID = -2523319756655905750L;
    public MApplication currentApplication;
    public String newApplicationName;

    public ApplicationsPage(WOContext aWocontext) {
        super(aWocontext);
        this.handler().updateForPage(this.name());
    }

    public NSArray<MApplication> applications() {
        NSMutableArray result = new NSMutableArray();
        result.addObjectsFromArray((NSArray)this.mySession().siteConfig().applicationArray());
        EOSortOrdering order = new EOSortOrdering("name", EOSortOrdering.CompareAscending);
        EOSortOrdering.sortArrayUsingKeyOrderArray((NSMutableArray)result, (NSArray)new NSArray((Object)order));
        return result;
    }

    public String hrefToApp() {
        String aURL = this.siteConfig().woAdaptor();
        if (aURL != null) {
            aURL = aURL + "/" + this.currentApplication.name();
        }
        return aURL;
    }

    public WOComponent appDetailsClicked() {
        return AppDetailPage.create(this.context(), this.currentApplication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent addApplicationClicked() {
        if (String_Extensions.isValidXMLString((String)this.newApplicationName)) {
            this.handler().startReading();
            try {
                if (this.siteConfig().applicationWithName(this.newApplicationName) == null) {
                    MApplication newApplication = new MApplication(this.newApplicationName, this.siteConfig());
                    this.siteConfig().addApplication_M(newApplication);
                    if (this.siteConfig().hostArray().count() != 0) {
                        this.handler().sendAddApplicationToWotaskds(newApplication, (NSArray)this.siteConfig().hostArray());
                    }
                    AppConfigurePage aPage = AppConfigurePage.create(this.context(), newApplication);
                    aPage.isNewInstanceSectionVisible = true;
                    AppConfigurePage appConfigurePage = aPage;
                    return appConfigurePage;
                }
            }
            finally {
                this.handler().endReading();
            }
        }
        this.newApplicationName = null;
        return ApplicationsPage.create(this.context());
    }

    public static WOComponent create(WOContext context) {
        return context.page().pageWithName(ApplicationsPage.class.getName());
    }

    public WOComponent deleteClicked() {
        final MApplication application = this.currentApplication;
        return ConfirmationPage.create(this.context(), new ConfirmationPage.Delegate(){

            public WOComponent cancel() {
                return ApplicationsPage.create(ApplicationsPage.this.context());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public WOComponent confirm() {
                ApplicationsPage.this.handler().startWriting();
                try {
                    ApplicationsPage.this.siteConfig().removeApplication_M(application);
                    if (ApplicationsPage.this.siteConfig().hostArray().count() != 0) {
                        ApplicationsPage.this.handler().sendRemoveApplicationToWotaskds(application, (NSArray)ApplicationsPage.this.siteConfig().hostArray());
                    }
                }
                finally {
                    ApplicationsPage.this.handler().endWriting();
                }
                return ApplicationsPage.create(ApplicationsPage.this.context());
            }

            public String explaination() {
                return "Selecting 'Yes' will shutdown any running instances of this application, delete all instance configurations, and remove this application from the Application page.";
            }

            public int pageType() {
                return 0;
            }

            public String question() {
                return "Are you sure you want to delete the <I>" + application.name() + "</I> Application?";
            }
        });
    }

    public WOComponent bounceClicked() {
        AppDetailPage page = AppDetailPage.create(this.context(), this.currentApplication);
        page = (AppDetailPage)page.bounceClicked();
        return page;
    }

    public WOComponent configureClicked() {
        AppConfigurePage aPage = AppConfigurePage.create(this.context(), this.currentApplication);
        aPage.isNewInstanceSectionVisible = true;
        return aPage;
    }
}

