/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MonitorException;
import com.webobjects.monitor.application.MonitorComponent;
import com.webobjects.monitor.application.RemoteBrowseClient;

public class FileBrowser
extends MonitorComponent {
    private static final long serialVersionUID = 7523872426979817711L;
    public String startingPath;
    public String callbackUpdateAction;
    public String callbackSelectionAction;
    public MHost host;
    public boolean showFiles = true;
    public boolean isRoots = false;
    public String errorMsg;
    public NSDictionary aCurrentFile;
    public NSArray _fileList = null;

    public FileBrowser(WOContext aWocontext) {
        super(aWocontext);
    }

    boolean shouldShowError() {
        return this.errorMsg != null && this.errorMsg.length() > 0;
    }

    public NSArray fileList() {
        if (this._fileList == null) {
            this.retrieveFileList();
        }
        return this._fileList;
    }

    private String retrieveFileList() {
        try {
            NSDictionary aDict = RemoteBrowseClient.fileListForStartingPathHost(this.startingPath, this.host, this.showFiles);
            this._fileList = (NSArray)aDict.valueForKey("fileArray");
            this.isRoots = aDict.valueForKey("isRoots") != null;
            this.startingPath = (String)aDict.valueForKey("filepath");
            this.errorMsg = null;
        }
        catch (MonitorException me) {
            if (this.isRoots) {
                this.startingPath = null;
            }
            NSLog.err.appendln((Object)("Path Wizard Error: " + me.getMessage()));
            me.printStackTrace();
            this.errorMsg = me.getMessage();
        }
        return this.errorMsg;
    }

    public boolean isCurrentFileDirectory() {
        String aString = (String)this.aCurrentFile.valueForKey("fileType");
        return aString.equals("NSFileTypeDirectory");
    }

    public Object backClicked() {
        String originalPath = this.startingPath;
        this.startingPath = NSPathUtilities.stringByDeletingLastPathComponent((String)this.startingPath);
        this.startingPath = NSPathUtilities._standardizedPath((String)this.startingPath);
        if (this.startingPath.equals("") || originalPath.equals(this.startingPath)) {
            this.startingPath = null;
        }
        if (this.retrieveFileList() != null) {
            this.startingPath = originalPath;
        }
        return this.performParentAction(this.callbackUpdateAction);
    }

    public Object directoryClicked() {
        String originalPath = this.startingPath;
        String aFile = (String)this.aCurrentFile.valueForKey("file");
        this.startingPath = NSPathUtilities.stringByAppendingPathComponent((String)this.startingPath, (String)aFile);
        this.startingPath = NSPathUtilities._standardizedPath((String)this.startingPath);
        this.retrieveFileList();
        if (this.retrieveFileList() != null) {
            this.startingPath = originalPath;
        }
        return this.performParentAction(this.callbackUpdateAction);
    }

    public Object jumpToClicked() {
        String originalPath = this.startingPath;
        this.startingPath = NSPathUtilities._standardizedPath((String)this.startingPath);
        this.retrieveFileList();
        if (this.retrieveFileList() != null) {
            this.startingPath = originalPath;
        }
        return this.performParentAction(this.callbackUpdateAction);
    }

    public Object selectClicked() {
        String aFile = (String)this.aCurrentFile.valueForKey("file");
        this.startingPath = NSPathUtilities.stringByAppendingPathComponent((String)this.startingPath, (String)aFile);
        this.startingPath = NSPathUtilities._standardizedPath((String)this.startingPath);
        return this.performParentAction(this.callbackSelectionAction);
    }

    public Object selectCurrentDirClicked() {
        this.startingPath = NSPathUtilities._standardizedPath((String)this.startingPath);
        return this.performParentAction(this.callbackSelectionAction);
    }
}

