/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor.application.MonitorComponent;

public class HostConfigurePage
extends MonitorComponent {
    private static final long serialVersionUID = -2948616033564158515L;
    private String _hostTypeSelection;
    public NSArray hostTypeList = MObject.hostTypeArray;

    public HostConfigurePage(WOContext aWocontext) {
        super(aWocontext);
    }

    public String hostTypeSelection() {
        if (this._hostTypeSelection == null) {
            String type = this.myHost().osType();
            for (int i = this.hostTypeList.count() - 1; i >= 0; --i) {
                String myHostTypeSelection = (String)this.hostTypeList.objectAtIndex(i);
                if (!type.equalsIgnoreCase(myHostTypeSelection)) continue;
                this._hostTypeSelection = myHostTypeSelection;
            }
        }
        return this._hostTypeSelection;
    }

    public void setHostTypeSelection(String newType) {
        this._hostTypeSelection = newType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent configureHostClicked() {
        this.handler().startWriting();
        try {
            MHost host = this.myHost();
            if (this._hostTypeSelection != null && !this._hostTypeSelection.toUpperCase().equals(host.osType())) {
                host.setOsType(this._hostTypeSelection.toUpperCase());
                this.handler().sendUpdateHostToWotaskds(host, (NSArray)this.siteConfig().hostArray());
            }
        }
        finally {
            this.handler().endWriting();
        }
        return HostConfigurePage.create(this.context(), this.myHost());
    }

    public WOComponent syncHostClicked() {
        MHost host = this.myHost();
        this.siteConfig().hostErrorArray.addObjectIfAbsent((Object)host);
        this.handler().sendUpdateHostToWotaskds(host, new NSArray((Object)host));
        return HostConfigurePage.create(this.context(), this.myHost());
    }

    public static HostConfigurePage create(WOContext context, MHost host) {
        HostConfigurePage page = (HostConfigurePage)context.page().pageWithName(HostConfigurePage.class.getName());
        page.setMyHost(host);
        return page;
    }
}

