/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor.application.AppConfigurePage;
import com.webobjects.monitor.application.AppDetailPage;
import com.webobjects.monitor.application.MonitorComponent;
import com.webobjects.monitor.application.PathWizardPage1;

public class InstConfigurePage
extends MonitorComponent {
    private static final long serialVersionUID = 2930097368474314793L;
    private static String _diffString = "<span class=\"Warning\">**</span>";
    private static String _emptyString = "";

    public InstConfigurePage(WOContext aWocontext) {
        super(aWocontext);
    }

    public boolean isWindowsHost() {
        return this.myInstance().host().osType().equals("WINDOWS");
    }

    public WOComponent returnClicked() {
        return AppDetailPage.create(this.context(), this.myInstance().application());
    }

    public WOComponent appConfigLinkClicked() {
        AppConfigurePage aPage = AppConfigurePage.create(this.context(), this.myApplication());
        aPage.isNewInstanceSectionVisible = true;
        return aPage;
    }

    private WOComponent _pathPickerWizardClicked(String callbackKeyPath) {
        PathWizardPage1 aPage = PathWizardPage1.create(this.context());
        aPage.setCallbackKeypath(callbackKeyPath);
        aPage.setCallbackPage((WOComponent)this);
        aPage.setShowFiles(true);
        return aPage;
    }

    public WOComponent pathPickerWizardClicked() {
        return this._pathPickerWizardClicked("myInstance.path");
    }

    public WOComponent pathPickerWizardClickedOutput() {
        return this._pathPickerWizardClicked("myInstance.outputPath");
    }

    public Integer port() {
        return this.myInstance().port();
    }

    public void setPort(Integer value) {
        if (value == null) {
            return;
        }
        if (!value.equals(this.myInstance().port())) {
            if (this.myInstance().state != MObject.DEAD) {
                this.mySession().addErrorIfAbsent("This instance is still running; unable to change port");
                return;
            }
            if (!this.myInstance().host().isPortInUse(value)) {
                this.myInstance().setPort(value);
            } else {
                this.mySession().addErrorIfAbsent("This port is in use");
            }
        }
    }

    public Integer id() {
        return this.myInstance().id();
    }

    public String displayName() {
        return this.myInstance().displayName();
    }

    public void setDisplayName(Object foo) {
    }

    public void setId(Integer value) {
        if (value == null) {
            return;
        }
        if (!value.equals(this.myInstance().id())) {
            if (!this.myInstance().application().isIDInUse(value)) {
                this.myInstance().setId(value);
            } else {
                this.mySession().addErrorIfAbsent("This ID is in use");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent startupUpdateClicked() {
        this.handler().startReading();
        try {
            this.handler().sendUpdateInstancesToWotaskds((NSArray<MInstance>)new NSArray((Object)this.myInstance()), (NSArray)this.allHosts());
        }
        finally {
            this.handler().endReading();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent adaptorSettingsUpdateClicked() {
        this.handler().startReading();
        try {
            this.handler().sendUpdateInstancesToWotaskds((NSArray<MInstance>)new NSArray((Object)this.myInstance()), (NSArray)this.allHosts());
        }
        finally {
            this.handler().endReading();
        }
        return null;
    }

    private boolean safeEquals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return (a instanceof String || b instanceof String) && (a == null && b != null && ((String)b).length() == 0 || b == null && a != null && ((String)a).length() == 0);
    }

    public String pathDiff() {
        MInstance myInstance = this.myInstance();
        MApplication myApplication = myInstance.application();
        MHost myHost = myInstance.host();
        String appPath = null;
        if (myHost.osType().equals("UNIX")) {
            appPath = myApplication.unixPath();
        } else if (myHost.osType().equals("WINDOWS")) {
            appPath = myApplication.winPath();
        } else if (myHost.osType().equals("MACOSX")) {
            appPath = myApplication.macPath();
        }
        if (!this.safeEquals(myInstance.path(), appPath)) {
            return _diffString;
        }
        return _emptyString;
    }

    public String minDiff() {
        MInstance myInstance = this.myInstance();
        MApplication myApplication = myInstance.application();
        if (!this.safeEquals(myInstance.minimumActiveSessionsCount(), myApplication.minimumActiveSessionsCount())) {
            return _diffString;
        }
        return _emptyString;
    }

    public String cachingDiff() {
        MInstance myInstance = this.myInstance();
        MApplication myApplication = myInstance.application();
        if (!this.safeEquals(myInstance.cachingEnabled(), myApplication.cachingEnabled())) {
            return _diffString;
        }
        return _emptyString;
    }

    public String outputDiff() {
        MInstance myInstance = this.myInstance();
        MApplication myApplication = myInstance.application();
        MHost myHost = myInstance.host();
        String appOutputPath = null;
        if (myHost.osType().equals("UNIX")) {
            appOutputPath = myInstance.generateOutputPath(myApplication.unixOutputPath());
        } else if (myHost.osType().equals("WINDOWS")) {
            appOutputPath = myInstance.generateOutputPath(myApplication.winOutputPath());
        } else if (myHost.osType().equals("MACOSX")) {
            appOutputPath = myInstance.generateOutputPath(myApplication.macOutputPath());
        }
        if (!this.safeEquals(myInstance.outputPath(), appOutputPath)) {
            return _diffString;
        }
        return _emptyString;
    }

    public String browserDiff() {
        MInstance myInstance = this.myInstance();
        MApplication myApplication = myInstance.application();
        if (!this.safeEquals(myInstance.autoOpenInBrowser(), myApplication.autoOpenInBrowser())) {
            return _diffString;
        }
        return _emptyString;
    }

    public String debugDiff() {
        MInstance myInstance = this.myInstance();
        MApplication myApplication = myInstance.application();
        if (!this.safeEquals(myInstance.debuggingEnabled(), myApplication.debuggingEnabled())) {
            return _diffString;
        }
        return _emptyString;
    }

    public String lifebeatDiff() {
        MInstance myInstance = this.myInstance();
        MApplication myApplication = myInstance.application();
        if (!this.safeEquals(myInstance.lifebeatInterval(), myApplication.lifebeatInterval())) {
            return _diffString;
        }
        return _emptyString;
    }

    public String argsDiff() {
        MInstance myInstance = this.myInstance();
        MApplication myApplication = myInstance.application();
        if (!this.safeEquals(myInstance.additionalArgs(), myApplication.additionalArgs())) {
            return _diffString;
        }
        return _emptyString;
    }

    public WOComponent forceQuitClicked() {
        this.handler().sendQuitInstancesToWotaskds((NSArray<MInstance>)new NSArray((Object)this.myInstance()), (NSArray<MHost>)new NSArray((Object)this.myInstance().host()));
        return null;
    }

    public String instanceLifebeatInterval() {
        return this.myInstance().lifebeatInterval().toString();
    }

    public static InstConfigurePage create(WOContext context, MInstance instance) {
        InstConfigurePage page = (InstConfigurePage)context.page().pageWithName(InstConfigurePage.class.getName());
        page.setMyInstance(instance);
        return page;
    }
}

