/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSData;
import com.webobjects.monitor.application.Application;
import com.webobjects.monitor.application.MonitorComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MigrationPage
extends MonitorComponent {
    private static final long serialVersionUID = -1317986389844426074L;
    public String host;
    public String username;
    public NSData sshIdentityContent;
    public String sshIdentityFilepath;
    public String remoteFilepath;
    public Boolean shouldRestartApache;
    public String migrationStackTrace = null;
    public String adaptorConfigContent;
    public String adaptorConfigLocalFilepath;

    public MigrationPage(WOContext aWocontext) {
        super(aWocontext);
    }

    public String adaptorConfigContent() {
        Application app = (Application)WOApplication.application();
        this.adaptorConfigContent = this.siteConfig().generateHttpWebObjectsConfig().toString();
        return this.adaptorConfigContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent migrate() {
        FileOutputStream adaptorConfigFileOutputStream = null;
        try {
            adaptorConfigFileOutputStream = new FileOutputStream(new File("/tmp/http-webobjects.conf"));
            FileChannel fc = adaptorConfigFileOutputStream.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(this.adaptorConfigContent().length());
            buffer.put(this.adaptorConfigContent.getBytes());
            buffer.flip();
            while (buffer.hasRemaining()) {
                fc.write(buffer);
            }
            if (this.shouldRestartApache.booleanValue()) {
                // empty if block
            }
            this.migrationStackTrace = "";
        }
        catch (Exception e) {
            this.migrationStackTrace = e.getMessage();
        }
        finally {
            try {
                if (adaptorConfigFileOutputStream != null) {
                    adaptorConfigFileOutputStream.close();
                }
            }
            catch (Exception e) {
                this.migrationStackTrace = this.migrationStackTrace + "\n" + e.getMessage();
            }
        }
        return null;
    }

    public boolean getIsMigrationCompleted() {
        return this.migrationStackTrace != null && this.migrationStackTrace.length() == 0;
    }

    public String getMigrationStackTrace() {
        return this.migrationStackTrace;
    }

    public boolean getIsFailed() {
        return this.migrationStackTrace != null && this.migrationStackTrace.length() > 0;
    }
}

