/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOHTTPConnection;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.xml.WOXMLException;
import com.webobjects.appserver.xml._JavaMonitorDecoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.MonitorException;
import com.webobjects.monitor.application.Application;
import com.webobjects.monitor.application.MonitorComponent;
import com.webobjects.monitor.application.WOTaskdHandler;

public class RemoteBrowseClient
extends MonitorComponent {
    private static final long serialVersionUID = 3929193699509459110L;
    private static byte[] evilHack = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>".getBytes();
    private static String getPathString = "/cgi-bin/WebObjects/wotaskd.woa/wa/RemoteBrowse/getPath";

    public RemoteBrowseClient(WOContext aWocontext) {
        super(aWocontext);
    }

    public static NSDictionary _getFileListOutOfResponse(WOResponse aResponse, String thePath) throws MonitorException {
        NSData responseContent = aResponse.content();
        NSArray anArray = NSArray.EmptyArray;
        if (responseContent != null) {
            byte[] responseContentBytes = responseContent.bytes();
            String responseContentString = new String(responseContentBytes);
            if (responseContentString.startsWith("ERROR")) {
                throw new MonitorException("Path " + thePath + " does not exist");
            }
            _JavaMonitorDecoder aDecoder = new _JavaMonitorDecoder();
            try {
                byte[] evilHackCombined = new byte[responseContentBytes.length + evilHack.length];
                System.arraycopy(evilHack, 0, evilHackCombined, 0, evilHack.length);
                System.arraycopy(responseContentBytes, 0, evilHackCombined, evilHack.length, responseContentBytes.length);
                anArray = (NSArray)aDecoder.decodeRootObject(new NSData(evilHackCombined));
            }
            catch (WOXMLException wxe) {
                NSLog.err.appendln((Object)("RemoteBrowseClient _getFileListOutOfResponse Error decoding response: " + responseContentString));
                throw new MonitorException("Host returned bad response for path " + thePath);
            }
        } else {
            NSLog.err.appendln((Object)"RemoteBrowseClient _getFileListOutOfResponse Error decoding null response");
            throw new MonitorException("Host returned null response for path " + thePath);
        }
        String isRoots = aResponse.headerForKey((Object)"isRoots");
        String filepath = aResponse.headerForKey((Object)"filepath");
        NSMutableDictionary aDict = new NSMutableDictionary();
        aDict.takeValueForKey((Object)isRoots, "isRoots");
        aDict.takeValueForKey((Object)filepath, "filepath");
        aDict.takeValueForKey((Object)anArray, "fileArray");
        return aDict;
    }

    public static NSDictionary fileListForStartingPathHost(String aString, MHost aHost, boolean showFiles) throws MonitorException {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"!@#$!@#$ fileListForStartingPathHost creates a WOHTTPConnection");
        }
        NSDictionary aFileListDictionary = null;
        try {
            Application theApplication = (Application)WOApplication.application();
            WOHTTPConnection anHTTPConnection = new WOHTTPConnection(aHost.name(), theApplication.lifebeatDestinationPort());
            NSMutableDictionary aHeadersDict = WOTaskdHandler.siteConfig().passwordDictionary().mutableClone();
            WORequest aRequest = null;
            WOResponse aResponse = null;
            boolean requestSucceeded = false;
            aHeadersDict.setObjectForKey((Object)new NSMutableArray((Object)(aString != null && aString.length() > 0 ? aString : "/Library/WebObjects")), (Object)"filepath");
            if (showFiles) {
                aHeadersDict.setObjectForKey((Object)new NSMutableArray((Object)"YES"), (Object)"showFiles");
            }
            aRequest = new WORequest(MObject._GET, getPathString, MObject._HTTP1, (NSDictionary)aHeadersDict, null, null);
            anHTTPConnection.setReceiveTimeout(5000);
            requestSucceeded = anHTTPConnection.sendRequest(aRequest);
            if (requestSucceeded) {
                aResponse = anHTTPConnection.readResponse();
            }
            if (aResponse == null || !requestSucceeded || aResponse.status() != 200) {
                throw new MonitorException("Error requesting directory listing for " + aString + " from " + aHost.name());
            }
            try {
                aFileListDictionary = RemoteBrowseClient._getFileListOutOfResponse(aResponse, aString);
            }
            catch (MonitorException me) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x400000L)) {
                    NSLog.debug.appendln((Object)("caught exception: " + (Object)((Object)me)));
                }
                throw me;
            }
            aHost.isAvailable = true;
        }
        catch (MonitorException me) {
            aHost.isAvailable = true;
            throw me;
        }
        catch (Exception localException) {
            aHost.isAvailable = false;
            NSLog.err.appendln((Object)"Exception requesting directory listing: ");
            localException.printStackTrace();
            throw new MonitorException("Exception requesting directory listing for " + aString + " from " + aHost.name() + ": " + localException.toString());
        }
        return aFileListDictionary;
    }
}

