/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.xml.WOXMLException;
import com.webobjects.appserver.xml._JavaMonitorCoder;
import com.webobjects.appserver.xml._JavaMonitorDecoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation._NSCollectionReaderWriterLock;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.MSiteConfig;
import com.webobjects.monitor._private.String_Extensions;
import com.webobjects.monitor.application.AppDetailPage;
import com.webobjects.monitor.application.Application;
import com.webobjects.monitor.application.ApplicationsPage;
import com.webobjects.monitor.application.HostsPage;
import er.extensions.foundation.ERXStringUtilities;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WOTaskdHandler {
    private static _NSCollectionReaderWriterLock _lock = new _NSCollectionReaderWriterLock();
    private static MSiteConfig _siteConfig;
    public Application _theApplication = (Application)WOApplication.application();
    ErrorCollector _session;
    private static Object[] commandInstanceKeys;
    public static NSDictionary responseParsingFailed;
    public static NSDictionary emptyResponse;

    public static MSiteConfig siteConfig() {
        return _siteConfig;
    }

    public static void createSiteConfig() {
        _siteConfig = MSiteConfig.unarchiveSiteConfig((boolean)false);
        if (_siteConfig == null) {
            NSLog.err.appendln((Object)"The Site Configuration could not be loaded from the local filesystem");
            System.exit(1);
        }
        Enumeration e = _siteConfig.hostArray().objectEnumerator();
        while (e.hasMoreElements()) {
            WOTaskdHandler._siteConfig.hostErrorArray.addObjectIfAbsent(e.nextElement());
        }
        if (_siteConfig.localHost() != null) {
            WOTaskdHandler._siteConfig.hostErrorArray.removeObject((Object)_siteConfig.localHost());
        }
    }

    public WOTaskdHandler(ErrorCollector session) {
        this._session = session;
    }

    private ErrorCollector mySession() {
        return this._session;
    }

    private static _NSCollectionReaderWriterLock lock() {
        return _lock;
    }

    public void startReading() {
        WOTaskdHandler.lock().startReading();
    }

    public void endReading() {
        WOTaskdHandler.lock().endReading();
    }

    public void startWriting() {
        WOTaskdHandler.lock().startWriting();
    }

    public void endWriting() {
        WOTaskdHandler.lock().endWriting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateForPage(String aName) {
        MSiteConfig siteConfig = WOTaskdHandler.siteConfig();
        this.startReading();
        try {
            aName = ERXStringUtilities.lastPropertyKeyInKeyPath((String)aName);
            if (siteConfig.hostArray().count() != 0) {
                if (ApplicationsPage.class.getName().endsWith(aName) && siteConfig.applicationArray().count() != 0) {
                    Enumeration e = siteConfig.applicationArray().objectEnumerator();
                    while (e.hasMoreElements()) {
                        MApplication anApp = (MApplication)e.nextElement();
                        anApp.setRunningInstancesCount(0);
                    }
                    NSMutableArray hostArray = siteConfig.hostArray();
                    this.getApplicationStatusForHosts((NSArray<MHost>)hostArray);
                } else if (AppDetailPage.class.getName().endsWith(aName)) {
                    NSMutableArray hostArray = siteConfig.hostArray();
                    this.getInstanceStatusForHosts((NSArray<MHost>)hostArray);
                } else if (HostsPage.class.getName().endsWith(aName)) {
                    NSMutableArray hostArray = siteConfig.hostArray();
                    this.getHostStatusForHosts((NSArray<MHost>)hostArray);
                }
            }
        }
        finally {
            this.endReading();
        }
    }

    private static NSMutableDictionary createUpdateRequestDictionary(MSiteConfig _Config, MHost _Host, MApplication _Application, NSArray _InstanceArray, String requestType) {
        NSMutableDictionary monitorRequest = new NSMutableDictionary(1);
        NSMutableDictionary updateWotaskd = new NSMutableDictionary(1);
        NSMutableDictionary requestTypeDict = new NSMutableDictionary();
        if (_Config != null) {
            NSDictionary site = new NSDictionary((NSDictionary)_Config.values());
            requestTypeDict.takeValueForKey((Object)site, "site");
        }
        if (_Host != null) {
            NSArray hostArray = new NSArray((Object)_Host.values());
            requestTypeDict.takeValueForKey((Object)hostArray, "hostArray");
        }
        if (_Application != null) {
            NSArray applicationArray = new NSArray((Object)_Application.values());
            requestTypeDict.takeValueForKey((Object)applicationArray, "applicationArray");
        }
        if (_InstanceArray != null) {
            int instanceCount = _InstanceArray.count();
            NSMutableArray instanceArray = new NSMutableArray(instanceCount);
            for (int i = 0; i < instanceCount; ++i) {
                MInstance anInst = (MInstance)_InstanceArray.objectAtIndex(i);
                instanceArray.addObject((Object)anInst.values());
            }
            requestTypeDict.takeValueForKey((Object)instanceArray, "instanceArray");
        }
        updateWotaskd.takeValueForKey((Object)requestTypeDict, requestType);
        monitorRequest.takeValueForKey((Object)updateWotaskd, "updateWotaskd");
        return monitorRequest;
    }

    public WOResponse[] sendRequest(NSDictionary monitorRequest, NSArray wotaskdArray, boolean willChange) {
        String encodedRootObjectForKey = new _JavaMonitorCoder().encodeRootObjectForKey((Object)monitorRequest, "monitorRequest");
        NSData content = new NSData(encodedRootObjectForKey.getBytes());
        return MHost.sendRequestToWotaskdArray((NSData)content, (NSArray)wotaskdArray, (boolean)willChange);
    }

    public void sendAddInstancesToWotaskds(NSArray newInstancesArray, NSArray wotaskdArray) {
        WOResponse[] responses = this.sendRequest((NSDictionary)WOTaskdHandler.createUpdateRequestDictionary(null, null, null, newInstancesArray, "add"), wotaskdArray, true);
        NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
        this.getUpdateErrors(responseDicts, "add", false, false, true, false);
    }

    public void sendAddApplicationToWotaskds(MApplication newApplication, NSArray wotaskdArray) {
        WOResponse[] responses = this.sendRequest((NSDictionary)WOTaskdHandler.createUpdateRequestDictionary(null, null, newApplication, null, "add"), wotaskdArray, true);
        NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
        this.getUpdateErrors(responseDicts, "add", false, true, false, false);
    }

    public void sendAddHostToWotaskds(MHost newHost, NSArray wotaskdArray) {
        WOResponse[] responses = this.sendRequest((NSDictionary)WOTaskdHandler.createUpdateRequestDictionary(null, newHost, null, null, "add"), wotaskdArray, true);
        NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
        this.getUpdateErrors(responseDicts, "add", true, false, false, false);
    }

    protected void sendRemoveInstancesToWotaskds(NSArray exInstanceArray, NSArray wotaskdArray) {
        WOResponse[] responses = this.sendRequest((NSDictionary)WOTaskdHandler.createUpdateRequestDictionary(null, null, null, exInstanceArray, "remove"), wotaskdArray, true);
        NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
        this.getUpdateErrors(responseDicts, "remove", false, false, true, false);
    }

    public void sendRemoveApplicationToWotaskds(MApplication exApplication, NSArray wotaskdArray) {
        WOResponse[] responses = this.sendRequest((NSDictionary)WOTaskdHandler.createUpdateRequestDictionary(null, null, exApplication, null, "remove"), wotaskdArray, true);
        NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
        this.getUpdateErrors(responseDicts, "remove", false, true, false, false);
    }

    protected void sendRemoveHostToWotaskds(MHost exHost, NSArray wotaskdArray) {
        WOResponse[] responses = this.sendRequest((NSDictionary)WOTaskdHandler.createUpdateRequestDictionary(null, exHost, null, null, "remove"), wotaskdArray, true);
        NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
        this.getUpdateErrors(responseDicts, "remove", true, false, false, false);
    }

    public void sendUpdateInstancesToWotaskds(NSArray<MInstance> changedInstanceArray, NSArray wotaskdArray) {
        if (wotaskdArray.count() != 0 && changedInstanceArray.count() != 0) {
            WOResponse[] responses = this.sendRequest((NSDictionary)WOTaskdHandler.createUpdateRequestDictionary(null, null, null, changedInstanceArray, "configure"), wotaskdArray, true);
            NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
            this.getUpdateErrors(responseDicts, "configure", false, false, true, false);
        }
    }

    public void sendUpdateApplicationToWotaskds(MApplication changedApplication, NSArray wotaskdArray) {
        if (wotaskdArray.count() != 0) {
            WOResponse[] responses = this.sendRequest((NSDictionary)WOTaskdHandler.createUpdateRequestDictionary(null, null, changedApplication, null, "configure"), wotaskdArray, true);
            NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
            this.getUpdateErrors(responseDicts, "configure", false, true, false, false);
        }
    }

    public void sendUpdateApplicationAndInstancesToWotaskds(MApplication changedApplication, NSArray wotaskdArray) {
        WOResponse[] responses = this.sendRequest((NSDictionary)WOTaskdHandler.createUpdateRequestDictionary(null, null, changedApplication, changedApplication.instanceArray(), "configure"), wotaskdArray, true);
        NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
        this.getUpdateErrors(responseDicts, "configure", false, true, true, false);
    }

    protected void sendUpdateHostToWotaskds(MHost changedHost, NSArray wotaskdArray) {
        WOResponse[] responses = this.sendRequest((NSDictionary)WOTaskdHandler.createUpdateRequestDictionary(null, changedHost, null, null, "configure"), wotaskdArray, true);
        NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
        this.getUpdateErrors(responseDicts, "configure", true, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUpdateSiteToWotaskds() {
        this.startReading();
        try {
            NSMutableArray hostArray = WOTaskdHandler.siteConfig().hostArray();
            if (hostArray.count() != 0) {
                NSMutableDictionary updateRequestDictionary = WOTaskdHandler.createUpdateRequestDictionary(WOTaskdHandler.siteConfig(), null, null, null, "configure");
                WOResponse[] responses = this.sendRequest((NSDictionary)updateRequestDictionary, (NSArray)hostArray, true);
                NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
                this.getUpdateErrors(responseDicts, "configure", false, false, false, true);
            }
        }
        finally {
            this.endReading();
        }
    }

    public void sendOverwriteToWotaskd(MHost aHost) {
        NSDictionary SiteConfig = WOTaskdHandler.siteConfig().dictionaryForArchive();
        NSMutableDictionary data = new NSMutableDictionary((Object)SiteConfig, (Object)"SiteConfig");
        this._sendOverwriteClearToWotaskd(aHost, "overwrite", data);
    }

    protected void sendClearToWotaskd(MHost aHost) {
        String data = new String("SITE");
        this._sendOverwriteClearToWotaskd(aHost, "clear", data);
    }

    private void _sendOverwriteClearToWotaskd(MHost aHost, String type, Object data) {
        NSMutableDictionary updateWotaskd = new NSMutableDictionary(data, (Object)type);
        NSMutableDictionary monitorRequest = new NSMutableDictionary((Object)updateWotaskd, (Object)"updateWotaskd");
        WOResponse[] responses = this.sendRequest((NSDictionary)monitorRequest, new NSArray((Object)aHost), true);
        NSDictionary[] responseDicts = this.generateResponseDictionaries(responses);
        this.getUpdateErrors(responseDicts, type, false, false, false, false);
    }

    public static void sendCommandInstancesToWotaskds(String command, NSArray instanceArray, NSArray wotaskdArray, WOTaskdHandler collector) {
        if (instanceArray.count() > 0 && wotaskdArray.count() > 0) {
            int instanceCount = instanceArray.count();
            NSMutableDictionary monitorRequest = new NSMutableDictionary(1);
            NSMutableArray commandWotaskd = new NSMutableArray(instanceArray.count() + 1);
            commandWotaskd.addObject((Object)command);
            for (int i = 0; i < instanceCount; ++i) {
                MInstance anInst = (MInstance)instanceArray.objectAtIndex(i);
                commandWotaskd.addObject((Object)new NSDictionary(new Object[]{anInst.applicationName(), anInst.id(), anInst.hostName(), anInst.port()}, commandInstanceKeys));
            }
            monitorRequest.takeValueForKey((Object)commandWotaskd, "commandWotaskd");
            WOResponse[] responses = collector.sendRequest((NSDictionary)monitorRequest, wotaskdArray, false);
            Object[] responseDicts = collector.generateResponseDictionaries(responses);
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
                NSLog.debug.appendln((Object)("OUT: " + NSPropertyListSerialization.stringFromPropertyList((Object)monitorRequest) + "\n\nIN: " + NSPropertyListSerialization.stringFromPropertyList((Object)new NSArray(responseDicts))));
            }
            collector.getCommandErrors((NSDictionary[])responseDicts);
        }
    }

    protected void sendCommandInstancesToWotaskds(String command, NSArray<MInstance> instanceArray, NSArray<MHost> wotaskdArray) {
        WOTaskdHandler.sendCommandInstancesToWotaskds(command, instanceArray, wotaskdArray, this);
    }

    public void sendQuitInstancesToWotaskds(NSArray<MInstance> instanceArray, NSArray<MHost> wotaskdArray) {
        WOTaskdHandler.sendCommandInstancesToWotaskds("QUIT", instanceArray, wotaskdArray, this);
    }

    public void sendStartInstancesToWotaskds(NSArray<MInstance> instanceArray, NSArray<MHost> wotaskdArray) {
        WOTaskdHandler.sendCommandInstancesToWotaskds("START", instanceArray, wotaskdArray, this);
    }

    public void sendClearDeathsToWotaskds(NSArray<MInstance> instanceArray, NSArray<MHost> wotaskdArray) {
        WOTaskdHandler.sendCommandInstancesToWotaskds("CLEAR", instanceArray, wotaskdArray, this);
    }

    public void sendStopInstancesToWotaskds(NSArray<MInstance> instanceArray, NSArray<MHost> wotaskdArray) {
        WOTaskdHandler.sendCommandInstancesToWotaskds("STOP", instanceArray, wotaskdArray, this);
    }

    public void sendRefuseSessionToWotaskds(NSArray<MInstance> instanceArray, NSArray<MHost> wotaskdArray, boolean doRefuse) {
        for (MInstance instance : instanceArray) {
            instance.setRefusingNewSessions(doRefuse);
        }
        this.sendCommandInstancesToWotaskds(doRefuse ? "REFUSE" : "ACCEPT", instanceArray, wotaskdArray);
    }

    private NSMutableDictionary createQuery(String queryString) {
        NSMutableDictionary monitorRequest = new NSMutableDictionary((Object)queryString, (Object)"queryWotaskd");
        return monitorRequest;
    }

    protected WOResponse[] sendQueryToWotaskds(String queryString, NSArray wotaskdArray) {
        return this.sendRequest((NSDictionary)this.createQuery(queryString), wotaskdArray, false);
    }

    private NSDictionary[] generateResponseDictionaries(WOResponse[] responses) {
        NSDictionary[] responseDicts = new NSDictionary[responses.length];
        for (int i = 0; i < responses.length; ++i) {
            if (responses[i] != null && responses[i].content() != null) {
                try {
                    responseDicts[i] = (NSDictionary)new _JavaMonitorDecoder().decodeRootObject(responses[i].content());
                }
                catch (WOXMLException wxe) {
                    responseDicts[i] = responseParsingFailed;
                }
                continue;
            }
            responseDicts[i] = emptyResponse;
        }
        return responseDicts;
    }

    public NSMutableArray getUpdateErrors(NSDictionary[] responseDicts, String updateType, boolean hasHosts, boolean hasApplications, boolean hasInstances, boolean hasSite) {
        NSMutableArray errorArray = new NSMutableArray();
        boolean clearOverwrite = false;
        if (updateType.equals("overwrite") || updateType.equals("clear")) {
            clearOverwrite = true;
        }
        for (int i = 0; i < responseDicts.length; ++i) {
            NSDictionary aDict;
            String errorMessage;
            NSDictionary updateTypeResponse;
            if (responseDicts[i] == null) continue;
            NSDictionary responseDict = responseDicts[i];
            this.getGlobalErrorFromResponse(responseDict, errorArray);
            NSDictionary updateWotaskdResponseDict = (NSDictionary)responseDict.valueForKey("updateWotaskdResponse");
            if (updateWotaskdResponseDict == null || (updateTypeResponse = (NSDictionary)updateWotaskdResponseDict.valueForKey(updateType)) == null) continue;
            if (clearOverwrite) {
                String errorMessage2 = (String)updateTypeResponse.valueForKey("errorMessage");
                if (errorMessage2 == null) continue;
                errorArray.addObject((Object)errorMessage2);
                continue;
            }
            if (hasSite && (errorMessage = (String)(aDict = (NSDictionary)updateTypeResponse.valueForKey("site")).valueForKey("errorMessage")) != null) {
                errorArray.addObject((Object)errorMessage);
            }
            if (hasHosts) {
                this._addUpdateResponseToErrorArray(updateTypeResponse, "hostArray", errorArray);
            }
            if (hasApplications) {
                this._addUpdateResponseToErrorArray(updateTypeResponse, "applicationArray", errorArray);
            }
            if (!hasInstances) continue;
            this._addUpdateResponseToErrorArray(updateTypeResponse, "instanceArray", errorArray);
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)("##### getUpdateErrors: " + errorArray));
        }
        this.mySession().addObjectsFromArrayIfAbsentToErrorMessageArray((NSArray<String>)errorArray);
        return errorArray;
    }

    protected void _addUpdateResponseToErrorArray(NSDictionary updateTypeResponse, String responseKey, NSMutableArray errorArray) {
        NSArray aResponse = (NSArray)updateTypeResponse.valueForKey(responseKey);
        if (aResponse != null) {
            Enumeration e = aResponse.objectEnumerator();
            while (e.hasMoreElements()) {
                NSDictionary aDict = (NSDictionary)e.nextElement();
                String errorMessage = (String)aDict.valueForKey("errorMessage");
                if (errorMessage == null) continue;
                errorArray.addObject((Object)errorMessage);
            }
        }
    }

    public NSMutableArray getCommandErrors(NSDictionary[] responseDicts) {
        NSMutableArray errorArray = new NSMutableArray();
        block0: for (int i = 0; i < responseDicts.length; ++i) {
            if (responseDicts[i] == null) continue;
            NSDictionary responseDict = responseDicts[i];
            this.getGlobalErrorFromResponse(responseDict, errorArray);
            NSArray commandWotaskdResponse = (NSArray)responseDict.valueForKey("commandWotaskdResponse");
            if (commandWotaskdResponse == null || commandWotaskdResponse.count() <= 0) continue;
            int count = commandWotaskdResponse.count();
            for (int j = 1; j < count; ++j) {
                NSDictionary aDict = (NSDictionary)commandWotaskdResponse.objectAtIndex(j);
                String errorMessage = (String)aDict.valueForKey("errorMessage");
                if (errorMessage == null) continue;
                errorArray.addObject((Object)errorMessage);
                if (j == 0) continue block0;
            }
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)("##### getCommandErrors: " + errorArray));
        }
        this.mySession().addObjectsFromArrayIfAbsentToErrorMessageArray((NSArray<String>)errorArray);
        return errorArray;
    }

    protected NSMutableArray getQueryErrors(NSDictionary[] responseDicts) {
        NSMutableArray errorArray = new NSMutableArray();
        block0: for (int i = 0; i < responseDicts.length; ++i) {
            if (responseDicts[i] == null) continue;
            NSDictionary responseDict = responseDicts[i];
            this.getGlobalErrorFromResponse(responseDict, errorArray);
            NSArray commandWotaskdResponse = (NSArray)responseDict.valueForKey("commandWotaskdResponse");
            if (commandWotaskdResponse == null || commandWotaskdResponse.count() <= 0) continue;
            int count = commandWotaskdResponse.count();
            for (int j = 1; j < count; ++j) {
                NSDictionary aDict = (NSDictionary)commandWotaskdResponse.objectAtIndex(j);
                String errorMessage = (String)aDict.valueForKey("errorMessage");
                if (errorMessage == null) continue;
                errorArray.addObject((Object)errorMessage);
                if (j == 0) continue block0;
            }
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)("##### getQueryErrors: " + errorArray));
        }
        this.mySession().addObjectsFromArrayIfAbsentToErrorMessageArray((NSArray<String>)errorArray);
        return errorArray;
    }

    protected void getGlobalErrorFromResponse(NSDictionary responseDict, NSMutableArray errorArray) {
        NSArray errorResponse = (NSArray)responseDict.valueForKey("errorResponse");
        if (errorResponse != null) {
            errorArray.addObjectsFromArray(errorResponse);
        }
    }

    public void getInstanceStatusForHosts(NSArray<MHost> hostArray) {
        if (hostArray.count() != 0) {
            WOResponse[] responses = this.sendQueryToWotaskds("INSTANCE", hostArray);
            NSMutableArray errorArray = new NSMutableArray();
            NSArray responseArray = null;
            NSDictionary responseDictionary = null;
            NSDictionary queryResponseDictionary = null;
            for (int i = 0; i < responses.length; ++i) {
                if (responses[i] == null || responses[i].content() == null) {
                    responseDictionary = emptyResponse;
                } else {
                    try {
                        responseDictionary = (NSDictionary)new _JavaMonitorDecoder().decodeRootObject(responses[i].content());
                    }
                    catch (WOXMLException wxe) {
                        NSLog.err.appendln((Object)("MonitorComponent pageWithName(AppDetailPage) Error decoding response: " + responses[i].contentString()));
                        responseDictionary = responseParsingFailed;
                    }
                }
                this.getGlobalErrorFromResponse(responseDictionary, errorArray);
                queryResponseDictionary = (NSDictionary)responseDictionary.valueForKey("queryWotaskdResponse");
                if (queryResponseDictionary == null || (responseArray = (NSArray)queryResponseDictionary.valueForKey("instanceResponse")) == null) continue;
                for (int j = 0; j < responseArray.count(); ++j) {
                    responseDictionary = (NSDictionary)responseArray.objectAtIndex(j);
                    String host = (String)responseDictionary.valueForKey("host");
                    Integer port = (Integer)responseDictionary.valueForKey("port");
                    String runningState = (String)responseDictionary.valueForKey("runningState");
                    Boolean refusingNewSessions = (Boolean)responseDictionary.valueForKey("refusingNewSessions");
                    NSDictionary statistics = (NSDictionary)responseDictionary.valueForKey("statistics");
                    NSArray deaths = (NSArray)responseDictionary.valueForKey("deaths");
                    String nextShutdown = (String)responseDictionary.valueForKey("nextShutdown");
                    MInstance anInstance = WOTaskdHandler.siteConfig().instanceWithHostnameAndPort(host, port);
                    if (anInstance == null) continue;
                    for (int k = 0; k < MObject.stateArray.length; ++k) {
                        if (!MObject.stateArray[k].equals(runningState)) continue;
                        anInstance.state = k;
                        break;
                    }
                    anInstance.setRefusingNewSessions(String_Extensions.boolValue((Object)refusingNewSessions));
                    anInstance.setStatistics(statistics);
                    anInstance.setDeaths(new NSMutableArray(deaths));
                    anInstance.setNextScheduledShutdownString_M(nextShutdown);
                }
            }
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
                NSLog.debug.appendln((Object)("##### pageWithName(AppDetailPage) errors: " + errorArray));
            }
            this.mySession().addObjectsFromArrayIfAbsentToErrorMessageArray((NSArray<String>)errorArray);
        }
    }

    public void getHostStatusForHosts(NSArray<MHost> hostArray) {
        WOResponse[] responses = this.sendQueryToWotaskds("HOST", hostArray);
        NSMutableArray errorArray = new NSMutableArray();
        NSDictionary responseDict = null;
        for (int i = 0; i < responses.length; ++i) {
            MHost aHost = (MHost)WOTaskdHandler.siteConfig().hostArray().objectAtIndex(i);
            if (responses[i] == null || responses[i].content() == null) {
                responseDict = emptyResponse;
            } else {
                try {
                    responseDict = (NSDictionary)new _JavaMonitorDecoder().decodeRootObject(responses[i].content());
                }
                catch (WOXMLException wxe) {
                    NSLog.err.appendln((Object)("MonitorComponent pageWithName(HostsPage) Error decoding response: " + responses[i].contentString()));
                    responseDict = responseParsingFailed;
                }
            }
            this.getGlobalErrorFromResponse(responseDict, errorArray);
            NSDictionary queryResponse = (NSDictionary)responseDict.valueForKey("queryWotaskdResponse");
            if (queryResponse != null) {
                NSDictionary hostResponse = (NSDictionary)queryResponse.valueForKey("hostResponse");
                aHost._setHostInfo(hostResponse);
                aHost.isAvailable = true;
                continue;
            }
            aHost.isAvailable = false;
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)("##### pageWithName(HostsPage) errors: " + errorArray));
        }
        this.mySession().addObjectsFromArrayIfAbsentToErrorMessageArray((NSArray<String>)errorArray);
    }

    public void getApplicationStatusForHosts(NSArray<MHost> hostArray) {
        WOResponse[] responses = this.sendQueryToWotaskds("APPLICATION", hostArray);
        NSMutableArray errorArray = new NSMutableArray();
        NSArray responseArray = null;
        NSDictionary responseDictionary = null;
        for (int i = 0; i < responses.length; ++i) {
            NSDictionary queryResponseDictionary;
            if (responses[i] == null || responses[i].content() == null) {
                queryResponseDictionary = emptyResponse;
            } else {
                try {
                    queryResponseDictionary = (NSDictionary)new _JavaMonitorDecoder().decodeRootObject(responses[i].content());
                }
                catch (WOXMLException wxe) {
                    NSLog.err.appendln((Object)("MonitorComponent pageWithName(ApplicationsPage) Error decoding response: " + responses[i].contentString()));
                    queryResponseDictionary = responseParsingFailed;
                }
            }
            this.getGlobalErrorFromResponse(queryResponseDictionary, errorArray);
            NSDictionary applicationResponseDictionary = (NSDictionary)queryResponseDictionary.valueForKey("queryWotaskdResponse");
            if (applicationResponseDictionary == null || (responseArray = (NSArray)applicationResponseDictionary.valueForKey("applicationResponse")) == null) continue;
            for (int j = 0; j < responseArray.count(); ++j) {
                responseDictionary = (NSDictionary)responseArray.objectAtIndex(j);
                String appName = (String)responseDictionary.valueForKey("name");
                Integer runningInstances = (Integer)responseDictionary.valueForKey("runningInstances");
                MApplication anApplication = WOTaskdHandler.siteConfig().applicationWithName(appName);
                if (anApplication == null) continue;
                anApplication.setRunningInstancesCount(anApplication.runningInstancesCount() + runningInstances);
            }
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)("##### pageWithName(ApplicationsPage) errors: " + errorArray));
        }
        this.mySession().addObjectsFromArrayIfAbsentToErrorMessageArray((NSArray<String>)errorArray);
    }

    static {
        commandInstanceKeys = new Object[]{"applicationName", "id", "hostName", "port"};
        responseParsingFailed = new NSDictionary((Object)new NSDictionary((Object)new NSArray((Object)"INTERNAL ERROR: Failed to parse response XML"), (Object)"errorResponse"), (Object)"monitorResponse");
        emptyResponse = new NSDictionary((Object)new NSDictionary((Object)new NSArray((Object)"INTERNAL ERROR: Response returned was null or empty"), (Object)"errorResponse"), (Object)"monitorResponse");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ErrorCollector {
        public void addObjectsFromArrayIfAbsentToErrorMessageArray(NSArray<String> var1);
    }
}

