/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.application.starter;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor.application.WOTaskdHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationStarter
extends Thread
implements WOTaskdHandler.ErrorCollector {
    private MApplication _app;
    private WOTaskdHandler _handler;
    private NSMutableSet<String> _errors;
    private String _status;

    public ApplicationStarter(MApplication app) {
        this._app = app;
        this._handler = new WOTaskdHandler(this);
        this.setName("Bouncer: " + app.name());
    }

    protected abstract void bounce() throws InterruptedException;

    protected void log(Object msg) {
        NSLog.out.appendln(msg);
        this._status = msg != null ? msg.toString() : "No status";
    }

    public WOTaskdHandler handler() {
        return this._handler;
    }

    public MApplication application() {
        return this._app;
    }

    @Override
    public void run() {
        try {
            this._errors = new NSMutableSet();
            this.bounce();
        }
        catch (InterruptedException e) {
            this.log(e);
        }
    }

    @Override
    public void addObjectsFromArrayIfAbsentToErrorMessageArray(NSArray<String> aErrors) {
        this._errors.addObjectsFromArray(aErrors);
    }

    public NSArray<String> errors() {
        return this._errors.allObjects();
    }

    @Override
    public String toString() {
        return "Bouncer: " + this._app.name() + "->" + this._status;
    }

    public String status() {
        return this._status;
    }
}

