/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.rest;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor.rest.JavaMonitorController;
import er.extensions.eof.ERXKeyFilter;

public class MApplicationController
extends JavaMonitorController {
    public MApplicationController(WORequest request) {
        super(request);
    }

    public WOActionResults createAction() throws Throwable {
        this.checkPassword();
        ERXKeyFilter filter = ERXKeyFilter.filterWithAttributes();
        MApplication application = (MApplication)this.create(filter);
        this.siteConfig().addApplication_M(application);
        if (this.siteConfig().hostArray().count() != 0) {
            this.handler().sendAddApplicationToWotaskds(application, (NSArray)this.siteConfig().hostArray());
        }
        this.pushValues(application);
        return this.response(application, filter);
    }

    public WOActionResults destroyAction() throws Throwable {
        this.checkPassword();
        MApplication application = (MApplication)this.routeObjectForKey("mApplication");
        this.deleteApplication(application);
        return this.response(application, ERXKeyFilter.filterWithNone());
    }

    public WOActionResults indexAction() throws Throwable {
        this.checkPassword();
        return this.response(this.siteConfig().applicationArray(), ERXKeyFilter.filterWithAttributes());
    }

    public WOActionResults showAction() throws Throwable {
        this.checkPassword();
        MApplication application = (MApplication)this.routeObjectForKey("mApplication");
        return this.response(application, ERXKeyFilter.filterWithAttributes());
    }

    public WOActionResults updateAction() throws Throwable {
        this.checkPassword();
        MApplication application = (MApplication)this.routeObjectForKey("mApplication");
        this.update(application, ERXKeyFilter.filterWithAttributes());
        this.pushValues(application);
        return this.response(application, ERXKeyFilter.filterWithAttributes());
    }

    public WOActionResults addInstanceAction() throws Throwable {
        this.checkPassword();
        MApplication application = (MApplication)this.routeObjectForKey("name");
        this.addInstance(application, (MHost)this.routeObjectForKey("host"), false);
        return this.response(application, ERXKeyFilter.filterWithNone());
    }

    public WOActionResults deleteInstanceAction() throws Throwable {
        this.checkPassword();
        MApplication application = (MApplication)this.routeObjectForKey("name");
        this.deleteInstance(application, (Integer)this.routeObjectForKey("id"));
        return this.response(application, ERXKeyFilter.filterWithNone());
    }

    public WOActionResults addInstanceOnAllHostsAction() throws Throwable {
        this.checkPassword();
        MApplication application = (MApplication)this.routeObjectForKey("name");
        this.addInstance(application, null, true);
        return this.response(application, ERXKeyFilter.filterWithNone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushValues(MApplication application) {
        this.handler().startReading();
        try {
            application.pushValuesToInstances();
            if (this.siteConfig().hostArray().count() != 0) {
                this.handler().sendUpdateApplicationAndInstancesToWotaskds(application, (NSArray)this.siteConfig().hostArray());
            }
        }
        finally {
            this.handler().endReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstance(MApplication application, MHost host, boolean addToAllHosts) {
        NSMutableArray newInstanceArray = new NSMutableArray();
        this.handler().startWriting();
        try {
            if (addToAllHosts) {
                for (MHost aHost : this.siteConfig().hostArray()) {
                    newInstanceArray = this.siteConfig().addInstances_M(aHost, application, 1);
                    this.handler().sendAddInstancesToWotaskds((NSArray)newInstanceArray, (NSArray)this.siteConfig().hostArray());
                }
            } else {
                newInstanceArray = this.siteConfig().addInstances_M(host, application, 1);
                this.handler().sendAddInstancesToWotaskds((NSArray)newInstanceArray, (NSArray)this.siteConfig().hostArray());
            }
        }
        finally {
            this.handler().endWriting();
        }
    }

    private void deleteInstance(MApplication application, Integer instanceId) {
        MInstance instance = application.instanceWithID(instanceId);
        this.siteConfig().removeInstance_M(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteApplication(MApplication application) {
        this.handler().startWriting();
        try {
            this.siteConfig().removeApplication_M(application);
            if (this.siteConfig().hostArray().count() != 0) {
                this.handler().sendRemoveApplicationToWotaskds(application, (NSArray)this.siteConfig().hostArray());
            }
        }
        finally {
            this.handler().endWriting();
        }
    }
}

