/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.rest;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.monitor._private.MSiteConfig;
import com.webobjects.monitor.rest.JavaMonitorController;
import er.extensions.eof.ERXKeyFilter;
import er.extensions.foundation.ERXStringUtilities;

public class MSiteConfigController
extends JavaMonitorController {
    public MSiteConfigController(WORequest request) {
        super(request);
    }

    public WOActionResults updateAction() throws Throwable {
        this.checkPassword();
        if (this.siteConfig().hostArray().count() == 0) {
            throw new IllegalStateException("You cannot update the SiteConfig before adding a host.");
        }
        MSiteConfig siteConfig = (MSiteConfig)this.object(ERXKeyFilter.filterWithAttributes());
        this.update(siteConfig, ERXKeyFilter.filterWithAttributes());
        this.pushValues(siteConfig);
        return this.response(siteConfig, ERXKeyFilter.filterWithAttributes());
    }

    private void pushValues(MSiteConfig newSiteConfig) {
        String newHashedPassword = newSiteConfig.password();
        String currentHashedPassword = this.siteConfig().password();
        if (!ERXStringUtilities.stringIsNullOrEmpty((String)newHashedPassword)) {
            this.siteConfig()._setOldPassword();
        }
        newSiteConfig.values().removeObjectForKey((Object)"password");
        NSMutableDictionary newValues = this.siteConfig().values();
        newValues.removeObjectForKey((Object)"password");
        newValues.addEntriesFromDictionary((NSDictionary)newSiteConfig.values());
        this.siteConfig().updateValues((NSDictionary)newValues);
        if (!ERXStringUtilities.stringIsNullOrEmpty((String)newHashedPassword)) {
            this.siteConfig().values().takeValueForKey((Object)newHashedPassword, "password");
        } else if (!ERXStringUtilities.stringIsNullOrEmpty((String)currentHashedPassword)) {
            this.siteConfig().values().takeValueForKey((Object)currentHashedPassword, "password");
        }
        this.handler().sendUpdateSiteToWotaskds();
        if (!ERXStringUtilities.stringIsNullOrEmpty((String)newHashedPassword)) {
            this.siteConfig()._resetOldPassword();
        }
    }
}

