/*
 * Decompiled with CFR 0.152.
 */
import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSValidation;
import er.ajax.AjaxModalDialog;
import er.ajax.example.Company;
import er.ajax.example.Employee;
import er.extensions.eof.ERXQ;

public class ModalDialogExample
extends WOComponent {
    private boolean isSecondConfirmation;
    private Employee employee;
    protected String errorMessages;
    public final NSArray<String> companyNames = new NSArray((Object[])new String[]{"Acme Ajax, Inc.", "Betty's Baubles, LLC", "Gimcrack, Intl.", "Sally's Seashore Seashells", "The Fu Bar"});
    public NSMutableArray<Company> companies = new NSMutableArray();

    public ModalDialogExample(WOContext context) {
        super(context);
        EOEditingContext ec = this.session().defaultEditingContext();
        for (int i = 0; i < this.companyNames.count(); ++i) {
            String name = (String)this.companyNames.objectAtIndex(i);
            Company company = Company.fetchCompany(ec, Company.NAME_KEY, name);
            if (company == null) {
                company = Company.createCompany(ec, name);
            }
            this.companies.addObject((Object)company);
        }
        ec.saveChanges();
        this.employee = Employee.fetchEmployee(ec, (EOQualifier)ERXQ.and((EOQualifier[])new EOQualifier[]{ERXQ.equals((String)Employee.FIRST_NAME_KEY, (Object)"Bill"), ERXQ.equals((String)Employee.LAST_NAME_KEY, (Object)"Wratchit")}));
        if (this.employee == null) {
            Company company = Company.fetchCompany(ec, Company.NAME_KEY, this.companyNames.objectAtIndex(2));
            this.employee = Employee.createEmployee(ec, "Bill", "Wratchit", company);
        }
        ec.saveChanges();
    }

    public WOActionResults deleteIt() {
        NSLog.out.appendln((Object)"deleteIt called");
        return null;
    }

    public WOActionResults deleteIt2() {
        NSLog.out.appendln((Object)"deleteIt2 called");
        boolean bl = this.isSecondConfirmation = !this.isSecondConfirmation;
        if (this.isSecondConfirmation) {
            AjaxModalDialog.update((WOContext)this.context(), (String)"Think again...");
        } else {
            AjaxModalDialog.close((WOContext)this.context());
        }
        return null;
    }

    public String confirmationMessage() {
        NSLog.out.appendln((Object)"confirmationMessage called");
        return this.isSecondConfirmation ? "Are you really, really, really sure you want to delete this?" : "Are you sure you want to delete this?";
    }

    public WOActionResults editEmployee() {
        NSLog.out.appendln((Object)"editEmployee called");
        ModalDialogEmployeeEditor result = (ModalDialogEmployeeEditor)this.pageWithName(ModalDialogEmployeeEditor.class.getCanonicalName());
        result.setEmployee(this.employee());
        return result;
    }

    public WOActionResults cancelEdit() {
        NSLog.out.appendln((Object)"ModalDialogExample cancelEdit");
        this.errorMessages = null;
        this.employee().editingContext().revert();
        AjaxModalDialog.close((WOContext)this.context());
        return null;
    }

    public WOActionResults saveEdit() {
        NSLog.out.appendln((Object)"ModalDialogExample saveEdit");
        try {
            this.errorMessages = null;
            this.employee().editingContext().saveChanges();
            AjaxModalDialog.close((WOContext)this.context());
        }
        catch (NSValidation.ValidationException e) {
            this.errorMessages = e.getLocalizedMessage();
            if (e.additionalExceptions().count() > 0) {
                this.errorMessages = this.errorMessages + "<br/>" + ((NSArray)e.additionalExceptions().valueForKey("localizedMessage")).componentsJoinedByString("<br/>");
            }
            AjaxModalDialog.update((WOContext)this.context());
        }
        return null;
    }

    public Employee employee() {
        return this.employee;
    }

    public void setEmployee(Employee person) {
        this.employee = person;
    }

    public String firstName() {
        return this.employee().firstName();
    }

    public void setFirstName(String name) {
        NSLog.out.appendln((Object)("ModalDialogExample setFirstName to " + name));
        this.employee().setFirstName(name);
    }

    public String lastName() {
        return this.employee().lastName();
    }

    public void setLastName(String name) {
        NSLog.out.appendln((Object)("ModalDialogExample setLastName to " + name));
        this.employee().setLastName(name);
    }

    public String errorMessages() {
        return this.errorMessages;
    }
}

