/*
 * Decompiled with CFR 0.152.
 */
import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import er.ajax.AjaxPushRequestHandler;
import er.ajax.AjaxUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PushExample
extends WOComponent {
    private static Set<String> _pushSessionIDs = Collections.synchronizedSet(new HashSet());
    private static Thread _pushThread = new Thread(new Runnable(){

        public void run() {
            boolean running = true;
            while (running) {
                HashSet pushSessionIDs = new HashSet(_pushSessionIDs);
                for (String pushSessionID : pushSessionIDs) {
                    if (AjaxPushRequestHandler.isResponseOpen((String)pushSessionID, (String)"test")) {
                        String str = "<br>push to '" + pushSessionID + "': " + System.currentTimeMillis();
                        System.out.println("ERXKeepAliveResponse.push: sending '" + str + "'");
                        AjaxPushRequestHandler.push((String)pushSessionID, (String)"test", (String)str);
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            running = false;
                        }
                        continue;
                    }
                    System.out.println("PushExample._pushThread.new Runnable() {...}.run: removing " + pushSessionID);
                    _pushSessionIDs.remove(pushSessionID);
                }
            }
        }
    });

    public PushExample(WOContext context) {
        super(context);
        if (!_pushThread.isAlive()) {
            _pushThread.start();
        }
    }

    public String url() {
        return this.context().urlWithRequestHandlerKey("push", "test", "wosid=" + this.session().sessionID());
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        super.appendToResponse(response, context);
        AjaxUtils.addScriptResourceInHead((WOContext)context, (WOResponse)response, (String)"prototype.js");
        AjaxUtils.addScriptResourceInHead((WOContext)context, (WOResponse)response, (String)"wonder.js");
    }

    public WOActionResults push() {
        if (_pushSessionIDs.contains(this.session().sessionID())) {
            System.out.println("PushExample.push:  stopping " + this.session().sessionID());
            _pushSessionIDs.remove(this.session().sessionID());
        } else {
            System.out.println("PushExample.push: starting " + this.session().sessionID());
            _pushSessionIDs.add(this.session().sessionID());
        }
        WOResponse response = new WOResponse();
        response.setContent("Sent some data");
        return response;
    }
}

