/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.dict;

import com.metaparadigm.dict.Database;
import com.metaparadigm.dict.Definition;
import com.metaparadigm.dict.DictClientException;
import com.metaparadigm.dict.DictCommandResult;
import com.metaparadigm.dict.Match;
import com.metaparadigm.dict.Strategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;

public class DictClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean debug = false;
    private static String DEFAULT_HOST = "localhost";
    private static int DEFAULT_PORT = 2628;
    private String host;
    private int port;
    private transient ArrayList<Strategy> strategies;
    private transient ArrayList<Database> databases;
    private transient String ident;
    private transient Socket sock;
    private transient PrintWriter out;
    private transient BufferedReader in;

    public DictClient() {
        this.host = DEFAULT_HOST;
        this.port = DEFAULT_PORT;
    }

    public DictClient(String host) {
        this.host = host;
        this.port = DEFAULT_PORT;
    }

    public DictClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setHost(String host) {
        if (this.sock != null && !this.host.equals(host)) {
            this.close();
        }
        this.host = host;
    }

    public void setPort(int port) {
        if (this.sock != null && this.port != port) {
            this.close();
        }
        this.port = port;
    }

    private synchronized void connect() throws IOException, DictClientException {
        System.out.println("DictClient.connect: opening connection to " + this.host + ":" + this.port);
        this.sock = new Socket(this.host, this.port);
        this.in = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), "UTF-8"));
        this.out = new PrintWriter(new OutputStreamWriter(this.sock.getOutputStream(), "UTF-8"));
        DictCommandResult r = new DictCommandResult(this.in.readLine());
        if (r.code != DictCommandResult.BANNER) {
            this.close();
            throw new DictClientException(r);
        }
        this.ident = r.msg;
        System.out.println("DictClient.connect: connected to " + this.host + ":" + this.port + " ident=\"" + this.ident + "\"");
    }

    public void finalize() {
        this.close();
    }

    private synchronized String status() throws IOException, DictClientException {
        this.out.print("STATUS\n");
        this.out.flush();
        DictCommandResult r = new DictCommandResult(this.in.readLine());
        if (r.code != DictCommandResult.STATUS) {
            throw new DictClientException(r);
        }
        return r.msg;
    }

    public synchronized String checkConnection() throws IOException, DictClientException {
        if (this.sock == null) {
            this.connect();
            return this.status();
        }
        try {
            return this.status();
        }
        catch (Exception e) {
            System.out.println("DictClient.status: Exception " + e);
            this.close();
            this.connect();
            return this.status();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.sock == null) {
            return;
        }
        try {
            this.out.print("QUIT\n");
            this.out.flush();
            String line = this.in.readLine();
            if (line != null) {
                DictCommandResult r = new DictCommandResult(line);
                if (r.code != DictCommandResult.CLOSING_CONNECTION) {
                    System.out.println("DictClient.close: Exception: " + r);
                }
            }
        }
        catch (IOException e) {
            System.out.println("DictClient.close: IOException while closing: " + e);
        }
        finally {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {}
            this.sock = null;
            this.in = null;
            this.out = null;
            System.out.println("DictClient.close: connection closed");
        }
    }

    public synchronized ArrayList getDatabases() throws IOException, DictClientException {
        if (this.databases == null) {
            this.fetchDatabases();
        }
        return this.databases;
    }

    private synchronized void fetchDatabases() throws IOException, DictClientException {
        String line;
        this.checkConnection();
        this.out.print("SHOW DATABASES\n");
        this.out.flush();
        DictCommandResult r = new DictCommandResult(this.in.readLine());
        if (r.code != DictCommandResult.DATABASES_PRESENT) {
            throw new DictClientException(r);
        }
        this.databases = new ArrayList();
        while (!(line = this.in.readLine()).equals(".")) {
            String database = line.substring(0, line.indexOf(32));
            String description = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
            this.databases.add(new Database(database, description));
        }
        r = new DictCommandResult(this.in.readLine());
        if (r.code != DictCommandResult.OKAY) {
            throw new DictClientException(r);
        }
    }

    public synchronized ArrayList getStrategies() throws IOException, DictClientException {
        if (this.strategies == null) {
            this.fetchStrategies();
        }
        return this.strategies;
    }

    private synchronized void fetchStrategies() throws IOException, DictClientException {
        String line;
        this.checkConnection();
        this.out.print("SHOW STRATEGIES\n");
        this.out.flush();
        DictCommandResult r = new DictCommandResult(this.in.readLine());
        if (r.code != DictCommandResult.STRATEGIES_PRESENT) {
            throw new DictClientException(r);
        }
        this.strategies = new ArrayList();
        while (!(line = this.in.readLine()).equals(".")) {
            String strategy = line.substring(0, line.indexOf(32));
            String description = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
            this.strategies.add(new Strategy(strategy, description));
        }
        r = new DictCommandResult(this.in.readLine());
        if (r.code != DictCommandResult.OKAY) {
            throw new DictClientException(r);
        }
    }

    public synchronized ArrayList matchWord(String db, String strategy, String word) throws IOException, DictClientException {
        String line;
        this.checkConnection();
        ArrayList<Match> matches = new ArrayList<Match>();
        this.out.print("MATCH " + db + " " + strategy + " \"" + word + "\"\n");
        this.out.flush();
        DictCommandResult r = new DictCommandResult(this.in.readLine());
        if (r.code == DictCommandResult.NO_MATCH) {
            return matches;
        }
        if (r.code != DictCommandResult.MATCH_NUM_RECIEVED) {
            throw new DictClientException(r);
        }
        while (!(line = this.in.readLine()).equals(".")) {
            String rDb = line.substring(0, line.indexOf(32));
            String rWord = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
            matches.add(new Match(rDb, rWord));
        }
        r = new DictCommandResult(this.in.readLine());
        if (r.code != DictCommandResult.OKAY) {
            throw new DictClientException(r);
        }
        return matches;
    }

    public synchronized ArrayList defineWord(String db, String word) throws IOException, DictClientException {
        this.checkConnection();
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        this.out.print("DEFINE " + db + " \"" + word + "\"\n");
        this.out.flush();
        DictCommandResult r = new DictCommandResult(this.in.readLine());
        if (r.code == DictCommandResult.NO_MATCH) {
            return definitions;
        }
        if (r.code != DictCommandResult.DEFINE_NUM_RECIEVED) {
            throw new DictClientException(r);
        }
        while (true) {
            r = new DictCommandResult(this.in.readLine());
            if (r.code == DictCommandResult.OKAY) {
                return definitions;
            }
            String line = r.msg;
            int n = line.indexOf(34) + 1;
            int qoff = n;
            qoff = line.indexOf(34, qoff + 1);
            String rWord = line.substring(n, qoff);
            String rDb = line.substring(qoff + 2, line.indexOf(32, qoff + 2));
            StringBuffer def = new StringBuffer();
            while (!(line = this.in.readLine()).equals(".")) {
                def.append(line);
                def.append("\n");
            }
            definitions.add(new Definition(rDb, rWord, def.toString()));
        }
    }
}

