/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.dict;

public class DictCommandResult {
    protected int code;
    protected String msg;
    public static int INTERNAL_SOCKET_EOF = 900;
    public static int INTERNAL_STATUS_PARSE_ERROR = 901;
    public static int DATABASES_PRESENT = 110;
    public static int STRATEGIES_PRESENT = 111;
    public static int DEFINE_NUM_RECIEVED = 150;
    public static int DEFINE_RESULT = 151;
    public static int MATCH_NUM_RECIEVED = 152;
    public static int STATUS = 210;
    public static int BANNER = 220;
    public static int OKAY = 250;
    public static int CLOSING_CONNECTION = 221;
    public static int TEMP_UNAVAILABLE = 420;
    public static int INVALID_DATABASE = 550;
    public static int INVALID_STRATEGY = 551;
    public static int NO_MATCH = 552;

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.msg;
    }

    protected DictCommandResult(String s) {
        if (s == null) {
            this.code = INTERNAL_SOCKET_EOF;
            this.msg = "Connection closed";
            return;
        }
        try {
            this.code = Integer.parseInt(s.substring(0, 3));
            this.msg = s.substring(4, s.length());
        }
        catch (Exception e) {
            this.code = INTERNAL_STATUS_PARSE_ERROR;
            this.msg = "Can't parse status line";
        }
    }

    public String toString() {
        return "code=" + this.code + " msg=\"" + this.msg + "\"";
    }
}

