/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.ujac.chart.Chart;
import org.ujac.chart.ChartAttributeDefinition;
import org.ujac.chart.ChartAttributes;
import org.ujac.chart.ChartException;
import org.ujac.chart.ChartModel;
import org.ujac.chart.TextChartItem;
import org.ujac.util.CollectionUtils;

public abstract class BaseChart
implements Chart {
    public static final float DEFAULT_BORDER_WIDTH = 0.0f;
    public static final float DEFAULT_PADDING = 2.0f;
    public static final Font DEFAULT_TITLE_FONT = new Font("Helvetica", 1, 20);
    public static final float DEFAULT_DESCRIPTION_LINE_WIDTH = 1.0f;
    public static final Color DEFAULT_DESCRIPTION_COLOR = Color.black;
    public static final String DEFAULT_DESCRIPTION_PATTERN = "%v";
    public static final Color DEFAULT_SHADOW_COLOR = Color.darkGray;
    public static final float DEFAULT_SHADOW_OFFSET = 4.0f;
    public static final Font DEFAULT_DESCRIPTION_FONT = new Font("Helvetica", 0, 14);
    public transient NumberFormat defaultValueFormat = NumberFormat.getNumberInstance();
    public transient NumberFormat defaultPercentFormat = NumberFormat.getNumberInstance();
    protected ChartModel model;
    protected ChartAttributes attributes = null;

    public List getSupportedAttributes() {
        ArrayList attributes = new ArrayList();
        this.fillSupportedAttributes(attributes);
        return attributes;
    }

    protected void addAttributeDefinition(List attributeDefinitions, String name, int type, boolean list, boolean optional) {
        attributeDefinitions.add(new ChartAttributeDefinition(name, type, list, optional));
    }

    protected void fillSupportedAttributes(List attrDefs) {
        this.addAttributeDefinition(attrDefs, "background-color", 22, false, true);
        this.addAttributeDefinition(attrDefs, "border-width", 5, false, true);
        this.addAttributeDefinition(attrDefs, "title-font", 20, false, true);
        this.addAttributeDefinition(attrDefs, "segment-labels", 1, true, true);
        this.addAttributeDefinition(attrDefs, "area-labels", 1, true, true);
        this.addAttributeDefinition(attrDefs, "description-font", 20, false, true);
        this.addAttributeDefinition(attrDefs, "description-pattern", 1, false, true);
        this.addAttributeDefinition(attrDefs, "description-pattern", 1, false, true);
        this.addAttributeDefinition(attrDefs, "description-line-width", 5, false, true);
        this.addAttributeDefinition(attrDefs, "description-color", 22, false, true);
        this.addAttributeDefinition(attrDefs, "value-format", 21, false, true);
        this.addAttributeDefinition(attrDefs, "percent-format", 21, false, true);
        this.addAttributeDefinition(attrDefs, "segment-colors", 22, true, true);
        this.addAttributeDefinition(attrDefs, "pie-height", 5, false, true);
        this.addAttributeDefinition(attrDefs, "line-width", 5, false, true);
        this.addAttributeDefinition(attrDefs, "scale-mark-length", 5, false, true);
        this.addAttributeDefinition(attrDefs, "shadow-color", 22, false, true);
        this.addAttributeDefinition(attrDefs, "shadow-offset", 5, false, true);
        this.addAttributeDefinition(attrDefs, "view-legend", 7, false, true);
        this.addAttributeDefinition(attrDefs, "view-grid", 7, false, true);
        this.addAttributeDefinition(attrDefs, "grid-color", 22, false, true);
        this.addAttributeDefinition(attrDefs, "grid-bgcolor", 22, false, true);
        this.addAttributeDefinition(attrDefs, "fill-area", 7, false, true);
        this.addAttributeDefinition(attrDefs, "view-scale-arrows", 7, false, true);
        this.addAttributeDefinition(attrDefs, "scale-arrowhead-length", 5, false, true);
        this.addAttributeDefinition(attrDefs, "scale-arrowhead-width", 5, false, true);
        this.addAttributeDefinition(attrDefs, "scale-arrowhead-style", 1, false, true);
        this.addAttributeDefinition(attrDefs, "scale-value-format", 21, false, true);
        this.addAttributeDefinition(attrDefs, "value-step-size", 6, false, true);
        this.addAttributeDefinition(attrDefs, "value-scale-description", 23, false, true);
        this.addAttributeDefinition(attrDefs, "segment-scale-description", 23, false, true);
    }

    public ChartAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ChartAttributes attributes) {
        this.attributes = attributes;
    }

    public Color getBackgroundColor() {
        if (this.attributes.isDefined("background-color")) {
            return this.attributes.getColor("background-color");
        }
        return null;
    }

    public float getBorderWidth() {
        if (this.attributes.isDefined("border-width")) {
            return this.attributes.getFloat("border-width");
        }
        return 0.0f;
    }

    public float getDescriptionLineWidth() {
        if (this.attributes.isDefined("description-line-width")) {
            return this.attributes.getFloat("description-line-width");
        }
        return 1.0f;
    }

    public Color getDescriptionColor() {
        if (this.attributes.isDefined("description-color")) {
            return this.attributes.getColor("description-color");
        }
        return DEFAULT_DESCRIPTION_COLOR;
    }

    public String getDescriptionPattern() {
        String descriptionPattern = this.attributes.getString("description-pattern");
        if (descriptionPattern != null) {
            return descriptionPattern;
        }
        return DEFAULT_DESCRIPTION_PATTERN;
    }

    public Color getShadowColor() {
        Color color = DEFAULT_SHADOW_COLOR;
        if (this.attributes.isDefined("shadow-color")) {
            color = this.attributes.getColor("shadow-color");
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return new Color(r, g, b, 192);
    }

    public float getShadowLength() {
        if (this.attributes.isDefined("shadow-offset")) {
            return this.attributes.getFloat("shadow-offset");
        }
        return 4.0f;
    }

    public NumberFormat getValueFormat() {
        if (this.attributes.isDefined("value-format")) {
            return (NumberFormat)this.attributes.getObject("value-format");
        }
        return this.defaultValueFormat;
    }

    public NumberFormat getPercentFormat() {
        if (this.attributes.isDefined("percent-format")) {
            return (NumberFormat)this.attributes.getObject("percent-format");
        }
        return this.defaultPercentFormat;
    }

    public float getLeftPadding() {
        if (this.attributes.isDefined("padding-left")) {
            return this.attributes.getFloat("padding-left");
        }
        if (this.attributes.isDefined("padding")) {
            return this.attributes.getFloat("padding");
        }
        return 2.0f;
    }

    public float getRightPadding() {
        if (this.attributes.isDefined("padding-right")) {
            return this.attributes.getFloat("padding-right");
        }
        if (this.attributes.isDefined("padding")) {
            return this.attributes.getFloat("padding");
        }
        return 2.0f;
    }

    public float getTopPadding() {
        if (this.attributes.isDefined("padding-top")) {
            return this.attributes.getFloat("padding-top");
        }
        if (this.attributes.isDefined("padding")) {
            return this.attributes.getFloat("padding");
        }
        return 2.0f;
    }

    public float getBottomPadding() {
        if (this.attributes.isDefined("padding-bottom")) {
            return this.attributes.getFloat("padding-bottom");
        }
        if (this.attributes.isDefined("padding")) {
            return this.attributes.getFloat("padding");
        }
        return 2.0f;
    }

    public Font getTitleFont() {
        if (this.attributes.isDefined("title-font")) {
            return this.attributes.getFont("title-font");
        }
        return DEFAULT_TITLE_FONT;
    }

    public Font getDescriptionFont() {
        if (this.attributes.isDefined("description-font")) {
            return this.attributes.getFont("description-font");
        }
        return DEFAULT_DESCRIPTION_FONT;
    }

    public String[] getSegmentLabels() {
        List labelList = this.model.getSegmentLabels();
        if (labelList != null) {
            int numLabels = CollectionUtils.getSize(labelList);
            String[] strLabels = new String[numLabels];
            Object cw = null;
            for (int i = 0; i < numLabels; ++i) {
                cw = labelList.get(i);
                if (cw == null) continue;
                strLabels[i] = cw.toString();
            }
            return strLabels;
        }
        if (this.attributes.isDefined("segment-labels")) {
            return this.attributes.getStringArray("segment-labels");
        }
        return null;
    }

    public String[] getAreaLabels() {
        List labelList = this.model.getAreaLabels();
        if (labelList != null) {
            int numLabels = CollectionUtils.getSize(labelList);
            String[] strLabels = new String[numLabels];
            Object cw = null;
            for (int i = 0; i < numLabels; ++i) {
                cw = labelList.get(i);
                if (cw == null) continue;
                strLabels[i] = cw.toString();
            }
            return strLabels;
        }
        if (this.attributes.isDefined("area-labels")) {
            return this.attributes.getStringArray("area-labels");
        }
        return null;
    }

    public ChartModel getModel() {
        return this.model;
    }

    public void setModel(ChartModel model) throws ChartException {
        this.model = model;
        if (!this.supportsNegativeValues() && model != null && model.getMinValue() < 0.0) {
            throw new ChartException("This chart type doesn't support negative values.");
        }
    }

    public boolean supportsNegativeValues() {
        return true;
    }

    protected double getMinValue() {
        return this.model.getMinValue();
    }

    protected double getMaxValue() {
        return this.model.getMaxValue();
    }

    public Rectangle2D draw(Rectangle2D viewport, Graphics2D graphics) throws ChartException {
        Color backgroundColor;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float borderWidth = this.getBorderWidth();
        if ((double)borderWidth > 0.0) {
            Stroke oldStroke = graphics.getStroke();
            graphics.setStroke(new BasicStroke(borderWidth));
            graphics.drawRect((int)viewport.getX(), (int)viewport.getY(), (int)viewport.getWidth(), (int)viewport.getHeight());
            graphics.setStroke(oldStroke);
        }
        if ((backgroundColor = this.getBackgroundColor()) != null) {
            Color c = graphics.getColor();
            graphics.setColor(backgroundColor);
            graphics.fillRect((int)viewport.getMinX(), (int)viewport.getMinY(), (int)viewport.getWidth(), (int)viewport.getHeight());
            graphics.setColor(c);
        }
        Rectangle localViewport = new Rectangle((int)(viewport.getMinX() + (double)this.getLeftPadding()), (int)(viewport.getMinY() + (double)this.getTopPadding()), (int)(viewport.getWidth() - (double)this.getLeftPadding() - (double)this.getRightPadding()), (int)(viewport.getHeight() - (double)this.getTopPadding() - (double)this.getBottomPadding()));
        TextChartItem title = this.model.getTitle();
        if (title != null) {
            title.resetMetrics();
            title.draw(localViewport, graphics);
        }
        return localViewport;
    }
}

