/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import org.ujac.chart.BasePieChart3D;

public class DonutChart3D
extends BasePieChart3D {
    String ATTR_HOLE_SIZE = "hole-size";
    public static final float DEFAULT_HOLE_SIZE = 40.0f;
    private double halfSliceHeight = 0.0;
    private double quarterSliceHeight = 0.0;
    private double holeSize = 0.0;
    private double holeHeight = 0.0;
    private double halfHoleHeight = 0.0;
    private double holeWidth = 0.0;
    private double halfHoleWidth = 0.0;
    private double outerPieHeight = 0.0;
    private double outerPieWidth = 0.0;
    private double halfOuterPieHeight = 0.0;
    private double halfOuterPieWidth = 0.0;
    private double quarterOuterPieHeight = 0.0;
    private double quarterOuterPieWidth = 0.0;
    private double quarterHalfOuterPieHeight = 0.0;
    private double quarterHalfOuterPieWidth = 0.0;
    private double innerPieHeight = 0.0;
    private double innerPieWidth = 0.0;
    private double halfInnerPieHeight = 0.0;
    private double halfInnerPieWidth = 0.0;
    private double quarterInnerPieHeight = 0.0;
    private double quarterInnerPieWidth = 0.0;
    private double quarterHalfInnerPieHeight = 0.0;
    private double quarterHalfInnerPieWidth = 0.0;

    public float getHoleSize() {
        if (this.attributes.isDefined(this.ATTR_HOLE_SIZE)) {
            return this.attributes.getFloat(this.ATTR_HOLE_SIZE);
        }
        return 40.0f;
    }

    protected int getNumDrawingSteps() {
        return 5;
    }

    protected int getDescriptionDrawingStep() {
        return 2;
    }

    protected void init(int numSegments) {
        super.init(numSegments);
        this.halfSliceHeight = (double)this.getSliceHeight() * 0.5;
        this.quarterSliceHeight = this.halfSliceHeight * 0.25;
        this.holeSize = this.getHoleSize();
        this.halfHoleHeight = this.halfPieHeight * this.holeSize / 100.0;
        this.holeHeight = this.halfHoleHeight * 2.0;
        this.halfHoleWidth = (float)(this.halfHoleHeight / this.getDeltaY());
        this.holeWidth = this.halfHoleWidth * 2.0;
        double halfOuterFactor = 1.0925;
        this.outerPieWidth = this.getPieSize().getWidth() * halfOuterFactor;
        this.outerPieHeight = this.getPieSize().getHeight() * halfOuterFactor;
        this.halfOuterPieWidth = this.halfPieWidth * halfOuterFactor;
        this.halfOuterPieHeight = this.halfPieHeight * halfOuterFactor;
        double quarterOuterFactor = 1.0625;
        this.quarterOuterPieWidth = this.getPieSize().getWidth() * quarterOuterFactor;
        this.quarterOuterPieHeight = this.getPieSize().getHeight() * quarterOuterFactor;
        this.quarterHalfOuterPieWidth = this.halfPieWidth * quarterOuterFactor;
        this.quarterHalfOuterPieHeight = this.halfPieHeight * quarterOuterFactor;
        double innerFactor = 1.25;
        this.innerPieWidth = this.holeWidth / innerFactor;
        this.innerPieHeight = this.holeHeight / innerFactor;
        this.halfInnerPieWidth = this.halfHoleWidth / innerFactor;
        this.halfInnerPieHeight = this.halfHoleHeight / innerFactor;
        double quarterInnerFactor = 0.82;
        this.quarterInnerPieWidth = this.holeWidth * quarterInnerFactor;
        this.quarterInnerPieHeight = this.holeHeight * quarterInnerFactor;
        this.quarterHalfInnerPieWidth = this.halfHoleWidth * quarterInnerFactor;
        this.quarterHalfInnerPieHeight = this.halfHoleHeight * quarterInnerFactor;
    }

    protected void drawSlice(Graphics2D graphics, Color color, int sliceIdx, int stepIdx) {
        boolean fill = true;
        double startAngle = this.startAngles[sliceIdx];
        double endAngle = this.endAngles[sliceIdx];
        double angleDiff = this.angleDiffs[sliceIdx];
        double startArc = this.startArcs[sliceIdx];
        double endArc = this.endArcs[sliceIdx];
        double centerX = this.getPieCenter().getX();
        double centerY = this.getPieCenter().getY();
        double pieWidth = this.getPieSize().getWidth();
        double pieHeight = this.getPieSize().getHeight();
        double sliceHeight = this.getSliceHeight();
        Line2D.Double startLine = new Line2D.Double(0.0, this.halfPieHeight, 0.0, this.halfHoleHeight);
        AffineTransform rotate = new AffineTransform();
        rotate.rotate(-startArc);
        PathIterator pIterStart = startLine.getPathIterator(rotate);
        double[] coordFrom = new double[2];
        double[] holeFrom = new double[2];
        pIterStart.currentSegment(coordFrom);
        pIterStart.next();
        pIterStart.currentSegment(holeFrom);
        double deltaY = this.getDeltaY();
        coordFrom[0] = coordFrom[0] / deltaY;
        holeFrom[0] = holeFrom[0] / deltaY;
        rotate = new AffineTransform();
        rotate.rotate(-endArc);
        PathIterator pIterEnd = startLine.getPathIterator(rotate);
        double[] coordTo = new double[2];
        double[] holeTo = new double[2];
        pIterEnd.currentSegment(coordTo);
        pIterEnd.next();
        pIterEnd.currentSegment(holeTo);
        coordTo[0] = coordTo[0] / deltaY;
        holeTo[0] = holeTo[0] / deltaY;
        if (stepIdx == 0) {
            graphics.setColor(color.darker());
            GeneralPath path = null;
            path = new GeneralPath();
            path.append(new Arc2D.Double(-this.quarterHalfOuterPieWidth, -this.quarterHalfOuterPieHeight + sliceHeight - this.quarterSliceHeight, this.quarterOuterPieWidth, this.quarterOuterPieHeight, startAngle, angleDiff, 0), true);
            path.append(new Arc2D.Double(-this.halfPieWidth, -this.halfPieHeight + sliceHeight, pieWidth, pieHeight, endAngle, -angleDiff, 0), true);
            path.transform(this.moveToCenter);
            if (fill) {
                graphics.fill(path);
            } else {
                graphics.draw(path);
            }
            path = new GeneralPath();
            path.append(new Arc2D.Double(-this.quarterHalfInnerPieWidth, -this.quarterHalfInnerPieHeight + sliceHeight - this.quarterSliceHeight, this.quarterInnerPieWidth, this.quarterInnerPieHeight, startAngle, angleDiff, 0), true);
            path.append(new Arc2D.Double(-this.halfHoleWidth, -this.halfHoleHeight + sliceHeight, this.holeWidth, this.holeHeight, endAngle, -angleDiff, 0), true);
            path.transform(this.moveToCenter);
            if (fill) {
                graphics.fill(path);
            } else {
                graphics.draw(path);
            }
        } else if (stepIdx == 1) {
            graphics.setColor(color.darker());
            AffineTransform move = new AffineTransform();
            move.translate(centerX, centerY);
            GeneralPath path = null;
            path = new GeneralPath();
            path.append(new Arc2D.Double(-this.quarterHalfOuterPieWidth, -this.quarterHalfOuterPieHeight + sliceHeight - this.quarterSliceHeight, this.quarterOuterPieWidth, this.quarterOuterPieHeight, startAngle, angleDiff, 0), true);
            path.append(new Arc2D.Double(-this.halfOuterPieWidth, -this.halfOuterPieHeight + this.halfSliceHeight, this.outerPieWidth, this.outerPieHeight, endAngle, -angleDiff, 0), true);
            path.transform(this.moveToCenter);
            if (fill) {
                graphics.fill(path);
            } else {
                graphics.draw(path);
            }
            path = new GeneralPath();
            path.append(new Arc2D.Double(-this.quarterHalfInnerPieWidth, -this.quarterHalfInnerPieHeight + sliceHeight - this.quarterSliceHeight, this.quarterInnerPieWidth, this.quarterInnerPieHeight, startAngle, angleDiff, 0), true);
            path.append(new Arc2D.Double(-this.halfInnerPieWidth, -this.halfInnerPieHeight + this.halfSliceHeight, this.innerPieWidth, this.innerPieHeight, endAngle, -angleDiff, 0), true);
            path.transform(this.moveToCenter);
            if (fill) {
                graphics.fill(path);
            } else {
                graphics.draw(path);
            }
        } else if (stepIdx == 2) {
            graphics.setColor(color.darker());
            AffineTransform move = new AffineTransform();
            move.translate(centerX, centerY);
            GeneralPath path = null;
            path = new GeneralPath();
            path.append(new Arc2D.Double(-this.quarterHalfOuterPieWidth, -this.quarterHalfOuterPieHeight + this.quarterSliceHeight, this.quarterOuterPieWidth, this.quarterOuterPieHeight, startAngle, angleDiff, 0), true);
            path.append(new Arc2D.Double(-this.halfOuterPieWidth, -this.halfOuterPieHeight + this.halfSliceHeight, this.outerPieWidth, this.outerPieHeight, endAngle, -angleDiff, 0), true);
            path.transform(this.moveToCenter);
            if (fill) {
                graphics.fill(path);
            } else {
                graphics.draw(path);
            }
            path = new GeneralPath();
            path.append(new Arc2D.Double(-this.halfInnerPieWidth, -this.halfInnerPieHeight + this.halfSliceHeight, this.innerPieWidth, this.innerPieHeight, startAngle, angleDiff, 0), true);
            path.append(new Arc2D.Double(-this.quarterHalfInnerPieWidth, -this.quarterHalfInnerPieHeight + this.quarterSliceHeight, this.quarterInnerPieWidth, this.quarterInnerPieHeight, endAngle, -angleDiff, 0), true);
            path.transform(this.moveToCenter);
            if (fill) {
                graphics.fill(path);
            } else {
                graphics.draw(path);
            }
        } else if (stepIdx == 3) {
            graphics.setColor(color.darker());
            AffineTransform move = new AffineTransform();
            move.translate(centerX, centerY);
            GeneralPath path = null;
            path = new GeneralPath();
            path.append(new Arc2D.Double(-this.quarterHalfOuterPieWidth, -this.quarterHalfOuterPieHeight + this.quarterSliceHeight, this.quarterOuterPieWidth, this.quarterOuterPieHeight, startAngle, angleDiff, 0), true);
            path.append(new Arc2D.Double(-this.halfPieWidth, -this.halfPieHeight, pieWidth, pieHeight, endAngle, -angleDiff, 0), true);
            path.transform(this.moveToCenter);
            graphics.draw(path);
            if (fill) {
                graphics.fill(path);
            } else {
                graphics.draw(path);
            }
            path = new GeneralPath();
            path.append(new Arc2D.Double(-this.quarterHalfInnerPieWidth, -this.quarterHalfInnerPieHeight + this.quarterSliceHeight, this.quarterInnerPieWidth, this.quarterInnerPieHeight, startAngle, angleDiff, 0), true);
            path.append(new Arc2D.Double(-this.halfHoleWidth, -this.halfHoleHeight, this.holeWidth, this.holeHeight, endAngle, -angleDiff, 0), true);
            path.transform(this.moveToCenter);
            if (fill) {
                graphics.fill(path);
            } else {
                graphics.draw(path);
            }
        } else {
            GeneralPath path = new GeneralPath();
            path.append(new Arc2D.Double(-this.halfPieWidth, -this.halfPieHeight, pieWidth, pieHeight, startAngle, angleDiff, 0), true);
            path.append(new Line2D.Double(coordTo[0], coordTo[1], holeTo[0], holeTo[1]), true);
            path.append(new Arc2D.Double(-this.halfHoleWidth, -this.halfHoleHeight, this.holeWidth, this.holeHeight, endAngle, -angleDiff, 0), true);
            path.append(new Line2D.Double(holeFrom[0], holeFrom[1], coordFrom[0], coordFrom[1]), true);
            AffineTransform move = new AffineTransform();
            move.translate(centerX, centerY);
            path.transform(this.moveToCenter);
            graphics.setColor(color);
            if (fill) {
                graphics.fill(path);
            } else {
                graphics.draw(path);
            }
        }
    }

    protected void drawSliceShadow(Graphics2D graphics, Color color, int sliceIdx) {
        double startAngle = this.startAngles[sliceIdx];
        double endAngle = this.endAngles[sliceIdx];
        double angleDiff = this.angleDiffs[sliceIdx];
        double startArc = this.startArcs[sliceIdx];
        double endArc = this.endArcs[sliceIdx];
        double centerX = this.getPieCenter().getX();
        double centerY = this.getPieCenter().getY();
        double sliceHeight = this.getSliceHeight();
        AffineTransform rotate = new AffineTransform();
        rotate.rotate(-startArc);
        rotate = new AffineTransform();
        rotate.rotate(-endArc);
        GeneralPath path = new GeneralPath();
        path.append(new Arc2D.Double(-this.halfOuterPieWidth, -this.halfOuterPieHeight + sliceHeight, this.outerPieWidth, this.outerPieHeight, startAngle, angleDiff, 0), true);
        path.append(new Arc2D.Double(-this.halfInnerPieWidth, -this.halfInnerPieHeight + sliceHeight, this.innerPieWidth, this.innerPieHeight, endAngle, -angleDiff, 0), true);
        AffineTransform move = new AffineTransform();
        move.translate(centerX, centerY);
        path.transform(this.moveToCenter);
        graphics.setColor(color);
        graphics.fill(path);
    }
}

