/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import org.ujac.chart.Chart;
import org.ujac.chart.ChartException;
import org.ujac.chart.ChartWriter;

public class ImageIOChartWriter
extends ChartWriter {
    private String formatName = "jpg";
    private float quality = 0.75f;

    public ImageIOChartWriter(float quality) {
    }

    public ImageIOChartWriter(String formatName) {
        this.formatName = formatName;
    }

    public ImageIOChartWriter(String formatName, float quality) {
        this.formatName = formatName;
        this.quality = quality;
    }

    public float getQuality() {
        return this.quality;
    }

    public void setQuality(float quality) {
        this.quality = quality;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(Chart chart, OutputStream os, int width, int height) throws ChartException, IOException {
        ImageInputStream stream = null;
        ImageWriter writer = null;
        try {
            BufferedImage img = new BufferedImage(width, height, 1);
            Graphics graphics = img.getGraphics();
            chart.draw(new Rectangle(0, 0, width, height), (Graphics2D)graphics);
            graphics.dispose();
            stream = ImageIO.createImageOutputStream(os);
            ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(img);
            Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, "jpg");
            if (iter.hasNext()) {
                writer = iter.next();
            }
            if (writer == null) {
                throw new IOException("Failed to get writer for '" + this.formatName + "' images.");
            }
            writer.setOutput(stream);
            ImageWriteParam iwparam = writer.getDefaultWriteParam();
            iwparam.setCompressionMode(2);
            iwparam.setCompressionQuality(this.quality);
            writer.write(null, new IIOImage(img, null, null), iwparam);
        }
        finally {
            if (stream != null) {
                stream.flush();
            }
            if (writer != null) {
                writer.dispose();
            }
        }
    }
}

