/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeHandler;
import org.ujac.print.BooleanAttributeHandler;
import org.ujac.print.BorderAttributeHandler;
import org.ujac.print.ColorAttributeHandler;
import org.ujac.print.DimensionAttributeHandler;
import org.ujac.print.DocumentHandler;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DoubleAttributeHandler;
import org.ujac.print.EscapeSequenceTextAttributeHandler;
import org.ujac.print.FloatAttributeHandler;
import org.ujac.print.HorizontalAlignmentAttributeHandler;
import org.ujac.print.IntegerAttributeHandler;
import org.ujac.print.TagAttributeException;
import org.ujac.print.TextAttributeHandler;
import org.ujac.print.TypedAttributeHandler;
import org.ujac.print.VerticalAlignmentAttributeHandler;
import org.ujac.util.BeanUtils;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.template.TemplateException;
import org.xml.sax.Locator;

public class DefaultAttributeHandler
implements AttributeHandler {
    private static final Map colorMap = new HashMap();
    private DocumentHandler documentHandler = null;
    private TypedAttributeHandler textHandler = new TextAttributeHandler(this);
    private TypedAttributeHandler escapeSequenceTextHandler = new EscapeSequenceTextAttributeHandler(this);
    private TypedAttributeHandler integerHandler = new IntegerAttributeHandler(this);
    public TypedAttributeHandler floatHandler = new FloatAttributeHandler(this);
    public TypedAttributeHandler dimensionHandler = new DimensionAttributeHandler(this);
    public TypedAttributeHandler doubleHandler = new DoubleAttributeHandler(this);
    public TypedAttributeHandler booleanHandler = new BooleanAttributeHandler(this);
    public TypedAttributeHandler colorHandler = new ColorAttributeHandler(this);
    public TypedAttributeHandler borderHandler = new BorderAttributeHandler(this);
    public TypedAttributeHandler horizontalAlignmentHandler = new HorizontalAlignmentAttributeHandler(this);
    public TypedAttributeHandler verticalAlignmentHandler = new VerticalAlignmentAttributeHandler(this);

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public Object typeCastAttributeValue(Locator locator, AttributeDefinition attrDef, String attrName, Object value) throws DocumentHandlerException {
        Object localValue = null;
        switch (attrDef.getType()) {
            case 1: {
                localValue = new Integer(this.parseIntAttribute(locator, attrName, value, true));
                break;
            }
            case 2: {
                localValue = new Float(this.parseFloatAttribute(locator, attrName, value, true));
                break;
            }
            case 14: {
                localValue = new Float(this.parseDimensionAttribute(locator, attrName, value, true));
                break;
            }
            case 3: {
                localValue = new Boolean(this.parseBooleanAttribute(locator, attrName, value, true));
                break;
            }
            case 5: {
                localValue = this.parseColorAttribute(locator, attrName, value, true);
                break;
            }
            case 6: {
                localValue = new Integer(this.parseBorderAttribute(locator, attrName, value, true));
                break;
            }
            case 7: {
                localValue = new Integer(this.parseHorizontalAlignmentAttribute(locator, attrName, value, true));
                break;
            }
            case 8: {
                localValue = new Integer(this.parseVerticalAlignmentAttribute(locator, attrName, value, true));
                break;
            }
            default: {
                localValue = value.toString();
            }
        }
        return localValue;
    }

    public String parseTextAttribute(Locator locator, String attrName, Object attrValue, boolean evaluate, boolean translateEscapeSequences) throws TagAttributeException {
        if (attrValue == null) {
            return null;
        }
        String strValue = attrValue.toString();
        if (evaluate) {
            try {
                strValue = this.documentHandler.executeTemplate(strValue);
            }
            catch (TemplateException ex) {
                throw new TagAttributeException(locator, "Failed to evaluate expression " + attrValue + " for Attribute " + attrName + ".", ex);
            }
        }
        if (!translateEscapeSequences) {
            return strValue;
        }
        StringBuffer resultBuf = new StringBuffer();
        try {
            this.processEscapeSequences(locator, attrName, strValue, resultBuf, false);
        }
        catch (TagAttributeException ex) {
            throw ex;
        }
        catch (DocumentHandlerException ex) {
            throw new TagAttributeException(ex.getLocator(), ex.getMessage(), ex);
        }
        return resultBuf.toString();
    }

    public int parseIntAttribute(Locator locator, String attrName, Object attrValue, boolean evaluate) throws TagAttributeException {
        if (attrValue == null) {
            return 0;
        }
        if (attrValue instanceof Number) {
            return ((Number)attrValue).intValue();
        }
        if (!evaluate) {
            try {
                return Integer.parseInt(attrValue.toString());
            }
            catch (NumberFormatException ex) {
                throw new TagAttributeException(locator, "Attribute " + attrName + " must be a valid float value (was '" + attrValue + "').", ex);
            }
        }
        try {
            return this.documentHandler.evalInt(attrValue.toString());
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(locator, "Attribute " + attrName + " must be a valid float value (was '" + attrValue + "').", ex);
        }
    }

    public float parseFloatAttribute(Locator locator, String attrName, Object attrValue, boolean evaluate) throws TagAttributeException {
        if (attrValue == null) {
            return 0.0f;
        }
        if (attrValue instanceof Number) {
            return ((Number)attrValue).floatValue();
        }
        if (!evaluate) {
            try {
                return Float.parseFloat(attrValue.toString());
            }
            catch (NumberFormatException ex) {
                throw new TagAttributeException(locator, "Attribute " + attrName + " must be a valid float value (was '" + attrValue + "').", ex);
            }
        }
        try {
            return this.documentHandler.evalFloat(attrValue.toString());
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(locator, "Attribute " + attrName + " must be a valid float value (was '" + attrValue + "').", ex);
        }
    }

    public float parseDimensionAttribute(Locator locator, String attrName, Object attrValue, boolean evaluate) throws TagAttributeException {
        if (attrValue == null) {
            return 0.0f;
        }
        if (attrValue instanceof Number) {
            return ((Number)attrValue).floatValue();
        }
        String strVal = attrValue.toString();
        if (evaluate) {
            try {
                strVal = this.documentHandler.evalString(strVal);
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(locator, "Attribute " + attrName + " must be a valid float value (was '" + attrValue + "').", ex);
            }
        }
        try {
            int ptIdx = strVal.indexOf("pt");
            if (ptIdx >= 0) {
                strVal = strVal.substring(0, ptIdx);
            }
            return Float.parseFloat(strVal);
        }
        catch (NumberFormatException ex) {
            throw new TagAttributeException(locator, "Attribute " + attrName + " must be a valid float value (was '" + attrValue + "').", ex);
        }
    }

    public double parseDoubleAttribute(Locator locator, String attrName, Object attrValue, boolean evaluate) throws TagAttributeException {
        if (attrValue == null) {
            return 0.0;
        }
        if (attrValue instanceof Number) {
            return ((Number)attrValue).doubleValue();
        }
        if (!evaluate) {
            try {
                return Double.parseDouble(attrValue.toString());
            }
            catch (NumberFormatException ex) {
                throw new TagAttributeException(locator, "Attribute " + attrName + " must be a valid double value (was '" + attrValue + "').", ex);
            }
        }
        try {
            return this.documentHandler.evalDouble(attrValue.toString());
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(locator, "Attribute " + attrName + " must be a valid double value (was '" + attrValue + "').", ex);
        }
    }

    public boolean parseBooleanAttribute(Locator locator, String attrName, Object attrValue, boolean evaluate) throws TagAttributeException {
        if (attrValue == null) {
            return false;
        }
        if (attrValue instanceof Boolean) {
            return (Boolean)attrValue;
        }
        if (!evaluate) {
            try {
                return new Boolean(attrValue.toString());
            }
            catch (NumberFormatException ex) {
                throw new TagAttributeException(locator, "Attribute " + attrName + " must be a valid float value (was '" + attrValue + "').", ex);
            }
        }
        try {
            return this.documentHandler.evalBoolean(attrValue.toString());
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(locator, "Attribute " + attrName + " must be a valid float value (was '" + attrValue + "').", ex);
        }
    }

    public Color parseColorAttribute(Locator locator, String attrName, Object attrValue, boolean evaluate) throws TagAttributeException {
        if (attrValue == null) {
            return null;
        }
        if (attrValue instanceof Color) {
            return (Color)attrValue;
        }
        String colVal = attrValue.toString();
        if (evaluate) {
            try {
                colVal = this.documentHandler.evalString(colVal);
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(locator, "Attribute " + attrName + " must be a valid color value (was '" + attrValue + "').", ex);
            }
        }
        if (colVal == null) {
            return null;
        }
        Color colorValue = this.documentHandler.getColor(colVal);
        if (colorValue != null) {
            return colorValue;
        }
        colorValue = (Color)colorMap.get(colVal);
        if (colorValue != null) {
            return colorValue;
        }
        if (colVal.length() >= 6) {
            try {
                if (colVal.length() == 7) {
                    colVal = colVal.substring(1);
                }
                return new Color(Integer.parseInt(colVal, 16));
            }
            catch (NumberFormatException ex) {
                throw new TagAttributeException(locator, "The color value '" + colVal + "' has to define a registered color, a built in one " + "or a 6 digit RGB value.");
            }
        }
        return null;
    }

    public int parseBorderAttribute(Locator locator, String attrName, Object attrValue, boolean evaluate) throws TagAttributeException {
        if (attrValue == null) {
            return 0;
        }
        if (attrValue instanceof Number) {
            return ((Number)attrValue).intValue();
        }
        String strValue = attrValue.toString();
        if (evaluate) {
            try {
                strValue = this.documentHandler.evalString(attrValue.toString());
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(locator, "Attribute " + attrName + " must be a legal border value (was '" + attrValue + "').", ex);
            }
        }
        StringTokenizer tkn = new StringTokenizer(strValue, "|");
        int border = 0;
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            if (token.equalsIgnoreCase("none")) {
                border = 0;
                break;
            }
            if (token.equalsIgnoreCase("box")) {
                border = 15;
                break;
            }
            if (token.equalsIgnoreCase("left")) {
                border |= 4;
                continue;
            }
            if (token.equalsIgnoreCase("right")) {
                border |= 8;
                continue;
            }
            if (token.equalsIgnoreCase("top")) {
                border |= 1;
                continue;
            }
            if (token.equalsIgnoreCase("bottom")) {
                border |= 2;
                continue;
            }
            throw new TagAttributeException(locator, "Attribute " + attrName + " must hold a list of border styles " + "(none, top, bottom, left, right, box), separated by '|' (was '" + token + "').");
        }
        return border;
    }

    public int parseHorizontalAlignmentAttribute(Locator locator, String attrName, Object attrValue, boolean evaluate) throws TagAttributeException {
        if (attrValue == null) {
            return 0;
        }
        if (attrValue instanceof Number) {
            return ((Number)attrValue).intValue();
        }
        String strValue = attrValue.toString();
        if (evaluate) {
            try {
                strValue = this.documentHandler.evalString(attrValue.toString());
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(locator, "Attribute " + attrName + " must be a legal horizontal alignment value (was '" + attrValue + "').", ex);
            }
        }
        if (BeanUtils.isEmpty(strValue)) {
            return 0;
        }
        if (strValue.equalsIgnoreCase("left")) {
            return 0;
        }
        if (strValue.equalsIgnoreCase("right")) {
            return 2;
        }
        if (strValue.equalsIgnoreCase("center")) {
            return 1;
        }
        if (strValue.equalsIgnoreCase("justified")) {
            return 3;
        }
        if (strValue.equalsIgnoreCase("justified-all")) {
            return 8;
        }
        throw new TagAttributeException(locator, "Invalid value for attribute " + attrName + ": '" + attrValue + "'. Allowed values are: left, right, center, justified, justified-all.");
    }

    public int parseVerticalAlignmentAttribute(Locator locator, String attrName, Object attrValue, boolean evaluate) throws TagAttributeException {
        if (attrValue == null) {
            return 0;
        }
        if (attrValue instanceof Number) {
            return ((Number)attrValue).intValue();
        }
        String strValue = attrValue.toString();
        if (evaluate) {
            try {
                strValue = this.documentHandler.evalString(strValue);
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(locator, "Attribute " + attrName + " must be a legal vertical alignment value (was '" + attrValue + "').", ex);
            }
        }
        if (BeanUtils.isEmpty(strValue)) {
            return 0;
        }
        if (strValue.equalsIgnoreCase("top")) {
            return 4;
        }
        if (strValue.equalsIgnoreCase("bottom")) {
            return 6;
        }
        if (strValue.equalsIgnoreCase("middle")) {
            return 5;
        }
        if (strValue.equalsIgnoreCase("baseline")) {
            return 7;
        }
        throw new TagAttributeException(locator, "Invalid value for attribute " + attrName + ": '" + attrValue + "'. Allowed values are: top, bottom, middle, baseline.");
    }

    protected void processEscapeSequences(Locator locator, String attrName, String contents, StringBuffer buffer, boolean trimHead) throws DocumentHandlerException {
        int textLen = contents.length();
        block9: for (int i = 0; i < textLen; ++i) {
            char c = contents.charAt(i);
            if (c == '\\') {
                if (++i >= textLen) {
                    throw new DocumentHandlerException(locator, "Syntax expression: empty escape sequence at chunk '" + contents + "'.");
                }
                c = contents.charAt(i);
                block0 : switch (c) {
                    case 'n': {
                        buffer.append('\n');
                        ++i;
                        while (i < textLen) {
                            if (!Character.isWhitespace(contents.charAt(i))) {
                                --i;
                                break block0;
                            }
                            ++i;
                        }
                        continue block9;
                    }
                    case 'u': {
                        String code = contents.substring(i + 1, i + 5);
                        int unicodeValue = Integer.parseInt(code, 16);
                        i += 4;
                        buffer.append((char)unicodeValue);
                        break;
                    }
                    case ' ': {
                        buffer.append(" ");
                        break;
                    }
                    case 't': {
                        buffer.append("    ");
                        break;
                    }
                    case '\\': {
                        buffer.append("\\");
                        break;
                    }
                    case '{': {
                        buffer.append("{");
                        break;
                    }
                    case '}': {
                        buffer.append("}");
                        break;
                    }
                    default: {
                        throw new DocumentHandlerException(locator, "Syntax expression: unknown escape sequence '\\" + c + "' at chunk '" + contents + "'.");
                    }
                }
                continue;
            }
            if (Character.isWhitespace(c) && (trimHead && buffer.length() == 0 || buffer.length() > 0 && Character.isWhitespace(buffer.charAt(buffer.length() - 1)))) continue;
            buffer.append(c);
        }
    }

    public TypedAttributeHandler getTextHandler() {
        return this.textHandler;
    }

    public TypedAttributeHandler getEscapeSequenceTextHandler() {
        return this.escapeSequenceTextHandler;
    }

    public TypedAttributeHandler getIntegerHandler() {
        return this.integerHandler;
    }

    public TypedAttributeHandler getFloatHandler() {
        return this.floatHandler;
    }

    public TypedAttributeHandler getDimensionHandler() {
        return this.dimensionHandler;
    }

    public TypedAttributeHandler getDoubleHandler() {
        return this.doubleHandler;
    }

    public TypedAttributeHandler getBooleanHandler() {
        return this.booleanHandler;
    }

    public TypedAttributeHandler getColorHandler() {
        return this.colorHandler;
    }

    public TypedAttributeHandler getBorderHandler() {
        return this.borderHandler;
    }

    public TypedAttributeHandler getHorizontalAlignmentHandler() {
        return this.horizontalAlignmentHandler;
    }

    public TypedAttributeHandler getVerticalAlignmentHandler() {
        return this.verticalAlignmentHandler;
    }

    static {
        colorMap.put("null", null);
        colorMap.put("NULL", null);
        colorMap.put("none", null);
        colorMap.put("NONE", null);
        colorMap.put("black", Color.black);
        colorMap.put("BLACK", Color.black);
        colorMap.put("blue", Color.blue);
        colorMap.put("BLUE", Color.blue);
        colorMap.put("cyan", Color.cyan);
        colorMap.put("CYAN", Color.cyan);
        colorMap.put("darkGray", Color.darkGray);
        colorMap.put("DARK_GRAY", Color.darkGray);
        colorMap.put("gray", Color.gray);
        colorMap.put("GRAY", Color.gray);
        colorMap.put("green", Color.green);
        colorMap.put("GREEN", Color.green);
        colorMap.put("lightGray", Color.lightGray);
        colorMap.put("LIGHT_GRAY", Color.lightGray);
        colorMap.put("magenta", Color.magenta);
        colorMap.put("MAGENTA", Color.magenta);
        colorMap.put("orange", Color.orange);
        colorMap.put("ORANGE", Color.orange);
        colorMap.put("pink", Color.pink);
        colorMap.put("PINK", Color.pink);
        colorMap.put("red", Color.red);
        colorMap.put("RED", Color.red);
        colorMap.put("white", Color.white);
        colorMap.put("WHITE", Color.white);
        colorMap.put("yellow", Color.yellow);
        colorMap.put("YELLOW", Color.yellow);
    }
}

