/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ContentFilter;
import org.ujac.print.DocumentHandlerException;

public class DefaultContentFilter
implements ContentFilter {
    public void filterContents(BaseDocumentTag tag, String contents, int offset, StringBuffer outputBuffer) throws DocumentHandlerException {
        boolean translateEscapeSequences = tag.getDocumentHandler().isTranslateEscapeSequences();
        int textLen = contents.length();
        int numConnectedWhiteSpaces = 0;
        for (int i = offset; i < textLen; ++i) {
            char c = contents.charAt(i);
            if (translateEscapeSequences && c == '\\') {
                i = this.processEscapeSequence(tag, contents, i, outputBuffer);
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (++numConnectedWhiteSpaces > 1) {
                    continue;
                }
            } else {
                numConnectedWhiteSpaces = 0;
            }
            outputBuffer.append(c);
        }
    }

    protected int processEscapeSequence(BaseDocumentTag tag, String contents, int offset, StringBuffer outputBuffer) throws DocumentHandlerException {
        int localOffset = offset + 1;
        int textLen = contents.length();
        if (localOffset >= textLen) {
            throw new DocumentHandlerException(tag.locator(), "Syntax expression: empty escape sequence at chunk '" + contents + "'.");
        }
        char c = contents.charAt(localOffset);
        switch (c) {
            case 'n': {
                outputBuffer.append('\n');
                ++localOffset;
                while (localOffset < textLen) {
                    if (!Character.isWhitespace(contents.charAt(localOffset))) {
                        --localOffset;
                        break;
                    }
                    ++localOffset;
                }
                return localOffset;
            }
            case 'u': {
                String code = contents.substring(localOffset + 1, localOffset + 5);
                int unicodeValue = Integer.parseInt(code, 16);
                outputBuffer.append((char)unicodeValue);
                return localOffset += 4;
            }
            case ' ': {
                outputBuffer.append(" ");
                return localOffset;
            }
            case 't': {
                outputBuffer.append("    ");
                return localOffset;
            }
            case '\\': {
                outputBuffer.append("\\");
                return localOffset;
            }
            case '{': {
                outputBuffer.append("{");
                return localOffset;
            }
            case '}': {
                outputBuffer.append("}");
                return localOffset;
            }
        }
        throw new DocumentHandlerException(tag.locator(), "Syntax expression: unknown escape sequence '\\" + c + "' at chunk '" + contents + "'.");
    }
}

