/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.util.Map;
import java.util.StringTokenizer;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeHandler;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.StyleParser;
import org.ujac.print.tag.TagAttributes;
import org.xml.sax.Locator;

public class DefaultStyleParser
implements StyleParser,
TagAttributes {
    private AttributeHandler attributeHandler = null;

    public void setAttributeHandler(AttributeHandler attributeHandler) {
        this.attributeHandler = attributeHandler;
    }

    public int parseStyle(Locator locator, String styleDef, Map supportedAttributeMap, Map styleMap) throws DocumentHandlerException {
        int numParsedArguments = 0;
        int parseState = 0;
        AttributeDefinition attrDef = null;
        String attrName = null;
        String rawAttrValue = null;
        Object attrValue = null;
        StringTokenizer tkn = new StringTokenizer(styleDef, ";: ", true);
        block9: while (tkn.hasMoreTokens()) {
            String t = tkn.nextToken();
            char c = t.charAt(0);
            switch (c) {
                case ';': {
                    if (parseState == 3 && attrName != null && attrValue != null) {
                        styleMap.put(attrDef.getName(), attrValue);
                        ++numParsedArguments;
                    }
                    parseState = 0;
                    attrName = null;
                    attrValue = null;
                    continue block9;
                }
                case ':': {
                    if (parseState != 1) continue block9;
                    parseState = 2;
                    continue block9;
                }
                case ' ': {
                    continue block9;
                }
            }
            switch (parseState) {
                case 0: {
                    attrName = t;
                    attrValue = null;
                    parseState = 1;
                    continue block9;
                }
                case 2: {
                    rawAttrValue = t;
                    parseState = 3;
                    attrDef = (AttributeDefinition)supportedAttributeMap.get(attrName);
                    if (attrDef == null) continue block9;
                    attrValue = this.attributeHandler.typeCastAttributeValue(locator, attrDef, attrName, rawAttrValue);
                    continue block9;
                }
            }
            throw new DocumentHandlerException(locator, "Encounterered invalid parse state " + parseState + "!");
        }
        if (parseState == 3 && attrName != null && attrValue != null) {
            this.putStyle(styleMap, attrDef.getName(), attrValue);
            ++numParsedArguments;
        }
        return numParsedArguments;
    }

    protected void putStyle(Map styleMap, String name, Object value) {
        styleMap.put(name, value);
        if ("font-name".equals(name)) {
            styleMap.remove("font-color");
            styleMap.remove("font-encoding");
            styleMap.remove("font-family");
            styleMap.remove("font-size");
            styleMap.remove("font-style");
        }
    }
}

