/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import com.lowagie.text.Font;
import java.awt.Color;
import org.ujac.util.BeanUtils;

public class DocumentFont {
    private Font font = null;
    private String family;
    private String encoding;
    private float size;
    private int style;
    private float textRise = 0.0f;
    private Color color;

    public DocumentFont(Font font, String family, String encoding, float size, int style, Color color) {
        this.font = font;
        this.family = family;
        this.encoding = encoding;
        this.size = size;
        this.style = style;
        this.color = color;
    }

    public DocumentFont(Font font, String family, String encoding, float size, int style, float textRise, Color color) {
        this.font = font;
        this.family = family;
        this.encoding = encoding;
        this.size = size;
        this.style = style;
        this.textRise = textRise;
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public String getFamily() {
        return this.family;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Font getFont() {
        return this.font;
    }

    public float getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public float getTextRise() {
        return this.textRise;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isUnderline() {
        return (this.style & 4) != 0;
    }

    public boolean isStrikethru() {
        return (this.style & 8) != 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentFont)) {
            return false;
        }
        DocumentFont other = (DocumentFont)obj;
        boolean familiesEqual = BeanUtils.equals(this.family, other.family);
        boolean colorsEqual = BeanUtils.equals(this.color, other.color);
        return familiesEqual && this.size == other.size && this.style == other.style && colorsEqual;
    }

    public int hashCode() {
        int colorHash = 0;
        if (this.color != null) {
            colorHash = this.color.hashCode() * 23;
        }
        return this.family.hashCode() + (int)(this.size * 113.0f) + this.style * 17 + colorHash;
    }
}

