/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.PhraseHolder;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;

public class DynamicContentContainer
extends BaseDocumentTag
implements PhraseHolder,
ElementContainer {
    public static final String TAG_NAME = "_DYNAMIC_CONTENT_";
    private float leading = 0.0f;
    private float lineSpacing = 1.2f;
    protected ElementContainer elementContainer = null;
    private Phrase contents = null;

    public String getName() {
        return TAG_NAME;
    }

    public String getDescription() {
        return "Internal container holding the results of dynamic content evaluation.";
    }

    public boolean isVirtualContainer() {
        return true;
    }

    public boolean isStructureChecksDisabled() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.elementContainer = this.documentHandler.latestElementContainer();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.leading = 0.0f;
        this.lineSpacing = this.isAttributeDefined(CommonAttributes.LINE_SPACING, CommonStyleAttributes.LINE_SPACING) ? this.getDimensionAttribute(CommonAttributes.LINE_SPACING, true, CommonStyleAttributes.LINE_SPACING) : this.elementContainer.getLineSpacing();
    }

    public void flushContent() throws DocumentHandlerException {
        Phrase nestedPhrase;
        if (!this.isValid()) {
            return;
        }
        if (this.isIgnoreFlush()) {
            return;
        }
        if (this.isTrimNextHead()) {
            this.trimContentHead();
            this.setTrimNextHead(false);
        }
        if (this.isItemClosed() && this.isTrimBody()) {
            this.trimContentTail();
        }
        if ((nestedPhrase = this.addChunk(this.contents, this.getLeading(), this.getLineSpacing())) != null) {
            this.contents = nestedPhrase;
        }
        this.resetContent();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.flushContent();
    }

    public void addChunk(BaseDocumentTag item, String chunk, DocumentFont font) throws DocumentHandlerException {
        super.addChunk(item, this.contents, chunk, font, this.leading, this.lineSpacing);
    }

    public void addChunk(BaseDocumentTag item, Chunk chunk) throws DocumentHandlerException {
        super.addChunk(this.contents, chunk, this.leading, this.lineSpacing);
    }

    public float getLeading() {
        return this.leading;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (!(element instanceof Phrase)) {
            throw new DocumentHandlerException(item.locator(), "Only phrases are allowed as contents for dynamic content evaluation by now!");
        }
        Phrase phrase = (Phrase)element;
        this.extendLeading(this.contents, phrase);
        this.contents.add((Object)phrase);
    }

    public boolean isTopLevel() {
        return false;
    }

    public Phrase getContents() {
        return this.contents;
    }

    public void setContents(Phrase contents) {
        this.contents = contents;
    }
}

