/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentTagInterceptor;
import org.xml.sax.Attributes;

public class TraceTagInterceptor
implements DocumentTagInterceptor {
    private int level = 0;

    public boolean beforeOpen(BaseDocumentTag tag) throws DocumentHandlerException {
        ++this.level;
        System.out.print(this.getIndentation() + "<" + tag.getName());
        Attributes attributes = tag.getAttributes();
        int numAttributes = attributes.getLength();
        for (int i = 0; i < numAttributes; ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            System.out.print(" " + name + "\"" + value + "\"");
        }
        System.out.println(">");
        return true;
    }

    public void afterOpen(BaseDocumentTag tag) throws DocumentHandlerException {
    }

    public boolean beforeClose(BaseDocumentTag tag) throws DocumentHandlerException {
        return true;
    }

    public void afterClose(BaseDocumentTag tag) throws DocumentHandlerException {
        System.out.println(this.getIndentation() + "</" + tag.getName() + ">");
        --this.level;
    }

    private String getIndentation() {
        StringBuffer indentBuf = new StringBuffer();
        for (int i = 1; i < this.level; ++i) {
            indentBuf.append("  ");
        }
        return indentBuf.toString();
    }
}

