/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentPrinter;
import org.ujac.print.DocumentTagFactory;
import org.ujac.print.TagBuilder;
import org.ujac.util.CollectionUtils;

public class XmlSchemaGenerator {
    private DocumentTagFactory tagFactory = null;

    public XmlSchemaGenerator(DocumentTagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    public void generateXmlSchema(Writer out) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<xsd:schema targetNamespace=\"http:///UJAC/org/ujac/print/document.xsd\"\n");
        out.write("            xmlns:this=\"http:///UJAC/org/ujac/print/document.xsd\"\n");
        out.write("            xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n");
        out.write("    <xsd:annotation>\n");
        out.write("        <xsd:documentation xml:lang=\"en\">Document definition for print.ujac.org.</xsd:documentation>\n");
        out.write("    </xsd:annotation>\n");
        out.write("    <!-- specifying the attribute types -->\n");
        out.write("    <xsd:simpleType name=\"pageSize\">\n");
        out.write("        <xsd:annotation>The supported page sizes</xsd:annotation>\n");
        out.write("        <xsd:restriction base=\"xsd:string\">\n");
        out.write("            <xsd:enumeration value=\"LETTER\"/>\n");
        out.write("            <xsd:enumeration value=\"NOTE\"/>\n");
        out.write("            <xsd:enumeration value=\"LEGAL\"/>\n");
        out.write("            <xsd:enumeration value=\"A0\"/>\n");
        out.write("            <xsd:enumeration value=\"A1\"/>\n");
        out.write("            <xsd:enumeration value=\"A2\"/>\n");
        out.write("            <xsd:enumeration value=\"A3\"/>\n");
        out.write("            <xsd:enumeration value=\"A4\"/>\n");
        out.write("            <xsd:enumeration value=\"A5\"/>\n");
        out.write("            <xsd:enumeration value=\"A6\"/>\n");
        out.write("            <xsd:enumeration value=\"A7\"/>\n");
        out.write("            <xsd:enumeration value=\"A8\"/>\n");
        out.write("            <xsd:enumeration value=\"A9\"/>\n");
        out.write("            <xsd:enumeration value=\"A10\"/>\n");
        out.write("            <xsd:enumeration value=\"B0\"/>\n");
        out.write("            <xsd:enumeration value=\"B1\"/>\n");
        out.write("            <xsd:enumeration value=\"B2\"/>\n");
        out.write("            <xsd:enumeration value=\"B3\"/>\n");
        out.write("            <xsd:enumeration value=\"B4\"/>\n");
        out.write("            <xsd:enumeration value=\"B5\"/>\n");
        out.write("        </xsd:restriction>\n");
        out.write("    </xsd:simpleType>\n");
        out.write("    <xsd:simpleType name=\"borderStyle\">\n");
        out.write("        <xsd:annotation>The supported border styles</xsd:annotation>\n");
        out.write("        <xsd:restriction base=\"xsd:string\">\n");
        out.write("            <xsd:pattern value=\"none|box|((left|right|top|bottom)\\|)+\"/>\n");
        out.write("        </xsd:restriction>\n");
        out.write("    </xsd:simpleType>\n");
        out.write("    <xsd:simpleType name=\"color\">\n");
        out.write("        <xsd:annotation>The color attribute type</xsd:annotation>\n");
        out.write("        <xsd:restriction base=\"xsd:string\">\n");
        out.write("            <xsd:pattern value=\"[0-9a-fA-F]{6}\"/>\n");
        out.write("        </xsd:restriction>\n");
        out.write("    </xsd:simpleType>\n");
        out.write("    <xsd:simpleType name=\"dimension\">\n");
        out.write("        <xsd:annotation>The dimension alignment attribute type</xsd:annotation>\n");
        out.write("        <xsd:restriction base=\"xsd:string\">\n");
        out.write("            <xsd:pattern value=\"-?[0-9]+\\.?[0-9]+(\\p\\t)?\"/>\n");
        out.write("        </xsd:restriction>\n");
        out.write("    </xsd:simpleType>\n");
        out.write("    <xsd:simpleType name=\"hAlign\">\n");
        out.write("        <xsd:annotation>The horizontal alignment attribute type</xsd:annotation>\n");
        out.write("        <xsd:restriction base=\"xsd:string\">\n");
        out.write("            <xsd:enumeration value=\"left\"/>\n");
        out.write("            <xsd:enumeration value=\"right\"/>\n");
        out.write("            <xsd:enumeration value=\"center\"/>\n");
        out.write("        </xsd:restriction>\n");
        out.write("    </xsd:simpleType>\n");
        out.write("    <xsd:simpleType name=\"vAlign\">\n");
        out.write("        <xsd:annotation>The vertical alignment attribute type</xsd:annotation>\n");
        out.write("        <xsd:restriction base=\"xsd:string\">\n");
        out.write("            <xsd:enumeration value=\"top\"/>\n");
        out.write("            <xsd:enumeration value=\"bottom\"/>\n");
        out.write("            <xsd:enumeration value=\"middle\"/>\n");
        out.write("            <xsd:enumeration value=\"baseline\"/>\n");
        out.write("        </xsd:restriction>\n");
        out.write("    </xsd:simpleType>\n");
        out.write("    <xsd:simpleType name=\"fontFamily\">\n");
        out.write("        <xsd:annotation>The supported font families</xsd:annotation>\n");
        out.write("        <xsd:restriction base=\"xsd:string\"/>\n");
        out.write("    </xsd:simpleType>\n");
        out.write("    <xsd:simpleType name=\"fontStyle\">\n");
        out.write("        <xsd:annotation>The font style attribute type</xsd:annotation>\n");
        out.write("        <xsd:restriction base=\"xsd:string\">\n");
        out.write("            <xsd:pattern value=\"normal|(bold|italic|underline|line-through)(\\|(bold|italic|underline|line-through))*\"/>\n");
        out.write("        </xsd:restriction>\n");
        out.write("    </xsd:simpleType>\n");
        out.write("    <!-- specifying the item types -->\n");
        try {
            List allPossibleChilds = this.tagFactory.getAllPossibleChilds();
            Map tagMap = this.tagFactory.getTagTypes();
            Iterator typeIter = tagMap.entrySet().iterator();
            while (typeIter.hasNext()) {
                Map.Entry typeEntry = typeIter.next();
                TagBuilder builder = (TagBuilder)typeEntry.getValue();
                BaseDocumentTag tag = builder.createTag(null);
                this.printType(out, tag, allPossibleChilds);
                typeIter.remove();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        out.write("</xsd:schema>\n");
        out.flush();
    }

    private void printType(Writer out, BaseDocumentTag tag, List allPossibleChilds) throws IOException {
        int numPossibleChilds = allPossibleChilds.size();
        ChildDefinitionMap supportedChilds = tag.buildSupportedChilds();
        AttributeDefinitionMap supportedAttributes = tag.buildSupportedAttributes();
        if (tag.isVirtualContainer() || supportedChilds != null && supportedChilds.size() > 0 || !CollectionUtils.isEmpty(supportedAttributes)) {
            out.write("\t<xsd:element name=\"" + tag.getName() + "\">\n");
            out.write("\t\t<xsd:complexType>\n");
            if (tag.isVirtualContainer()) {
                out.write("\t\t\t<xsd:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n");
                for (int i = 0; i < numPossibleChilds; ++i) {
                    BaseDocumentTag childTag = (BaseDocumentTag)allPossibleChilds.get(i);
                    if (childTag.isDocumentRoot()) continue;
                    out.write("\t\t\t\t<xsd:element ref=\"this:" + childTag.getName() + "\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n");
                }
                out.write("\t\t\t</xsd:choice>\n");
            } else if (supportedChilds != null && supportedChilds.size() > 0) {
                out.write("\t\t\t<xsd:choice minOccurs=\"0\" maxOccurs=\"unbounded\">\n");
                HashMap<String, ChildDefinition> childMap = new HashMap<String, ChildDefinition>();
                int numSupportedChilds = supportedChilds.size();
                List supportedChildList = supportedChilds.getSortedChilds();
                for (int i = 0; i < numSupportedChilds; ++i) {
                    ChildDefinition child = (ChildDefinition)supportedChildList.get(i);
                    Class childType = child.getType();
                    for (int j = 0; j < numPossibleChilds; ++j) {
                        BaseDocumentTag childTag = (BaseDocumentTag)allPossibleChilds.get(j);
                        if (!childType.isInstance(childTag)) continue;
                        childMap.put(childTag.getName(), child);
                    }
                }
                Iterator iterChilds = childMap.entrySet().iterator();
                while (iterChilds.hasNext()) {
                    Map.Entry entry = iterChilds.next();
                    String name = (String)entry.getKey();
                    ChildDefinition child = (ChildDefinition)entry.getValue();
                    String maxOccurs = null;
                    maxOccurs = child.getMaxOccurrences() == 999 ? "unbounded" : Integer.toString(child.getMaxOccurrences());
                    out.write("\t\t\t\t<xsd:element ref=\"this:" + name + "\" minOccurs=\"" + child.getMinOccurrences() + "\" maxOccurs=\"" + maxOccurs + "\"/>\n");
                }
                out.write("\t\t\t</xsd:choice>\n");
            }
            if (!CollectionUtils.isEmpty(supportedAttributes)) {
                String aliasName = null;
                List attributes = supportedAttributes.getSortedAttributes();
                int numSortedAttributes = supportedAttributes.size();
                for (int i = 0; i < numSortedAttributes; ++i) {
                    AttributeDefinition attribute = (AttributeDefinition)attributes.get(i);
                    int numAliases = 0;
                    Iterator iterLocalAliases = attribute.getAliases().iterator();
                    while (iterLocalAliases.hasNext()) {
                        aliasName = iterLocalAliases.next().toString();
                        ++numAliases;
                        this.writeAttribute(out, aliasName, attribute.getType(), false);
                    }
                    this.writeAttribute(out, attribute.getName(), attribute.getType(), attribute.isRequired() && numAliases == 0);
                }
            }
            out.write("\t\t</xsd:complexType>\n");
            out.write("\t</xsd:element>\n");
        } else {
            out.write("\t<xsd:element name=\"" + tag.getName() + "\"/>\n");
        }
    }

    private void writeAttribute(Writer out, String name, int type, boolean required) throws IOException {
        String useType = null;
        useType = required ? "required" : "optional";
        out.write("\t\t\t<xsd:attribute name=\"" + name + "\" type=\"" + XmlSchemaGenerator.attributeTypeToSchemaType(type) + "\" use=\"" + useType + "\"/>\n");
    }

    protected static String attributeTypeToSchemaType(int attributeType) {
        switch (attributeType) {
            case 3: {
                return "xsd:boolean";
            }
            case 6: {
                return "this:borderStyle";
            }
            case 5: {
                return "this:color";
            }
            case 2: {
                return "xsd:float";
            }
            case 14: {
                return "this:hAlign";
            }
            case 10: {
                return "this:fontFamily";
            }
            case 11: {
                return "this:fontStyle";
            }
            case 7: {
                return "this:hAlign";
            }
            case 8: {
                return "this:vAlign";
            }
            case 1: {
                return "xsd:integer";
            }
            case 9: {
                return "this:pageSize";
            }
            case 4: {
                return "xsd:string";
            }
            case 12: {
                return "xsd:NMTOKEN";
            }
            case 13: {
                return "xsd:string";
            }
        }
        return "unsupported";
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.err.println("usage: org.ujac.print.XmlSchemaGenerator [<output file>]");
            System.exit(1);
        }
        try {
            OutputStreamWriter writer = null;
            DocumentTagFactory tagFactory = null;
            if (args.length < 1) {
                writer = new OutputStreamWriter(System.out);
                tagFactory = new DocumentPrinter().getTagFactory();
            } else {
                writer = new FileWriter(args[0]);
                tagFactory = args.length > 1 ? (DocumentTagFactory)Class.forName(args[1]).newInstance() : new DocumentPrinter().getTagFactory();
            }
            XmlSchemaGenerator xg = new XmlSchemaGenerator(tagFactory);
            xg.generateXmlSchema(writer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

