/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BarcodePDF417;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.PhraseHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.util.exi.ExpressionException;

public class BarcodePdf417Tag
extends BaseElementTag {
    private static final AttributeDefinition OPTIONS_TYPE = new AttributeDefinition("options", new String[]{"USE_ASPECT_RATIO", "FIXED_RECTANGLE", "FIXED_COLUMNS", "FIXED_ROWS", "AUTO_ERROR_LEVEL", "USE_ERROR_LEVEL", "FORCE_BINARY", "INVERT_BITMAP", "USE_MACRO"}, false, "The encodation type.");
    private static final AttributeDefinition ASPECT_RATIO = new AttributeDefinition("aspect-ratio", 2, false, "The barcode aspect ratio.");
    private static final AttributeDefinition CODE_COLUMNS = new AttributeDefinition("code-columns", 1, false, "The number of barcode data columns.");
    private static final AttributeDefinition CODE_ROWS = new AttributeDefinition("code-rows", 1, false, "The number of barcode data rows.");
    private static final AttributeDefinition ERROR_LEVEL = new AttributeDefinition("error-level", 1, false, "The error level correction used for the barcode.");
    private static final AttributeDefinition LEN_CODEWORDS = new AttributeDefinition("len-codewords", 1, false, "The length of the codewords.");
    private static final AttributeDefinition MACRO_FILE_ID = new AttributeDefinition("macro-file-id", 1, false, "The File ID for macro PDF417 encoding.");
    private static final AttributeDefinition MACRO_SEGMENT_COUNT = new AttributeDefinition("macro-segment-count", 1, false, "The segment count for macro PDF417 encoding.");
    private static final AttributeDefinition Y_HEIGHT = new AttributeDefinition("y-height", 2, false, "The Y pixel height relative to X. This is usually 3.");
    public static final String TAG_NAME = "barcode-pdf-417";
    private static Map barcodeTypes = null;
    private PhraseHolder phraseHolder = null;
    private int options = 0;
    private float aspectRatio = 0.0f;
    private int codeColumns = 0;
    private int codeRows = 0;
    private int errorLevel = 0;
    private int lenCodewords = 0;
    private String marcoFileId = null;
    private int macroSegmentCount = 1;
    private int macroSegmentId = 0;
    private String text = null;
    private float yHeight = 3.0f;
    private float width = 0.0f;
    private float height = 0.0f;

    public BarcodePdf417Tag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Prints a 2d PDF barcode (PDF-417). The tag content defines the text, that will form the barcode.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(OPTIONS_TYPE).addDefinition(ASPECT_RATIO).addDefinition(CODE_COLUMNS).addDefinition(CODE_ROWS).addDefinition(ERROR_LEVEL).addDefinition(LEN_CODEWORDS).addDefinition(MACRO_FILE_ID).addDefinition(MACRO_SEGMENT_COUNT).addDefinition(Y_HEIGHT).addDefinition(CommonAttributes.IMAGE_WIDTH).addDefinition(CommonAttributes.IMAGE_HEIGHT);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.phraseHolder = this.documentHandler.latestPhraseHolder();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        String optionsStr = this.getStringAttribute(OPTIONS_TYPE, true, null);
        if (optionsStr != null) {
            StringTokenizer optionTkn = new StringTokenizer(optionsStr, "|");
            while (optionTkn.hasMoreTokens()) {
                String strOption = optionTkn.nextToken();
                Integer option = (Integer)barcodeTypes.get(strOption);
                if (option == null) {
                    throw new TagAttributeException(this.locator(), "Unsupported option '" + strOption + "', supported options are: " + "USE_ASPECT_RATIO, FIXED_RECTANGLE, FIXED_COLUMNS, FIXED_ROWS, AUTO_ERROR_LEVEL, USE_ERROR_LEVEL, " + "FORCE_BINARY, INVERT_BITMAP, USE_MACRO.");
                }
                this.options |= option.intValue();
            }
        }
        this.aspectRatio = this.getFloatAttribute(ASPECT_RATIO, true, null);
        this.codeColumns = this.getIntegerAttribute(CODE_COLUMNS, true, null);
        this.codeRows = this.getIntegerAttribute(CODE_ROWS, true, null);
        this.errorLevel = this.getIntegerAttribute(ERROR_LEVEL, true, null);
        this.lenCodewords = this.getIntegerAttribute(LEN_CODEWORDS, true, null);
        this.marcoFileId = this.getStringAttribute(MACRO_FILE_ID, true, null);
        this.macroSegmentCount = this.getIntegerAttribute(MACRO_SEGMENT_COUNT, true, null);
        this.yHeight = this.getFloatAttribute(Y_HEIGHT, true, null);
        this.width = this.getDimensionAttribute(CommonAttributes.IMAGE_WIDTH, true, CommonStyleAttributes.IMAGE_WIDTH);
        this.height = this.getDimensionAttribute(CommonAttributes.IMAGE_HEIGHT, true, CommonStyleAttributes.IMAGE_HEIGHT);
        this.text = null;
        try {
            this.text = this.documentHandler.evalString(this.getTrimmedContent());
        }
        catch (ExpressionException ex) {
            throw new DocumentHandlerException(this.locator(), "Content evaluation failed: " + ex.getMessage(), ex);
        }
        ElementContainer elementContainer = this.getElementContainer();
        try {
            BarcodePDF417 pdf417 = new BarcodePDF417();
            pdf417.setOptions(this.options);
            pdf417.setAspectRatio(this.aspectRatio);
            pdf417.setCodeColumns(this.codeColumns);
            pdf417.setCodeRows(this.codeRows);
            pdf417.setErrorLevel(this.errorLevel);
            pdf417.setLenCodewords(this.lenCodewords);
            pdf417.setMacroFileId(this.marcoFileId);
            pdf417.setMacroSegmentId(this.macroSegmentId);
            pdf417.setMacroSegmentCount(this.macroSegmentCount);
            pdf417.setYHeight(this.yHeight);
            pdf417.setText(this.text);
            pdf417.paintCode();
            Image barcodeImage = pdf417.getImage();
            barcodeImage.scaleAbsolute(this.width, this.height);
            if (this.phraseHolder != null) {
                this.phraseHolder.addChunk(this, new Chunk(barcodeImage, 0.0f, 0.0f));
            } else {
                elementContainer.addElement(this, (Element)barcodeImage);
            }
        }
        catch (DocumentHandlerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new TagAttributeException(this.locator(), "Creation of 2D barcode failed: " + ex.getMessage(), ex);
        }
    }

    static {
        barcodeTypes = new HashMap();
        barcodeTypes.put("USE_ASPECT_RATIO", new Integer(0));
        barcodeTypes.put("FIXED_RECTANGLE", new Integer(1));
        barcodeTypes.put("FIXED_COLUMNS", new Integer(2));
        barcodeTypes.put("FIXED_ROWS", new Integer(4));
        barcodeTypes.put("AUTO_ERROR_LEVEL", new Integer(0));
        barcodeTypes.put("USE_ERROR_LEVEL", new Integer(16));
        barcodeTypes.put("FORCE_BINARY", new Integer(32));
        barcodeTypes.put("INVERT_BITMAP", new Integer(128));
        barcodeTypes.put("USE_MACRO", new Integer(256));
    }
}

