/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Phrase;
import java.awt.Color;
import java.util.ArrayList;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.PhraseHolder;
import org.ujac.print.tag.AddRowTag;
import org.ujac.print.tag.AssertTag;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.CellTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.DefineTableTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.HeaderFooterTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImportTag;
import org.ujac.print.tag.IndexTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.NewLineTag;
import org.ujac.print.tag.NewPageTag;
import org.ujac.print.tag.ParagraphTag;
import org.ujac.print.tag.PdfCellTag;
import org.ujac.print.tag.PdfTableHeaderTag;
import org.ujac.print.tag.PdfTableTag;
import org.ujac.print.tag.PhraseTag;
import org.ujac.print.tag.PrintTableTag;
import org.ujac.print.tag.SetPropertyTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.TableTag;
import org.ujac.print.tag.TocTag;
import org.ujac.util.template.TemplateException;

public abstract class BaseFontTag
extends BaseElementTag
implements FontHolder,
PhraseHolder {
    protected PhraseHolder phraseHolder = null;
    protected FontHolder parentFont = null;
    protected DocumentFont font = null;
    protected String fontDef = null;
    protected Color color = null;
    protected String family = "Helvetica";
    protected String encoding = "Cp1252";
    protected float size = 10.0f;
    protected int style = 0;
    protected float textRise = 0.0f;

    public BaseFontTag(String name) {
        super(name);
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.TRIM_BODY);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(PrintTableTag.class, 0, 999)).addDefinition(new ChildDefinition(TocTag.class, 0, 999)).addDefinition(new ChildDefinition(IndexTag.class, 0, 999)).addDefinition(new ChildDefinition(CellTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfCellTag.class, 0, 999)).addDefinition(new ChildDefinition(TableTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfTableTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfTableHeaderTag.class, 0, 999)).addDefinition(new ChildDefinition(PhraseTag.class, 0, 999)).addDefinition(new ChildDefinition(ParagraphTag.class, 0, 999)).addDefinition(new ChildDefinition(HeaderFooterTag.class, 0, 999)).addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(NewLineTag.class, 0, 999)).addDefinition(new ChildDefinition(NewPageTag.class, 0, 999)).addDefinition(new ChildDefinition(SetPropertyTag.class, 0, 999)).addDefinition(new ChildDefinition(DefineTableTag.class, 0, 999)).addDefinition(new ChildDefinition(AddRowTag.class, 0, 999)).addDefinition(new ChildDefinition(AssertTag.class, 0, 999)).addDefinition(new ChildDefinition(ImportTag.class, 0, 999));
    }

    public boolean isVirtualContainer() {
        return true;
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.phraseHolder = this.documentHandler.latestPhraseHolder();
        this.parentFont = this.documentHandler.latestFontHolder();
    }

    public void openItem() throws DocumentHandlerException {
        DocumentFont font;
        super.openItem();
        if (this.parentFont != null && (font = this.parentFont.getFont()) != null) {
            this.family = font.getFamily();
            this.encoding = font.getEncoding();
            this.size = font.getSize();
            this.style = font.getStyle();
            this.textRise = font.getTextRise();
            this.color = font.getColor();
        }
        this.setTrimBody(this.getBooleanAttribute(CommonAttributes.TRIM_BODY, false, true, null));
    }

    public void closeItem() throws DocumentHandlerException {
        String content;
        if (!this.isValid()) {
            return;
        }
        if (this.phraseHolder != null && (content = this.getTrimmedContent()).length() > 0) {
            try {
                Color bgColor;
                Chunk chunk = new Chunk(this.documentHandler.executeTemplate(content), this.getFont().getFont());
                if (this.textRise != 0.0f) {
                    chunk.setTextRise(this.textRise);
                }
                if ((bgColor = this.getBackgroundColor()) != null) {
                    chunk.setBackground(bgColor);
                }
                this.phraseHolder.addChunk(this, chunk);
            }
            catch (TemplateException ex) {
                throw new DocumentHandlerException(this.locator(), "Content evaluation failed: " + ex.getMessage(), ex);
            }
        }
    }

    protected void createFont() throws DocumentHandlerException {
        this.font = this.createFont(this.family, this.encoding, this.size, this.style, this.textRise, this.color);
    }

    public DocumentFont getFont() {
        return this.font;
    }

    public void flushContent() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.isEmptyContent()) {
            this.resetContent();
            return;
        }
        if (this.isTrimNextHead()) {
            this.trimContentHead();
            this.setTrimNextHead(false);
        }
        if (this.isItemClosed() && this.isTrimBody()) {
            this.trimContentTail();
        }
        if (this.phraseHolder != null) {
            Phrase contents = this.processContents(this.getLeading(), this.getLineSpacing());
            this.applyTextRiseAndAddToPhraseHolder(contents, this.textRise != 0.0f);
        }
        this.resetContent();
    }

    private void applyTextRiseAndAddToPhraseHolder(Phrase phrase, boolean setTextRise) throws DocumentHandlerException {
        if (phrase == null) {
            return;
        }
        int contentSize = phrase.size();
        for (int i = 0; i < contentSize; ++i) {
            Object item = phrase.get(i);
            if (item instanceof Phrase) {
                this.applyTextRiseAndAddToPhraseHolder((Phrase)item, setTextRise);
                continue;
            }
            Chunk chunk = (Chunk)item;
            chunk.setTextRise(this.textRise);
            Color bgColor = this.getBackgroundColor();
            if (bgColor != null) {
                chunk.setBackground(bgColor);
            }
            this.phraseHolder.addChunk(this, chunk);
        }
    }

    public void addChunk(BaseDocumentTag item, String chunk, DocumentFont font) throws DocumentHandlerException {
        if (this.phraseHolder != null) {
            Phrase contents = this.addChunk(item, null, chunk, font, this.getLeading(), this.getLineSpacing());
            this.applyTextRiseAndAddToPhraseHolder(contents, this.textRise != 0.0f);
        }
    }

    public void addChunk(BaseDocumentTag item, Chunk chunk) throws DocumentHandlerException {
        if (this.phraseHolder != null) {
            Color bgColor;
            if (this.textRise != 0.0f) {
                chunk.setTextRise(this.textRise);
            }
            if ((bgColor = this.getBackgroundColor()) != null) {
                chunk.setBackground(bgColor);
            }
            this.phraseHolder.addChunk(this, chunk);
        }
    }

    public float getLeading() {
        if (this.phraseHolder == null) {
            return 0.0f;
        }
        return this.phraseHolder.getLeading();
    }

    public float getLineSpacing() {
        if (this.phraseHolder == null) {
            ElementContainer elementContainer = this.getElementContainer();
            if (elementContainer == null) {
                return 1.2f;
            }
            return elementContainer.getLineSpacing();
        }
        return this.phraseHolder.getLineSpacing();
    }

    protected void setTextRise(Phrase item) {
        ArrayList chunks = item.getChunks();
        int numChunks = chunks.size();
        for (int i = 0; i < numChunks; ++i) {
            Chunk chunk = (Chunk)chunks.get(i);
            chunk.setTextRise(this.textRise);
        }
    }
}

