/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.DocumentException;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.ImageBuilder;
import org.ujac.print.tag.PdfImageBuilder;
import org.ujac.print.tag.RasterImageBuilder;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.io.FileUtils;

public abstract class BaseImageTag
extends BaseElementTag {
    protected static ImageBuilder[] IMAGE_BUILDERS = null;
    protected String sourceAttr = null;
    protected String pageAttr = null;
    protected float width = 0.0f;
    protected float height = 0.0f;
    protected byte[] imageData = null;

    public BaseImageTag(String name) {
        super(name);
    }

    public com.lowagie.text.Image getImage() throws DocumentHandlerException {
        try {
            com.lowagie.text.Image img;
            Object imageSource = null;
            try {
                imageSource = this.documentHandler.evalObject(this.sourceAttr);
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
            }
            this.imageData = null;
            String path = null;
            if (imageSource instanceof String) {
                com.lowagie.text.Image img2;
                String location = (String)imageSource;
                int lastSlash = location.lastIndexOf(47);
                if (lastSlash >= 0) {
                    path = location.substring(0, lastSlash + 1);
                }
                if ((img2 = this.documentHandler.getCachedImage(imageSource)) != null) {
                    return img2;
                }
                this.imageData = this.documentHandler.loadResource(location);
            } else if (imageSource instanceof File) {
                path = ((File)imageSource).getAbsolutePath();
                img = this.documentHandler.getCachedImage(imageSource);
                if (img != null) {
                    return img;
                }
                this.imageData = FileUtils.loadFile((File)imageSource);
            } else if (imageSource instanceof byte[]) {
                path = new String((byte[])imageSource);
                img = this.documentHandler.getCachedImage(imageSource);
                if (img != null) {
                    return img;
                }
                this.imageData = (byte[])imageSource;
            } else {
                if (imageSource instanceof Image) {
                    path = new String(((Image)imageSource).toString());
                    com.lowagie.text.Image img3 = this.documentHandler.getCachedImage(imageSource);
                    if (img3 != null) {
                        return img3;
                    }
                    img3 = com.lowagie.text.Image.getInstance((Image)((Image)imageSource), null);
                    this.documentHandler.cacheImage(imageSource, img3);
                    return img3;
                }
                if (imageSource instanceof com.lowagie.text.Image) {
                    com.lowagie.text.Image img4 = (com.lowagie.text.Image)imageSource;
                    com.lowagie.text.Image cachedImg = this.documentHandler.getCachedImage("IMAGE_" + img4.getMySerialId());
                    if (cachedImg != null) {
                        return cachedImg;
                    }
                    this.documentHandler.cacheImage(imageSource, img4);
                    return img4;
                }
            }
            if (this.imageData != null) {
                int page = 1;
                if (this.pageAttr != null) {
                    try {
                        page = Integer.parseInt(this.pageAttr);
                    }
                    catch (NumberFormatException ex) {
                        throw new TagAttributeException(this.locator(), "Invalid value '" + this.pageAttr + "' for attribute 'page' at tag " + this.getName() + ".");
                    }
                }
                for (int i = 0; i < IMAGE_BUILDERS.length; ++i) {
                    ImageBuilder builder = IMAGE_BUILDERS[i];
                    if (!builder.checkFormat(this.imageData)) continue;
                    com.lowagie.text.Image img5 = builder.buildImage(this.documentHandler, this.imageData, path, this.width, this.height, page);
                    this.documentHandler.cacheImage(imageSource, img5);
                    return img5;
                }
            }
            throw new DocumentHandlerException(this.locator(), "No valid builder detected for image '" + this.sourceAttr + "'.");
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to build image: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to load image: " + ex.getMessage(), ex);
        }
    }

    static {
        ArrayList<ImageBuilder> builders = new ArrayList<ImageBuilder>();
        builders.add(new PdfImageBuilder());
        try {
            builders.add((ImageBuilder)Class.forName("org.ujac.print.tag.SvgImageBuilder").newInstance());
        }
        catch (Throwable ex) {
            // empty catch block
        }
        builders.add(new RasterImageBuilder());
        int numBuilders = builders.size();
        IMAGE_BUILDERS = new ImageBuilder[numBuilders];
        for (int i = 0; i < numBuilders; ++i) {
            BaseImageTag.IMAGE_BUILDERS[i] = (ImageBuilder)builders.get(i);
        }
    }
}

