/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentPageEventHandler;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.PagePosition;
import org.ujac.print.PhraseHolder;
import org.ujac.print.tag.BaseCellTag;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.StickyTag;

public class BoxTag
extends BaseCellTag
implements PhraseHolder,
FontHolder,
ElementContainer {
    public static final String TAG_NAME = "box";
    private static final AttributeDefinition BOX_ROTATE = CommonAttributes.ROTATE.cloneAttrDef("The rotation angle of the box.");
    private static final AttributeDefinition BOX_ROTATE_STYLE = CommonStyleAttributes.ROTATE.cloneAttrDef("The rotation angle of the box.");
    private ElementContainer elementContainer = null;
    private PagePosition pos = null;
    private float width;
    private float height;
    private float angle;
    private StickyTag stickyTag = null;

    public BoxTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Places a text box at a fix position on the current page.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.BOX_X).addDefinition(CommonAttributes.BOX_Y).addDefinition(CommonAttributes.BOX_WIDTH).addDefinition(CommonAttributes.BOX_HEIGHT).addDefinition(BOX_ROTATE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.BOX_X).addDefinition(CommonStyleAttributes.BOX_Y).addDefinition(CommonStyleAttributes.BOX_WIDTH).addDefinition(CommonAttributes.BOX_HEIGHT).addDefinition(BOX_ROTATE_STYLE);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds();
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.elementContainer = this.documentHandler.latestElementContainer();
        this.stickyTag = (StickyTag)this.documentHandler.latestOfType("sticky");
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.pos = new PagePosition(this.getDimensionAttribute(CommonAttributes.BOX_X, 0.0f, true, CommonStyleAttributes.BOX_X), this.getDimensionAttribute(CommonAttributes.BOX_Y, 0.0f, true, CommonStyleAttributes.BOX_Y));
        this.width = this.getDimensionAttribute(CommonAttributes.BOX_WIDTH, true, CommonStyleAttributes.BOX_WIDTH);
        this.height = this.getDimensionAttribute(CommonAttributes.BOX_HEIGHT, true, CommonStyleAttributes.BOX_HEIGHT);
        this.angle = this.getFloatAttribute(CommonAttributes.ROTATE, 0.0f, true, CommonStyleAttributes.ROTATE);
    }

    protected CellAttributes getParentAttributes() {
        return null;
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        super.closeItem();
        PdfWriter writer = (PdfWriter)this.documentHandler.getDocumentWriter();
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        PdfTemplate template = cb.createTemplate(this.width, this.height);
        PdfPTable table = new PdfPTable(1);
        table.setWidthPercentage(100.0f);
        table.setTotalWidth(this.width);
        PdfPCell cell = this.getCell();
        if (cell == null) {
            cell = this.buildCell();
        }
        cell.setFixedHeight(this.height);
        table.addCell(cell);
        table.writeSelectedRows(0, 1, 0.0f, this.height, (PdfContentByte)template);
        cb.restoreState();
        Image img = null;
        try {
            img = Image.getInstance((PdfTemplate)template);
            if (this.angle != 0.0f) {
                img.setRotation((float)Math.PI * this.angle / 180.0f);
            }
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to write box: " + ex.getMessage(), ex);
        }
        if (this.stickyTag != null) {
            this.stickyTag.addStickyElementHandler(new BoxPageEventHandler(img));
        } else {
            this.insertImage((PdfWriter)this.documentHandler.getDocumentWriter(), this.documentHandler.getDocument(), img);
        }
    }

    protected void insertImage(PdfWriter writer, Document document, Image image) {
        try {
            Rectangle pageSize = document.getPageSize();
            float x = this.pos.calcX(pageSize.getRight(), image.getScaledWidth());
            float y = this.pos.calcY(pageSize.getTop(), image.getScaledHeight());
            image.setAbsolutePosition(x, y);
            PdfContentByte cb = writer.getDirectContent();
            cb.addImage(image);
        }
        catch (DocumentException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    public float getLineSpacing() {
        ElementContainer elementContainer = this.getElementContainer();
        return elementContainer.getLineSpacing();
    }

    public ElementContainer getElementContainer() {
        if (this.elementContainer == null) {
            this.elementContainer = this.documentHandler.latestElementContainer();
        }
        return this.elementContainer;
    }

    class BoxPageEventHandler
    extends DocumentPageEventHandler {
        private Image image = null;

        public BoxPageEventHandler(Image image) {
            this.image = image;
        }

        public void onEndPage(PdfWriter writer, Document document) {
            BoxTag.this.insertImage(writer, document, this.image);
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
        }

        public boolean isTemporary() {
            return false;
        }
    }
}

