/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Image;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ujac.chart.Chart;
import org.ujac.chart.ChartAttributeDefinition;
import org.ujac.chart.ChartAttributes;
import org.ujac.chart.ChartException;
import org.ujac.chart.ChartFactory;
import org.ujac.chart.TextChartItem;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.AttributeHandler;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ParameterDefinition;
import org.ujac.print.ParameterHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.ParameterTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.TextChartItemTag;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.table.TypeMismatchException;

public class ChartTag
extends ImageTag
implements ParameterHolder {
    public static final String TAG_NAME = "chart";
    private static final Class[] iteratorAttributes = new Class[0];
    private static final Object[] iteratorParameters = new Object[0];
    private String titleAttr = null;
    private String titleFontAttr = null;
    private String type = null;
    private float padding = 0.0f;
    private float paddingLeft = 0.0f;
    private float paddingRight = 0.0f;
    private float paddingTop = 0.0f;
    private float paddingBottom = 1.0f;
    private Object valuesAttr = null;
    private Double minValueAttr = null;
    private Double maxValueAttr = null;
    private Object valueFieldsAttr = null;
    private Object segmentLabelsAttr = null;
    private Object segmentFieldAttr = null;
    private Object areaLabelsAttr = null;
    private Object areaFieldAttr = null;
    private TextChartItem titleItem = null;
    private TextChartItem valueScaleDescriptionItem = null;
    private TextChartItem segmentScaleDescriptionItem = null;
    private Map chartAttributeDefinitions = null;
    private Chart chart = null;
    private ChartAttributes chartAttributes = null;
    private boolean externalInstance = false;

    public ChartTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Places a chart into the document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CHART_TITLE).addDefinition(CommonAttributes.CHART_TITLE_FONT).addDefinition(CommonAttributes.CHART_TYPE).addDefinition(CommonAttributes.CHART_INSTANCE).addDefinition(CommonAttributes.PADDING).addDefinition(CommonAttributes.PADDING_LEFT).addDefinition(CommonAttributes.PADDING_RIGHT).addDefinition(CommonAttributes.PADDING_TOP).addDefinition(CommonAttributes.PADDING_BOTTOM).removeDefinition(CommonAttributes.IMAGE_SOURCE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.CHART_TITLE_FONT).addDefinition(CommonStyleAttributes.CHART_TYPE).addDefinition(CommonStyleAttributes.PADDING).addDefinition(CommonStyleAttributes.PADDING_LEFT).addDefinition(CommonStyleAttributes.PADDING_RIGHT).addDefinition(CommonStyleAttributes.PADDING_TOP).addDefinition(CommonStyleAttributes.PADDING_BOTTOM).removeDefinition(CommonStyleAttributes.IMAGE_SOURCE);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(ParameterTag.class, 0, 999)).addDefinition(new ChildDefinition(TextChartItemTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999));
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        try {
            this.chart = (Chart)this.evalAttribute(CommonAttributes.CHART_INSTANCE);
        }
        catch (ClassCastException ex) {
            throw new TagAttributeException(this.locator(), "The expression '" + this.getStringAttribute(CommonAttributes.CHART_INSTANCE, false, null) + "' doesn't resolve to a Chart instance.");
        }
        this.externalInstance = this.chart != null;
        this.titleAttr = this.getTextAttribute(CommonAttributes.CHART_TITLE, false, null);
        this.titleFontAttr = this.getStringAttribute(CommonAttributes.CHART_TITLE_FONT, true, CommonStyleAttributes.CHART_TITLE_FONT);
        this.type = this.getStringAttribute(CommonAttributes.CHART_TYPE, false, CommonStyleAttributes.CHART_TYPE);
        AttributeHandler attrHandler = this.documentHandler.getAttributeHandler();
        Object attrVal = this.getAttribute(CommonAttributes.PADDING, true, CommonStyleAttributes.PADDING, attrHandler.getFloatHandler());
        if (attrVal != null) {
            float padding;
            this.paddingLeft = padding = ((Number)attrVal).floatValue();
            this.paddingRight = padding;
            this.paddingTop = padding;
            this.paddingBottom = padding;
        }
        if ((attrVal = this.getAttribute(CommonAttributes.PADDING_LEFT, true, CommonStyleAttributes.PADDING_LEFT, attrHandler.getFloatHandler())) != null) {
            this.paddingLeft = ((Number)attrVal).floatValue();
        }
        if ((attrVal = this.getAttribute(CommonAttributes.PADDING_RIGHT, true, CommonStyleAttributes.PADDING_RIGHT, attrHandler.getFloatHandler())) != null) {
            this.paddingRight = ((Number)attrVal).floatValue();
        }
        if ((attrVal = this.getAttribute(CommonAttributes.PADDING_TOP, true, CommonStyleAttributes.PADDING_TOP, attrHandler.getFloatHandler())) != null) {
            this.paddingTop = ((Number)attrVal).floatValue();
        }
        if ((attrVal = this.getAttribute(CommonAttributes.PADDING_BOTTOM, true, CommonStyleAttributes.PADDING_BOTTOM, attrHandler.getFloatHandler())) != null) {
            this.paddingBottom = ((Number)attrVal).floatValue();
        }
        if (!this.externalInstance) {
            try {
                if (this.type == null) {
                    throw new TagAttributeException(this.locator(), "No chart type and no external instance was given, unable to render chart.");
                }
                String chartType = null;
                try {
                    chartType = this.documentHandler.evalString(this.type).toLowerCase();
                }
                catch (ExpressionException ex) {
                    throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
                }
                this.chart = ChartFactory.createChart(chartType);
                this.chartAttributes = new ChartAttributes();
                List supportedChartAttributes = this.chart.getSupportedAttributes();
                int numSupportedChartAttributes = supportedChartAttributes.size();
                this.chartAttributeDefinitions = new HashMap();
                this.chartAttributeDefinitions.put("values", new ParameterDefinition("values", 6, true, false, null));
                this.chartAttributeDefinitions.put("min-value", new ParameterDefinition("min-value", 6, false, true, null));
                this.chartAttributeDefinitions.put("max-value", new ParameterDefinition("max-value", 6, false, true, null));
                this.chartAttributeDefinitions.put("value-fields", new ParameterDefinition("value-fields", 1, true, false, null));
                this.chartAttributeDefinitions.put("segment-field", new ParameterDefinition("segment-field", 1, false, false, null));
                for (int i = 0; i < numSupportedChartAttributes; ++i) {
                    ChartAttributeDefinition cad = (ChartAttributeDefinition)supportedChartAttributes.get(i);
                    this.chartAttributeDefinitions.put(cad.getName(), new ParameterDefinition(cad.getName(), this.chartAttributeTypeToParameterType(cad), cad.isList(), cad.isOptional(), null));
                }
            }
            catch (ChartException ex) {
                throw new DocumentHandlerException(this.locator(), "Unable to create chart: " + ex.getMessage(), ex);
            }
        }
    }

    private int chartAttributeTypeToParameterType(ChartAttributeDefinition chartAttributeDef) {
        switch (chartAttributeDef.getType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                return chartAttributeDef.getType();
            }
            case 22: {
                return 22;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
        }
        return 11;
    }

    /*
     * Exception decompiling
     */
    public Image getImage() throws DocumentHandlerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List getChartValues() throws DocumentHandlerException {
        ArrayList<double[]> chartData = new ArrayList<double[]>();
        Iterator iter = this.getValuesIterator();
        Object first = iter.next();
        if (first instanceof Row) {
            Row row = (Row)first;
            Table table = row.getTable();
            if (this.valueFieldsAttr == null) {
                throw new TagAttributeException(this.locator(), "The attribute 'value-fields' at item 'chart' must be specified for table values.");
            }
            ArrayList<String> valueFieldNames = null;
            if (this.valueFieldsAttr instanceof List) {
                valueFieldNames = (ArrayList<String>)this.valueFieldsAttr;
            } else {
                valueFieldNames = new ArrayList<String>();
                valueFieldNames.add(this.valueFieldsAttr.toString());
            }
            int[] colIndices = new int[valueFieldNames.size()];
            int idx = 0;
            for (int i = 0; i < colIndices.length; ++i) {
                String colName = (String)valueFieldNames.get(i);
                Column col = null;
                try {
                    col = table.getColumn(colName);
                }
                catch (ColumnNotDefinedException ex) {
                    try {
                        int colIdx = Integer.parseInt(colName);
                        col = table.getColumn(colIdx);
                    }
                    catch (ColumnNotDefinedException cndex) {
                        throw new TagAttributeException(this.locator(), "The value '" + colName + "' from attribute 'value-fields' is no valid column index within table '" + this.valuesAttr + "'.", ex);
                    }
                    catch (NumberFormatException nfex) {
                        throw new TagAttributeException(this.locator(), "The value '" + colName + "' from attribute 'value-fields' is no valid column within table '" + this.valuesAttr + "'.", ex);
                    }
                }
                colIndices[idx] = col.getIndex();
                ++idx;
            }
            int numColumns = colIndices.length;
            while (row != null) {
                double[] valueRow = new double[numColumns];
                for (int i = 0; i < numColumns; ++i) {
                    int colIdx = colIndices[i];
                    try {
                        valueRow[i] = row.getDouble(colIdx);
                        continue;
                    }
                    catch (ColumnNotDefinedException cndex) {
                        throw new TagAttributeException(this.locator(), cndex.getMessage(), cndex);
                    }
                    catch (TypeMismatchException tmex) {
                        throw new TagAttributeException(this.locator(), tmex.getMessage(), tmex);
                    }
                }
                chartData.add(valueRow);
                row = null;
                if (!iter.hasNext()) continue;
                row = (Row)iter.next();
            }
        } else if (first instanceof Number) {
            Number number = (Number)first;
            while (number != null) {
                double[] valueRow = new double[]{number.doubleValue()};
                chartData.add(valueRow);
                number = null;
                if (!iter.hasNext()) continue;
                number = (Number)iter.next();
            }
        } else if (first instanceof Number[]) {
            Number[] numbers = (Number[])first;
            while (numbers != null) {
                double[] valueRow = new double[numbers.length];
                for (int i = 0; i < numbers.length; ++i) {
                    if (numbers[i] == null) continue;
                    valueRow[i] = numbers[i].doubleValue();
                }
                chartData.add(valueRow);
                numbers = null;
                if (!iter.hasNext()) continue;
                numbers = (Number[])iter.next();
            }
        } else if (first instanceof double[]) {
            double[] numbers = (double[])first;
            while (numbers != null) {
                double[] valueRow = numbers;
                chartData.add(valueRow);
                numbers = null;
                if (!iter.hasNext()) continue;
                numbers = (double[])iter.next();
            }
        } else if (first instanceof List) {
            List numbers = (List)first;
            while (numbers != null) {
                int numValues = numbers.size();
                double[] valueRow = new double[numValues];
                for (int i = 0; i < numValues; ++i) {
                    valueRow[i] = ((Number)numbers.get(i)).doubleValue();
                }
                chartData.add(valueRow);
                numbers = null;
                if (!iter.hasNext()) continue;
                numbers = (List)iter.next();
            }
        } else if (first instanceof String) {
            String number = (String)first;
            while (number != null) {
                double[] valueRow = new double[]{Double.parseDouble(number)};
                chartData.add(valueRow);
                number = null;
                if (!iter.hasNext()) continue;
                number = (String)iter.next();
            }
        } else {
            Object cur = first;
            if (this.valueFieldsAttr == null) {
                throw new TagAttributeException(this.locator(), "The attribute 'value-fields' at item 'chart' must be specified for bean values.");
            }
            ArrayList<String> valueFieldNames = null;
            if (this.valueFieldsAttr instanceof List) {
                valueFieldNames = (ArrayList<String>)this.valueFieldsAttr;
            } else {
                valueFieldNames = new ArrayList<String>();
                valueFieldNames.add(this.valueFieldsAttr.toString());
            }
            int numValueFields = valueFieldNames.size();
            Method[] getters = new Method[numValueFields];
            Class<?> beanClazz = cur.getClass();
            Class[] getterParams = new Class[]{};
            for (int i = 0; i < numValueFields; ++i) {
                String fieldName = (String)valueFieldNames.get(i);
                Method getter = null;
                try {
                    getter = beanClazz.getMethod("get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1), getterParams);
                }
                catch (NoSuchMethodException ex) {
                    throw new TagAttributeException(this.locator(), "The value '" + fieldName + "' from attribute 'value-fields' is no valid attribute for class '" + beanClazz.getName() + "'.", ex);
                }
                catch (SecurityException ex) {
                    throw new TagAttributeException(this.locator(), "The value '" + fieldName + "' from attribute 'value-fields' is no valid attribute for class '" + beanClazz.getName() + "'.", ex);
                }
                getters[i] = getter;
            }
            Object[] getterArgs = new Object[]{};
            while (cur != null) {
                double[] valueRow = new double[numValueFields];
                for (int i = 0; i < numValueFields; ++i) {
                    Method getter = getters[i];
                    try {
                        valueRow[i] = ((Number)getter.invoke(cur, getterArgs)).doubleValue();
                        continue;
                    }
                    catch (ClassCastException ex) {
                        throw new TagAttributeException(this.locator(), "The value '" + valueFieldNames.get(i) + "' from attribute 'value-fields' is no valid numeric attribute for class '" + cur.getClass().getName() + "'.", ex);
                    }
                    catch (IllegalAccessException ex) {
                        throw new TagAttributeException(this.locator(), "The value '" + valueFieldNames.get(i) + "' from attribute 'value-fields' is not accessible for class '" + cur.getClass().getName() + "'.", ex);
                    }
                    catch (InvocationTargetException ex) {
                        throw new TagAttributeException(this.locator(), "The value '" + valueFieldNames.get(i) + "' from attribute 'value-fields' is not accessible for class '" + cur.getClass().getName() + "'.", ex);
                    }
                }
                chartData.add(valueRow);
                cur = null;
                if (!iter.hasNext()) continue;
                cur = iter.next();
            }
        }
        return chartData;
    }

    private List getAreaLabels() throws DocumentHandlerException {
        String areaFieldName = null;
        if (this.areaFieldAttr != null) {
            areaFieldName = this.areaFieldAttr.toString();
        }
        return this.getLabelList(this.getAreaLabelsIterator(), areaFieldName, "area-field");
    }

    private List getSegmentLabels() throws DocumentHandlerException {
        String segmentFieldName = null;
        if (this.segmentFieldAttr != null) {
            segmentFieldName = this.segmentFieldAttr.toString();
        }
        return this.getLabelList(this.getSegmentLabelsIterator(), segmentFieldName, "segment-field");
    }

    private List getLabelList(Iterator labelIterator, String fieldName, String attrAttrName) throws DocumentHandlerException {
        Iterator iter = labelIterator;
        if (iter == null) {
            return null;
        }
        ArrayList<String> segmentLabels = new ArrayList<String>();
        Object first = iter.next();
        if (first instanceof Row) {
            Row row = (Row)first;
            Table table = row.getTable();
            if (fieldName == null) {
                throw new TagAttributeException(this.locator(), "The attribute '" + attrAttrName + "' at tag 'chart' must be specified for segment-labels.");
            }
            int colIndex = -1;
            Column col = null;
            try {
                col = table.getColumn(fieldName);
            }
            catch (ColumnNotDefinedException ex) {
                try {
                    int colIdx = Integer.parseInt(fieldName);
                    col = table.getColumn(colIdx);
                }
                catch (ColumnNotDefinedException cndex) {
                    throw new TagAttributeException(this.locator(), "The value '" + fieldName + "' from attribute '" + attrAttrName + "' is no valid column index within table '" + this.valuesAttr + "'.", ex);
                }
                catch (NumberFormatException nfex) {
                    throw new TagAttributeException(this.locator(), "The value '" + fieldName + "' from attribute '" + attrAttrName + "' is no valid column within table '" + this.valuesAttr + "'.", ex);
                }
            }
            colIndex = col.getIndex();
            while (row != null) {
                try {
                    segmentLabels.add(row.getString(colIndex));
                    row = null;
                    if (!iter.hasNext()) continue;
                    row = (Row)iter.next();
                }
                catch (ColumnNotDefinedException cndex) {
                    throw new TagAttributeException(this.locator(), cndex.getMessage(), cndex);
                }
                catch (TypeMismatchException tmex) {
                    throw new TagAttributeException(this.locator(), tmex.getMessage(), tmex);
                }
            }
        } else if (first instanceof String) {
            String label = (String)first;
            while (label != null) {
                segmentLabels.add(label);
                label = null;
                if (!iter.hasNext()) continue;
                label = (String)iter.next();
            }
        } else {
            Object cur = first;
            if (this.segmentFieldAttr == null) {
                throw new TagAttributeException(this.locator(), "The attribute '" + attrAttrName + "' at item 'chart' must be specified for segment-labels.");
            }
            Method getter = null;
            Class<?> beanClazz = cur.getClass();
            Class[] getterParams = new Class[]{};
            try {
                getter = beanClazz.getMethod("get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1), getterParams);
            }
            catch (NoSuchMethodException ex) {
                throw new TagAttributeException(this.locator(), "The value '" + fieldName + "' from attribute '" + attrAttrName + "' is no valid attribute for class '" + beanClazz.getName() + "'.", ex);
            }
            catch (SecurityException ex) {
                throw new TagAttributeException(this.locator(), "The value '" + fieldName + "' from attribute '" + attrAttrName + "' is no valid attribute for class '" + beanClazz.getName() + "'.", ex);
            }
            Object[] getterArgs = new Object[]{};
            while (cur != null) {
                String text = null;
                try {
                    Object value = getter.invoke(cur, getterArgs);
                    if (value != null) {
                        text = value.toString();
                    }
                }
                catch (IllegalAccessException ex) {
                    throw new TagAttributeException(this.locator(), "The value '" + fieldName + "' from attribute '" + attrAttrName + "' is not accessible for class '" + cur.getClass().getName() + "'.", ex);
                }
                catch (InvocationTargetException ex) {
                    throw new TagAttributeException(this.locator(), "The value '" + fieldName + "' from attribute '" + attrAttrName + "' is not accessible for class '" + cur.getClass().getName() + "'.", ex);
                }
                segmentLabels.add(text);
                cur = null;
                if (!iter.hasNext()) continue;
                cur = iter.next();
            }
        }
        return segmentLabels;
    }

    protected Font awtFontFromDocumentFont(DocumentFont font) {
        return this.documentHandler.getAwtFont(font);
    }

    private Iterator getValuesIterator() throws DocumentHandlerException, TagAttributeException {
        Object valuesHolder = this.valuesAttr;
        if (valuesHolder instanceof String) {
            try {
                valuesHolder = this.documentHandler.evalObject("${" + valuesHolder.toString() + "}");
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
            }
        }
        if (valuesHolder == null) {
            return null;
        }
        if (valuesHolder instanceof Collection) {
            return ((Collection)valuesHolder).iterator();
        }
        if (valuesHolder instanceof Iterator) {
            return (Iterator)valuesHolder;
        }
        try {
            Method iteratorMethod = valuesHolder.getClass().getMethod("iterator", iteratorAttributes);
            return (Iterator)iteratorMethod.invoke(valuesHolder, iteratorParameters);
        }
        catch (SecurityException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'values' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'values' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (ClassCastException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'values' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'values' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'values' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (InvocationTargetException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'values' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
    }

    private Iterator getAreaLabelsIterator() throws DocumentHandlerException, TagAttributeException {
        Object valuesHolder = this.areaLabelsAttr;
        if (valuesHolder instanceof String) {
            try {
                valuesHolder = this.documentHandler.evalObject("${" + valuesHolder.toString() + "}");
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(this.locator(), "Evaluation of attribute 'area-labels' failed: " + ex.getMessage(), ex);
            }
        }
        if (valuesHolder == null) {
            return null;
        }
        if (valuesHolder instanceof Collection) {
            return ((Collection)valuesHolder).iterator();
        }
        if (valuesHolder instanceof Iterator) {
            return (Iterator)valuesHolder;
        }
        try {
            Method iteratorMethod = valuesHolder.getClass().getMethod("iterator", iteratorAttributes);
            return (Iterator)iteratorMethod.invoke(valuesHolder, iteratorParameters);
        }
        catch (SecurityException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'area-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'area-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (ClassCastException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'area-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'area-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'area-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (InvocationTargetException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'area-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
    }

    private Iterator getSegmentLabelsIterator() throws DocumentHandlerException, TagAttributeException {
        Object valuesHolder = this.segmentLabelsAttr;
        if (valuesHolder instanceof String) {
            try {
                valuesHolder = this.documentHandler.evalObject("${" + valuesHolder.toString() + "}");
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(this.locator(), "Evaluation of attribute 'segment-labels' failed: " + ex.getMessage(), ex);
            }
        }
        if (valuesHolder == null) {
            return null;
        }
        if (valuesHolder instanceof Collection) {
            return ((Collection)valuesHolder).iterator();
        }
        if (valuesHolder instanceof Iterator) {
            return (Iterator)valuesHolder;
        }
        try {
            Method iteratorMethod = valuesHolder.getClass().getMethod("iterator", iteratorAttributes);
            return (Iterator)iteratorMethod.invoke(valuesHolder, iteratorParameters);
        }
        catch (SecurityException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'segment-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'segment-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (ClassCastException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'segment-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'segment-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'segment-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
        catch (InvocationTargetException ex) {
            throw new TagAttributeException(this.locator(), "The attribute 'segment-labels' at item 'chart' doesn't evaluate to a valid sequence.", ex);
        }
    }

    public void setParameter(String name, Object value) throws DocumentHandlerException {
        if ("values".equals(name)) {
            this.valuesAttr = value;
            return;
        }
        if ("min-value".equals(name)) {
            this.minValueAttr = (Double)value;
            return;
        }
        if ("max-value".equals(name)) {
            this.maxValueAttr = (Double)value;
            return;
        }
        if ("value-fields".equals(name)) {
            this.valueFieldsAttr = value;
            return;
        }
        if ("segment-labels".equals(name)) {
            this.segmentLabelsAttr = value;
            return;
        }
        if ("segment-field".equals(name)) {
            this.segmentFieldAttr = value;
            return;
        }
        if ("area-labels".equals(name)) {
            this.areaLabelsAttr = value;
            return;
        }
        if ("area-field".equals(name)) {
            this.areaFieldAttr = value;
            return;
        }
        if ("title".equals(name)) {
            this.titleItem = (TextChartItem)value;
            return;
        }
        if ("value-scale-description".equals(name)) {
            this.valueScaleDescriptionItem = (TextChartItem)value;
            return;
        }
        if ("segment-scale-description".equals(name)) {
            this.segmentScaleDescriptionItem = (TextChartItem)value;
            return;
        }
        ParameterDefinition pd = (ParameterDefinition)this.chartAttributeDefinitions.get(name);
        if (pd.isList()) {
            this.chartAttributes.setList(name, (List)value);
        } else {
            switch (pd.getType()) {
                case 7: {
                    this.chartAttributes.setBoolean(name, (Boolean)value);
                    break;
                }
                case 2: {
                    this.chartAttributes.setInt(name, (Integer)value);
                    break;
                }
                case 5: {
                    this.chartAttributes.setFloat(name, ((Float)value).floatValue());
                    break;
                }
                case 6: {
                    this.chartAttributes.setDouble(name, (Double)value);
                    break;
                }
                case 1: {
                    this.chartAttributes.setString(name, (String)value);
                    break;
                }
                case 8: {
                    throw new DocumentHandlerException(this.locator(), "Unsupported attribute type Date for attribute " + name + ".");
                }
                case 22: {
                    this.chartAttributes.setColor(name, this.colorFromString(name, value, true));
                    break;
                }
                case 20: {
                    try {
                        DocumentFont descriptionFont = this.documentHandler.getFont((String)value);
                        this.chartAttributes.setFont(name, this.awtFontFromDocumentFont(descriptionFont));
                    }
                    catch (TagAttributeException ex) {}
                    break;
                }
                case 21: {
                    this.chartAttributes.setObject(name, this.documentHandler.lookupFormat((String)value));
                    break;
                }
                case 11: {
                    break;
                }
            }
        }
    }

    public ParameterDefinition getParameterDefinition(String name) {
        return (ParameterDefinition)this.chartAttributeDefinitions.get(name);
    }
}

