/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.SpotColor;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;

public class ColorDefTag
extends BaseDocumentTag {
    private static final AttributeDefinition COLOR_SPACE = new AttributeDefinition("color-space", new String[]{"RGB", "sRGB", "LINEAR_RGB", "GRAY", "CIEXYZ", "PYCC", "CMYK"}, true, "The name of the color space.");
    private static final AttributeDefinition VALUE = new AttributeDefinition("value", 4, true, "The values of the color components in comma separated form. The values can be entered in three forms: float in range from 0.0 to 1.0, integer in range from 0 to 255 and hexadecimal in range from 0x00 to 0xff.");
    private static final AttributeDefinition SPOT_COLOR = new AttributeDefinition("spot-color", 3, false, "Tells wether or not to define the color as a SpotColor or Pantone Color.");
    private static final AttributeDefinition COLOR_NAME = CommonAttributes.NAME.cloneAttrDef("The name of the color definition.");
    public static final String TAG_NAME = "color-def";
    private static final Map COLOR_SPACES = new HashMap();
    private String name = null;
    private ColorSpace colorSpace = null;
    private boolean spotColor = false;
    private float[] components = null;

    public ColorDefTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines a logical color for the document. This defined color can be used by every tag,  which defines a color attribute.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(COLOR_NAME).addDefinition(COLOR_SPACE).addDefinition(VALUE).addDefinition(SPOT_COLOR);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.name = this.getStringAttribute(CommonAttributes.NAME, false, null);
        String colorSpaceName = this.getStringAttribute(COLOR_SPACE, true, null);
        String strValue = this.getStringAttribute(VALUE, true, null);
        this.spotColor = this.getBooleanAttribute(SPOT_COLOR, false, true, null);
        StringTokenizer valueTkn = new StringTokenizer(strValue, ",");
        int numComponents = valueTkn.countTokens();
        this.components = new float[numComponents];
        boolean intValues = false;
        for (int i = 0; i < numComponents; ++i) {
            String component = valueTkn.nextToken();
            try {
                if (component.startsWith("0x")) {
                    int comp = Integer.parseInt(component.substring(2), 16);
                    if (comp < 0 || comp > 255) {
                        throw new TagAttributeException(this.locator(), "Illegal value '" + strValue + "' for attribute '" + "value" + "', all components must be in range from 0x00 to 0xff.");
                    }
                    this.components[i] = comp;
                    intValues = true;
                    continue;
                }
                float comp = Float.parseFloat(component);
                if ((double)comp > 1.0) {
                    intValues = true;
                }
                if (comp < 0.0f || comp > 255.0f) {
                    throw new TagAttributeException(this.locator(), "Illegal value '" + strValue + "' for attribute '" + "value" + "', all components must be in range from 0 to 255 or in range from 0.0 to 1.0 for float values.");
                }
                this.components[i] = comp;
                continue;
            }
            catch (NumberFormatException ex) {
                throw new TagAttributeException(this.locator(), "Illegal value '" + strValue + "' for attribute '" + "value" + "', must define a comma separated list of float, integer or hexadecimal values.");
            }
        }
        Object color = null;
        if ("CMYK".equals(colorSpaceName)) {
            if (numComponents != 4) {
                throw new TagAttributeException(this.locator(), "Illegal value '" + strValue + "' for attribute '" + "value" + "', must define 4 values for components C,M,Y,K.");
            }
            color = intValues ? new CMYKColor((int)this.components[0], (int)this.components[1], (int)this.components[2], (int)this.components[3]) : new CMYKColor(this.components[0], this.components[1], this.components[2], this.components[3]);
        } else if ("RGB".equals(colorSpaceName)) {
            if (numComponents != 3) {
                throw new TagAttributeException(this.locator(), "Illegal value '" + strValue + "' for attribute '" + "value" + "', must define 3 values for components R,G,B.");
            }
            color = intValues ? new Color((int)this.components[0], (int)this.components[1], (int)this.components[2]) : new Color(this.components[0], this.components[1], this.components[2]);
        } else {
            if (intValues) {
                int i = 0;
                while (i < numComponents) {
                    int n = i++;
                    this.components[n] = this.components[n] / 255.0f;
                }
            }
            this.colorSpace = this.getColorSpace(colorSpaceName);
            if (this.colorSpace == null) {
                throw new TagAttributeException(this.locator(), "Illegal value '" + colorSpaceName + "' for attribute '" + "color-space" + "', must be one of RGB, LINEAR_RGB, GRAY, CIEXYZ, PYCC or CMYK.");
            }
            if (numComponents != this.colorSpace.getNumComponents()) {
                throw new TagAttributeException(this.locator(), "Illegal value '" + strValue + "' for attribute '" + "value" + "', must define '" + this.colorSpace.getNumComponents() + " components for " + " color space " + colorSpaceName + ".");
            }
            color = new Color(this.colorSpace, this.components, 1.0f);
        }
        if (this.spotColor) {
            color = new SpotColor(new PdfSpotColor(this.name, 0.0f, (Color)color), 1.0f);
        }
        this.documentHandler.registerColor(this.name, (Color)color);
    }

    private ColorSpace getColorSpace(String colorSpaceName) throws TagAttributeException {
        Object colorSpaceObj = COLOR_SPACES.get(colorSpaceName);
        if (colorSpaceObj == null) {
            return null;
        }
        if (colorSpaceObj instanceof Integer) {
            Integer colorSpaceId = (Integer)colorSpaceObj;
            Map map = COLOR_SPACES;
            synchronized (map) {
                try {
                    ColorSpace cs = ColorSpace.getInstance(colorSpaceId);
                    COLOR_SPACES.put(colorSpaceName, cs);
                    return cs;
                }
                catch (IllegalArgumentException ex) {
                    throw new TagAttributeException(this.locator(), "Unable to load profile for color space '" + colorSpaceName + "', check if the according profile file '" + colorSpaceName + ".pf' is right in place (should be in directory 'cmm' of your JRE installation).");
                }
            }
        }
        return (ColorSpace)colorSpaceObj;
    }

    static {
        COLOR_SPACES.put("sRGB", new Integer(1000));
        COLOR_SPACES.put("LINEAR_RGB", new Integer(1004));
        COLOR_SPACES.put("GRAY", new Integer(1003));
        COLOR_SPACES.put("CIEXYZ", new Integer(1001));
        COLOR_SPACES.put("PYCC", new Integer(1002));
    }
}

