/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.MultiColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.CommonAttributesHolder;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.NewPageHandler;
import org.ujac.print.PhraseHolder;
import org.ujac.print.tag.AddRowTag;
import org.ujac.print.tag.AnchorTag;
import org.ujac.print.tag.AnnotationTag;
import org.ujac.print.tag.AssertTag;
import org.ujac.print.tag.BarcodePdf417Tag;
import org.ujac.print.tag.BarcodeTag;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.DatamatrixTag;
import org.ujac.print.tag.DefineTableTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.ImportTag;
import org.ujac.print.tag.IndexTag;
import org.ujac.print.tag.ListTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.NewLineTag;
import org.ujac.print.tag.NewPageTag;
import org.ujac.print.tag.OutlineTag;
import org.ujac.print.tag.ParagraphTag;
import org.ujac.print.tag.PdfTableTag;
import org.ujac.print.tag.PhraseTag;
import org.ujac.print.tag.SetFormatTag;
import org.ujac.print.tag.SetPropertyTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.TocTag;
import org.ujac.util.StringUtils;

public class ColumnTextTag
extends BaseElementTag
implements PhraseHolder,
ElementContainer,
FontHolder,
NewPageHandler {
    private static final AttributeDefinition COLUMNS = new AttributeDefinition("columns", 1, true, "The number of columns to use.");
    private static final AttributeDefinition HEIGHT = new AttributeDefinition("height", 4, false, "The fixed height of the column text area.");
    private static final AttributeDefinition PADDING = CommonAttributes.PADDING.cloneAttrDef("The horizontal padding between the columns.");
    private static final AttributeDefinition PADDING_STYLE = CommonStyleAttributes.PADDING.cloneAttrDef("The horizontal padding between the columns.");
    private static final AttributeDefinition HORIZONTAL_ALIGNMENT = CommonAttributes.HORIZONTAL_ALIGNMENT.cloneAttrDef("The horizontal alignment of the column contents.");
    private static final AttributeDefinition HORIZONTAL_ALIGNMENT_STYLE = CommonStyleAttributes.HORIZONTAL_ALIGNMENT.cloneAttrDef("The horizontal alignment of the column contents.");
    public static final String TAG_NAME = "column-text";
    private MultiColumnText columnText = null;
    private int numColumns = 0;
    private float columnPadding = 0.0f;
    private int columnAlignment = 3;
    private float leading = 0.0f;
    private float lineSpacing = 0.0f;
    private float height = -1.0f;
    private int numElements = 0;
    private Phrase phrase = null;

    public ColumnTextTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Splits the output area in several columns.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(COLUMNS).addDefinition(PADDING).addDefinition(HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(HEIGHT);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(COLUMNS).addDefinition(PADDING_STYLE).addDefinition(HORIZONTAL_ALIGNMENT_STYLE).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(HEIGHT);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(PhraseTag.class, 0, 999)).addDefinition(new ChildDefinition(ParagraphTag.class, 0, 999)).addDefinition(new ChildDefinition(SetFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(SetPropertyTag.class, 0, 999)).addDefinition(new ChildDefinition(DefineTableTag.class, 0, 999)).addDefinition(new ChildDefinition(AddRowTag.class, 0, 999)).addDefinition(new ChildDefinition(AssertTag.class, 0, 999)).addDefinition(new ChildDefinition(AnchorTag.class, 0, 999)).addDefinition(new ChildDefinition(AnnotationTag.class, 0, 999)).addDefinition(new ChildDefinition(ImageTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodeTag.class, 0, 999)).addDefinition(new ChildDefinition(DatamatrixTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodePdf417Tag.class, 0, 999)).addDefinition(new ChildDefinition(ImportTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(NewLineTag.class, 0, 999)).addDefinition(new ChildDefinition(NewPageTag.class, 0, 999)).addDefinition(new ChildDefinition(OutlineTag.class, 0, 999)).addDefinition(new ChildDefinition(ListTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfTableTag.class, 0, 999)).addDefinition(new ChildDefinition(TocTag.class, 0, 999)).addDefinition(new ChildDefinition(IndexTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        CommonAttributesHolder commonAttributesHolder = this.getCommonAttributesHolder();
        this.leading = this.isAttributeDefined(CommonAttributes.LEADING, CommonStyleAttributes.LEADING) ? this.getDimensionAttribute(CommonAttributes.LEADING, true, CommonStyleAttributes.LEADING) : commonAttributesHolder.getLeading();
        this.lineSpacing = this.isAttributeDefined(CommonAttributes.LINE_SPACING, CommonStyleAttributes.LINE_SPACING) ? this.getDimensionAttribute(CommonAttributes.LINE_SPACING, true, CommonStyleAttributes.LINE_SPACING) : commonAttributesHolder.getLineSpacing();
        this.height = this.getDimensionAttribute(HEIGHT, -1.0f, true, HEIGHT);
        this.numColumns = this.getIntegerAttribute(COLUMNS, true, null);
        this.columnPadding = this.getIntegerAttribute(CommonAttributes.PADDING, true, CommonStyleAttributes.PADDING);
        this.columnAlignment = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, 3, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT);
        this.setupMultiColumnText();
    }

    private void setupMultiColumnText() {
        this.columnText = new MultiColumnText(this.height);
        PdfWriter pdfWriter = (PdfWriter)this.getDocumentHandler().getDocumentWriter();
        PdfContentByte cb = pdfWriter.getDirectContent();
        ColumnText confText = new ColumnText(cb);
        confText.setAlignment(this.columnAlignment);
        confText.setLeading(this.leading, this.lineSpacing);
        this.columnText.useColumnParams(confText);
        Document document = this.documentHandler.getDocument();
        Rectangle ouputSize = document.getPageSize();
        float ouputWidth = ouputSize.getWidth() - document.leftMargin() - document.rightMargin();
        float columnWidth = (ouputWidth - this.columnPadding * (float)(this.numColumns - 1)) / (float)this.numColumns;
        float hPos = document.left();
        for (int i = 0; i < this.numColumns; ++i) {
            this.columnText.addSimpleColumn(hPos, hPos + columnWidth);
            hPos += columnWidth + this.columnPadding;
        }
        this.phrase = null;
        this.numElements = 0;
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        ElementContainer elementContainer = this.getElementContainer();
        elementContainer.addElement(this, (Element)this.columnText);
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        block8: {
            if (element == null) {
                return;
            }
            this.addContentPhrase();
            ++this.numElements;
            try {
                if (element instanceof Paragraph) {
                    this.columnText.addElement(element);
                    break block8;
                }
                if (element instanceof Phrase) {
                    this.columnText.addElement((Element)new Paragraph((Phrase)element));
                    break block8;
                }
                if (element instanceof Image) {
                    this.columnText.addElement(element);
                    break block8;
                }
                if (element instanceof List) {
                    this.columnText.addElement(element);
                    break block8;
                }
                if (element instanceof PdfPTable) {
                    this.columnText.addElement(element);
                    break block8;
                }
                throw new DocumentHandlerException(this.locator(), "ColumnTexts musten't contain elements other than tables, phrases, images, lists or paragraphs.");
            }
            catch (DocumentException ex) {
                throw new DocumentHandlerException(this.locator(), "Unable to add element '" + element.getClass().getName() + " <column-text> element.");
            }
        }
    }

    public boolean isTopLevel() {
        return true;
    }

    public void flushContent() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.isEmptyContent()) {
            this.resetContent();
            return;
        }
        if (this.isTrimNextHead()) {
            this.trimContentHead();
            this.setTrimNextHead(false);
        }
        if (this.isItemClosed() && this.isTrimBody()) {
            this.trimContentTail();
        }
        if (this.phrase == null) {
            this.phrase = new Phrase(0.0f);
        }
        this.phrase = this.addChunk(this.phrase, this.getLeading(), this.getLineSpacing());
        this.resetContent();
    }

    private void addContentPhrase() throws DocumentHandlerException {
        try {
            if (this.phrase != null) {
                if (!this.phrase.isEmpty()) {
                    ++this.numElements;
                    this.columnText.addElement((Element)new Paragraph(this.phrase));
                }
                this.phrase = null;
            }
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add content to the <colmn-text> element.");
        }
    }

    public void addChunk(BaseDocumentTag item, String chunk, DocumentFont font) throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.phrase == null) {
            this.phrase = new Phrase(0.0f);
            if (this.isTrimBody()) {
                chunk = StringUtils.trimHead(chunk);
            }
        }
        this.addChunk(item, this.phrase, chunk, font, this.getLeading(), this.getLineSpacing());
    }

    public void addChunk(BaseDocumentTag item, Chunk chunk) throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.phrase == null) {
            this.phrase = new Phrase(0.0f);
        }
        this.addChunk(this.phrase, chunk, this.getLeading(), this.getLineSpacing());
    }

    public float getLeading() {
        return this.leading;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public Document handleNewPage(Rectangle size, Rectangle margins) throws DocumentHandlerException {
        Document document = this.documentHandler.getDocument();
        if (!this.isValid()) {
            return document;
        }
        ElementContainer elementContainer = this.getElementContainer();
        elementContainer.addElement(this, (Element)this.columnText);
        try {
            if (size != null) {
                document.setPageSize(size);
            }
            if (margins != null) {
                document.setMargins(margins.getBorderWidthLeft(), margins.getBorderWidthRight(), margins.getBorderWidthTop(), margins.getBorderWidthBottom());
            }
            document.newPage();
            this.setupMultiColumnText();
        }
        catch (Exception ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to start a new page: " + ex.getMessage(), ex);
        }
        return document;
    }
}

